/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.maven.Bundle;
import org.netbeans.modules.maven.problems.ProblemReporterImpl;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class M2AuxilaryConfigImpl
implements AuxiliaryConfiguration {
    public static final String BROKEN_NBCONFIG = "BROKENNBCONFIG";
    private static final String AUX_CONFIG = "AuxilaryConfiguration";
    public static final String CONFIG_FILE_NAME = "nb-configuration.xml";
    private static final Logger LOG = Logger.getLogger(M2AuxilaryConfigImpl.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(M2AuxilaryConfigImpl.class);
    private static final int SAVING_DELAY = 100;
    private RequestProcessor.Task savingTask;
    private Document scheduledDocument;
    private Document cachedDoc;
    private static final Document DELETED_FILE_DOCUMENT = XMLUtil.createDocument((String)"AuxilaryConfiguration", null, null, null);
    private static final Document BROKEN_DOCUMENT = XMLUtil.createDocument((String)"AuxilaryConfiguration", null, null, null);
    private final Object configIOLock = new Object();
    private final FileObject projectDirectory;
    private ProblemProvider pp;
    private final FileChangeAdapter fileChange;
    private final AtomicBoolean fileChangeSet = new AtomicBoolean(false);
    private static final DocumentBuilder db;

    public M2AuxilaryConfigImpl(FileObject dir, boolean longtermInstance) {
        this.projectDirectory = dir;
        if (longtermInstance) {
            this.pp = new ProblemProvider();
            this.fileChange = new FileChangeAdapter(){

                public void fileRenamed(FileRenameEvent fe) {
                    if (M2AuxilaryConfigImpl.CONFIG_FILE_NAME.equals(fe.getName() + "." + fe.getExt())) {
                        M2AuxilaryConfigImpl.this.resetCache();
                    }
                }

                public void fileDeleted(FileEvent fe) {
                    if (M2AuxilaryConfigImpl.CONFIG_FILE_NAME.equals(fe.getFile().getNameExt())) {
                        M2AuxilaryConfigImpl.this.resetCache();
                    }
                }

                public void fileChanged(FileEvent fe) {
                    if (M2AuxilaryConfigImpl.CONFIG_FILE_NAME.equals(fe.getFile().getNameExt())) {
                        M2AuxilaryConfigImpl.this.resetCache();
                    }
                }

                public void fileDataCreated(FileEvent fe) {
                    if (M2AuxilaryConfigImpl.CONFIG_FILE_NAME.equals(fe.getFile().getNameExt())) {
                        M2AuxilaryConfigImpl.this.resetCache();
                    }
                }
            };
            this.savingTask = RP.create(new Runnable(){

                @Override
                public void run() {
                    try {
                        M2AuxilaryConfigImpl.this.projectDirectory.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() throws IOException {
                                Document doc;
                                Object object = M2AuxilaryConfigImpl.this;
                                synchronized (object) {
                                    doc = M2AuxilaryConfigImpl.this.scheduledDocument;
                                    if (doc == null) {
                                        return;
                                    }
                                    M2AuxilaryConfigImpl.this.scheduledDocument = null;
                                }
                                object = M2AuxilaryConfigImpl.this.configIOLock;
                                synchronized (object) {
                                    FileObject config = M2AuxilaryConfigImpl.this.projectDirectory.getFileObject(M2AuxilaryConfigImpl.CONFIG_FILE_NAME);
                                    if (doc.getDocumentElement().getElementsByTagName("*").getLength() > 0) {
                                        LOG.log(Level.FINEST, "Write configuration file for {0}", M2AuxilaryConfigImpl.this.projectDirectory);
                                        try (OutputStream out = config == null ? M2AuxilaryConfigImpl.this.projectDirectory.createAndOpen(M2AuxilaryConfigImpl.CONFIG_FILE_NAME) : config.getOutputStream();){
                                            XMLUtil.write((Document)doc, (OutputStream)out, (String)"UTF-8");
                                        }
                                    } else if (config != null) {
                                        LOG.log(Level.FINEST, "Delete empty configuration file for {0}", M2AuxilaryConfigImpl.this.projectDirectory);
                                        config.delete();
                                    }
                                }
                            }
                        });
                    }
                    catch (IOException ex) {
                        LOG.log(Level.INFO, "IO Error while saving " + M2AuxilaryConfigImpl.this.projectDirectory.getFileObject(M2AuxilaryConfigImpl.CONFIG_FILE_NAME), ex);
                    }
                }
            });
        } else {
            this.fileChange = null;
            this.fileChangeSet.set(true);
        }
    }

    private synchronized void resetCache() {
        this.cachedDoc = null;
    }

    public ProjectProblemsProvider getProblemProvider() {
        return this.pp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document loadConfig(FileObject config) throws IOException, SAXException {
        Object object = this.configIOLock;
        synchronized (object) {
            return XMLUtil.parse((InputSource)new InputSource(config.toURL().toString()), (boolean)false, (boolean)true, null, null);
        }
    }

    public Element getConfigurationFragment(String elementName, String namespace, boolean shared) {
        Element e = this.doGetConfigurationFragment(elementName, namespace, shared);
        return e != null ? M2AuxilaryConfigImpl.cloneSafely(e) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Element cloneSafely(Element el) {
        DocumentBuilder documentBuilder = db;
        synchronized (documentBuilder) {
            Document dummy = db.newDocument();
            return (Element)dummy.importNode(el, true);
        }
    }

    private synchronized Element doGetConfigurationFragment(String elementName, String namespace, boolean shared) {
        this.lazyAttachListener();
        if (shared) {
            if (this.scheduledDocument != null) {
                try {
                    Element el = XMLUtil.findElement((Element)this.scheduledDocument.getDocumentElement(), (String)elementName, (String)namespace);
                    if (el != null) {
                        el = (Element)el.cloneNode(true);
                    }
                    return el;
                }
                catch (IllegalArgumentException iae) {
                    LOG.log(Level.INFO, iae.getMessage(), iae);
                }
            }
            if (this.cachedDoc == null) {
                final FileObject config = this.projectDirectory.getFileObject(CONFIG_FILE_NAME);
                if (config != null) {
                    try {
                        Document doc;
                        this.cachedDoc = doc = this.loadConfig(config);
                        if (this.pp != null) {
                            this.pp.setProblem(null);
                            M2AuxilaryConfigImpl.findDuplicateElements(doc.getDocumentElement(), this.pp, config);
                        }
                        return XMLUtil.findElement((Element)doc.getDocumentElement(), (String)elementName, (String)namespace);
                    }
                    catch (SAXException ex) {
                        if (this.pp != null) {
                            RP.post(new Runnable(){

                                @Override
                                public void run() {
                                    M2AuxilaryConfigImpl.this.pp.setProblem(ProjectProblemsProvider.ProjectProblem.createWarning((String)Bundle.TXT_Problem_Broken_Config(), (String)Bundle.DESC_Problem_Broken_Config(ex.getMessage()), (ProjectProblemResolver)new ProblemReporterImpl.MavenProblemResolver(ProblemReporterImpl.createOpenFileAction(config), M2AuxilaryConfigImpl.BROKEN_NBCONFIG)));
                                }
                            });
                        }
                        LOG.log(Level.INFO, ex.getMessage(), ex);
                        this.cachedDoc = BROKEN_DOCUMENT;
                    }
                    catch (IOException ex) {
                        LOG.log(Level.INFO, "IO Error while loading " + config.getPath(), ex);
                        this.cachedDoc = BROKEN_DOCUMENT;
                    }
                    catch (IllegalArgumentException iae) {
                        LOG.log(Level.INFO, iae.getMessage(), iae);
                    }
                    return null;
                }
                this.cachedDoc = DELETED_FILE_DOCUMENT;
                return null;
            }
            if (this.cachedDoc == DELETED_FILE_DOCUMENT || this.cachedDoc == BROKEN_DOCUMENT) {
                return null;
            }
            try {
                return XMLUtil.findElement((Element)this.cachedDoc.getDocumentElement(), (String)elementName, (String)namespace);
            }
            catch (IllegalArgumentException iae) {
                LOG.log(Level.INFO, iae.getMessage(), iae);
                return null;
            }
        }
        String str = (String)this.projectDirectory.getAttribute(AUX_CONFIG);
        if (str != null) {
            try {
                Document doc = XMLUtil.parse((InputSource)new InputSource(new StringReader(str)), (boolean)false, (boolean)true, null, null);
                return XMLUtil.findElement((Element)doc.getDocumentElement(), (String)elementName, (String)namespace);
            }
            catch (SAXException ex) {
                LOG.log(Level.FINE, "cannot parse", ex);
            }
            catch (IOException ex) {
                LOG.log(Level.FINE, "error reading private auxiliary configuration", ex);
            }
        }
        return null;
    }

    private void lazyAttachListener() {
        if (this.fileChangeSet.compareAndSet(false, true)) {
            this.projectDirectory.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.fileChange, (Object)this.projectDirectory));
        }
    }

    public synchronized void putConfigurationFragment(Element fragment, boolean shared) throws IllegalArgumentException {
        this.lazyAttachListener();
        Document doc = null;
        if (shared) {
            if (this.scheduledDocument != null) {
                doc = this.scheduledDocument;
            } else {
                FileObject config = this.projectDirectory.getFileObject(CONFIG_FILE_NAME);
                if (config != null) {
                    try {
                        doc = this.loadConfig(config);
                    }
                    catch (SAXException ex) {
                        LOG.log(Level.INFO, "Cannot parse file " + config.getPath(), ex);
                        if (config.getSize() == 0L) {
                            doc = this.createNewSharedDocument();
                        }
                    }
                    catch (IOException ex) {
                        LOG.log(Level.INFO, "IO Error with " + config.getPath(), ex);
                    }
                } else {
                    doc = this.createNewSharedDocument();
                }
            }
        } else {
            String str = (String)this.projectDirectory.getAttribute(AUX_CONFIG);
            if (str != null) {
                try {
                    doc = XMLUtil.parse((InputSource)new InputSource(new StringReader(str)), (boolean)false, (boolean)true, null, null);
                }
                catch (SAXException ex) {
                    LOG.log(Level.FINE, "cannot parse", ex);
                }
                catch (IOException ex) {
                    LOG.log(Level.FINE, "error reading private auxiliary configuration", ex);
                }
            }
            if (doc == null) {
                String element = "project-private";
                doc = XMLUtil.createDocument((String)element, null, null, null);
            }
        }
        if (doc != null) {
            Element el = XMLUtil.findElement((Element)doc.getDocumentElement(), (String)fragment.getNodeName(), (String)fragment.getNamespaceURI());
            if (el != null) {
                doc.getDocumentElement().removeChild(el);
            }
            doc.getDocumentElement().appendChild(doc.importNode(fragment, true));
            if (shared) {
                if (this.scheduledDocument == null) {
                    this.scheduledDocument = doc;
                }
                LOG.log(Level.FINEST, "Schedule saving of configuration fragment for " + this.projectDirectory, new Exception());
                this.savingTask.schedule(100);
            } else {
                try {
                    ByteArrayOutputStream wr = new ByteArrayOutputStream();
                    XMLUtil.write((Document)doc, (OutputStream)wr, (String)"UTF-8");
                    this.projectDirectory.setAttribute(AUX_CONFIG, (Object)wr.toString("UTF-8"));
                }
                catch (IOException ex) {
                    LOG.log(Level.FINE, "error writing private auxiliary configuration", ex);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean removeConfigurationFragment(String elementName, String namespace, boolean shared) throws IllegalArgumentException {
        this.lazyAttachListener();
        Document doc = null;
        FileObject config = this.projectDirectory.getFileObject(CONFIG_FILE_NAME);
        if (shared) {
            if (this.scheduledDocument != null) {
                doc = this.scheduledDocument;
            } else {
                if (config == null) return false;
                try {
                    try {
                        doc = this.loadConfig(config);
                    }
                    catch (SAXException ex) {
                        LOG.log(Level.INFO, "Cannot parse file " + config.getPath(), ex);
                        if (config.getSize() != 0L) return true;
                        config.delete();
                        return true;
                    }
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, "IO Error with " + config.getPath(), ex);
                }
            }
        } else {
            String str = (String)this.projectDirectory.getAttribute(AUX_CONFIG);
            if (str == null) return false;
            try {
                doc = XMLUtil.parse((InputSource)new InputSource(new StringReader(str)), (boolean)false, (boolean)true, null, null);
            }
            catch (SAXException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (doc == null) return true;
        Element el = XMLUtil.findElement((Element)doc.getDocumentElement(), (String)elementName, (String)namespace);
        if (el != null) {
            doc.getDocumentElement().removeChild(el);
        }
        if (shared) {
            if (this.scheduledDocument == null) {
                this.scheduledDocument = doc;
            }
            LOG.log(Level.FINEST, "Schedule saving of configuration fragment for " + this.projectDirectory, new Exception());
            this.savingTask.schedule(100);
            return true;
        }
        try {
            ByteArrayOutputStream wr = new ByteArrayOutputStream();
            XMLUtil.write((Document)doc, (OutputStream)wr, (String)"UTF-8");
            this.projectDirectory.setAttribute(AUX_CONFIG, (Object)wr.toString("UTF-8"));
            return true;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return true;
    }

    private Document createNewSharedDocument() throws DOMException {
        String element = "project-shared-configuration";
        Document doc = XMLUtil.createDocument((String)element, null, null, null);
        doc.getDocumentElement().appendChild(doc.createComment("\nThis file contains additional configuration written by modules in the NetBeans IDE.\nThe configuration is intended to be shared among all the users of project and\ntherefore it is assumed to be part of version control checkout.\nWithout this configuration present, some functionality in the IDE may be limited or fail altogether.\n"));
        return doc;
    }

    static void findDuplicateElements(@NonNull Element parent, @NonNull ProblemProvider pp, FileObject config) {
        NodeList l = parent.getChildNodes();
        int nodeCount = l.getLength();
        HashSet<String> known = new HashSet<String>();
        for (int i = 0; i < nodeCount; ++i) {
            Node node;
            String localName;
            String id;
            if (l.item(i).getNodeType() != 1 || known.add(id = (localName = (localName = (node = l.item(i)).getLocalName()) == null ? node.getNodeName() : localName) + "|" + node.getNamespaceURI())) continue;
            pp.setProblem(ProjectProblemsProvider.ProjectProblem.createWarning((String)Bundle.TXT_Problem_Broken_Config2(), (String)Bundle.DESC_Problem_Broken_Config2(), (ProjectProblemResolver)new ProblemReporterImpl.MavenProblemResolver(ProblemReporterImpl.createOpenFileAction(config), BROKEN_NBCONFIG)));
        }
    }

    static {
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private class ProblemProvider
    implements ProjectProblemsProvider {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private ProjectProblemsProvider.ProjectProblem pp;

        void setProblem(ProjectProblemsProvider.ProjectProblem pp) {
            this.pp = pp;
            if (pp == null && this.pp == null) {
                return;
            }
            this.pcs.firePropertyChange("problems", null, null);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
            if (this.pp != null) {
                return Collections.singleton(this.pp);
            }
            return Collections.emptyList();
        }
    }
}

