/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.vars.impl;

import java.util.function.Supplier;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.truffle.LanguageName;
import org.netbeans.modules.debugger.jpda.truffle.source.SourcePosition;
import org.netbeans.modules.debugger.jpda.truffle.vars.TruffleVariable;
import org.netbeans.modules.debugger.jpda.truffle.vars.impl.TruffleVariableImpl;

public class TruffleStackVariable
implements TruffleVariable {
    private final JPDADebugger debugger;
    private final String name;
    private final LanguageName language;
    private String type;
    private final boolean readable;
    private final boolean writable;
    private final boolean internal;
    private String valueStr;
    private boolean hasValueSource;
    private boolean hasTypeSource;
    private Supplier<SourcePosition> valueSourceSupp;
    private Supplier<SourcePosition> typeSourceSupp;
    private SourcePosition valueSource;
    private SourcePosition typeSource;
    private ObjectVariable guestObj;
    private final boolean isReceiver;
    private boolean leaf;

    public TruffleStackVariable(JPDADebugger debugger, String name, LanguageName language, String type, boolean readable, boolean writable, boolean internal, String valueStr, boolean hasValueSource, Supplier<SourcePosition> valueSource, boolean hasTypeSource, Supplier<SourcePosition> typeSource, boolean isReceiver, ObjectVariable truffleObj) {
        this.debugger = debugger;
        this.name = name;
        this.language = language;
        this.type = type;
        this.readable = readable;
        this.writable = writable;
        this.internal = internal;
        this.valueStr = valueStr;
        this.hasValueSource = hasValueSource;
        this.hasTypeSource = hasTypeSource;
        this.valueSourceSupp = valueSource;
        this.typeSourceSupp = typeSource;
        this.guestObj = truffleObj;
        this.isReceiver = isReceiver;
        this.leaf = TruffleVariableImpl.isLeaf(truffleObj);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LanguageName getLanguage() {
        return this.language;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isReadable() {
        return this.readable;
    }

    @Override
    public boolean isWritable() {
        return this.writable;
    }

    @Override
    public boolean isInternal() {
        return this.internal;
    }

    @Override
    public Object getValue() {
        return this.valueStr;
    }

    @Override
    public String getDisplayValue() {
        return this.valueStr;
    }

    @Override
    public ObjectVariable setValue(JPDADebugger debugger, String newExpression) {
        if (this.valueStr.equals(newExpression)) {
            return null;
        }
        ObjectVariable newGuestObject = TruffleVariableImpl.setValue(debugger, this.guestObj, newExpression);
        if (newGuestObject != null) {
            this.guestObj = newGuestObject;
            TruffleVariableImpl newVar = TruffleVariableImpl.get((Variable)newGuestObject);
            this.type = newVar.getType();
            this.valueStr = newVar.getValue().toString();
            this.typeSource = null;
            this.valueSource = null;
            this.hasValueSource = newVar.hasValueSource();
            this.hasTypeSource = newVar.hasTypeSource();
            this.valueSourceSupp = () -> newVar.getValueSource();
            this.typeSourceSupp = () -> newVar.getTypeSource();
            this.leaf = TruffleVariableImpl.isLeaf(this.guestObj);
        }
        return newGuestObject;
    }

    @Override
    public boolean hasValueSource() {
        return this.hasValueSource;
    }

    @Override
    public synchronized SourcePosition getValueSource() {
        if (this.valueSource == null) {
            this.valueSource = this.valueSourceSupp.get();
        }
        return this.valueSource;
    }

    @Override
    public boolean hasTypeSource() {
        return this.hasTypeSource;
    }

    @Override
    public synchronized SourcePosition getTypeSource() {
        if (this.typeSource == null) {
            this.typeSource = this.typeSourceSupp.get();
        }
        return this.typeSource;
    }

    @Override
    public boolean isLeaf() {
        return this.leaf;
    }

    @Override
    public Object[] getChildren() {
        return TruffleVariableImpl.getChildren(this.guestObj);
    }

    @Override
    public boolean isReceiver() {
        return this.isReceiver;
    }
}

