/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2.mi;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.debugger.gdb2.mi.Log;

public class MIUserInteraction {
    private final boolean empty;
    private final String[] items;
    private int cancelIndex = -1;
    private int allIndex = -1;
    private int firstChoice = -1;

    MIUserInteraction(String consoleStream) {
        if (consoleStream == null) {
            this.empty = true;
            this.items = new String[0];
            return;
        }
        this.empty = false;
        ArrayList<String> lines = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(consoleStream, "\n");
        while (st.hasMoreTokens()) {
            lines.add(st.nextToken());
        }
        if (Log.MI.ui) {
            System.out.printf("USER INTERACTION LINES:\n", new Object[0]);
            for (String line : lines) {
                System.out.printf("\t'%s'\n", line);
            }
        }
        Pattern p = Pattern.compile("\\[(\\d+)\\] (.+)");
        ArrayList<String> itemList = new ArrayList<String>();
        boolean cx = false;
        if (Log.MI.ui) {
            System.out.printf("PARSED based on '%s'\n", p.pattern());
        }
        for (String line : lines) {
            Matcher m = p.matcher(line);
            if (m.matches()) {
                String choice;
                if (Log.MI.ui) {
                    System.out.printf("'%s' '%s'\n", m.group(1), m.group(2));
                }
                if ("cancel".equals(choice = m.group(2))) {
                    this.cancelIndex = Integer.parseInt(m.group(1));
                    continue;
                }
                if ("all".equals(choice)) {
                    this.allIndex = Integer.parseInt(m.group(1));
                    continue;
                }
                if (this.firstChoice == -1) {
                    this.firstChoice = Integer.parseInt(m.group(1));
                }
                itemList.add(choice);
                continue;
            }
            if (!Log.MI.ui) continue;
            System.out.printf("No match\n", new Object[0]);
        }
        this.items = new String[itemList.size()];
        itemList.toArray(this.items);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean hasCancel() {
        return this.cancelIndex != -1;
    }

    public boolean hasAll() {
        return this.allIndex != -1;
    }

    public int cancelChoice() {
        return this.cancelIndex;
    }

    public int allChoice() {
        return this.allIndex;
    }

    public int firstChoice() {
        return this.firstChoice;
    }

    public String[] items() {
        return this.items;
    }
}

