/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.ui.api;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gsf.testrunner.api.CommonUtils;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.ui.ResultDisplayHandler;
import org.netbeans.modules.gsf.testrunner.ui.ResultWindow;
import org.netbeans.modules.gsf.testrunner.ui.StatisticsPanel;
import org.netbeans.modules.gsf.testrunner.ui.api.Bundle;
import org.netbeans.modules.gsf.testrunner.ui.api.DefaultTestRunnerNodeFactory;
import org.netbeans.modules.gsf.testrunner.ui.api.OutputLineHandler;
import org.netbeans.modules.gsf.testrunner.ui.api.TestRunnerNodeFactory;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.NbPreferences;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;
import org.openide.windows.InputOutput;
import org.openide.windows.Mode;
import org.openide.windows.OutputWriter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class Manager {
    private static Reference<Manager> instanceRef;
    private final Set<TestSession> testSessions = new WeakSet(5);
    private final boolean lateWindowPromotion;
    private static final Logger LOGGER;
    public static final String JUNIT_TF = "junit";
    public static final String TESTNG_TF = "testng";
    private Notification bubbleNotification = null;
    private final RequestProcessor.Task bubbleTask;
    private final RequestProcessor RP = new RequestProcessor(Manager.class.getName(), 1, true);
    private TestRunnerNodeFactory nodeFactory;
    private OutputLineHandler lineHandler;
    private static final OutputLineHandler DEFAULT_LINE_HANDLER;
    private Map<TestSession, WeakReference<ResultDisplayHandler>> displayHandlers;
    private Semaphore lock;
    private Map<TestSession, Boolean> displaysMap;

    public OutputLineHandler getOutputLineHandler() {
        return this.lineHandler != null ? this.lineHandler : DEFAULT_LINE_HANDLER;
    }

    public void setOutputLineHandler(OutputLineHandler lineHandler) {
        Parameters.notNull((CharSequence)"lineHandler", (Object)lineHandler);
        this.lineHandler = lineHandler;
    }

    public TestRunnerNodeFactory getNodeFactory() {
        if (this.nodeFactory == null) {
            this.nodeFactory = new DefaultTestRunnerNodeFactory();
        }
        return this.nodeFactory;
    }

    public void setNodeFactory(TestRunnerNodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public void setTestingFramework(String testingFramework) {
        CommonUtils.getInstance().setTestingFramework(testingFramework);
    }

    public String getTestingFramework() {
        return CommonUtils.getInstance().getTestingFramework();
    }

    public static Manager getInstance() {
        Manager manager;
        if (instanceRef != null && (manager = instanceRef.get()) != null) {
            return manager;
        }
        final Manager instance = new Manager();
        ResultWindow.getInstance().addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                instance.updateDisplayHandlerLayouts();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                instance.updateDisplayHandlerLayouts();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                instance.updateDisplayHandlerLayouts();
            }
        });
        instanceRef = new WeakReference<Manager>(instance);
        return instance;
    }

    private void updateDisplayHandlerLayouts() {
        int y;
        int x = ResultWindow.getInstance().getWidth();
        int orientation = x > (y = ResultWindow.getInstance().getHeight()) ? 1 : 0;
        ResultWindow.getInstance().setOrientation(orientation);
    }

    private Manager() {
        this.lateWindowPromotion = true;
        this.bubbleTask = this.RP.create(new Runnable(){

            @Override
            public void run() {
                Manager.this.bubbleNotification.clear();
            }
        });
    }

    public synchronized void emptyTestRun(TestSession session) {
        this.testStarted(session);
        this.sessionFinished(session);
    }

    public synchronized void testStarted(TestSession session) {
        this.displayMessage(session, Bundle.LBL_RunningTests());
        if (session.getStartingMsg() != null) {
            this.displayOutput(session, session.getStartingMsg(), true);
        }
    }

    public synchronized void sessionFinished(TestSession session) {
        if (!this.testSessions.contains(session)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Finishing an unknown session: " + session);
            }
            return;
        }
        this.displayMessage(session, null, true);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Finishing session: " + session);
        }
        this.testSessions.remove(session);
    }

    public synchronized void displayOutput(TestSession session, String text, boolean error) {
        ResultDisplayHandler displayHandler = this.getDisplayHandler(session);
        displayHandler.displayOutput(text, error);
        this.displayInWindow(session, displayHandler);
    }

    public synchronized void displaySuiteRunning(TestSession session, String suiteName) {
        ResultDisplayHandler displayHandler = this.getDisplayHandler(session);
        displayHandler.displaySuiteRunning(suiteName);
        this.displayInWindow(session, displayHandler);
    }

    public synchronized void displaySuiteRunning(TestSession session, TestSuite suite) {
        ResultDisplayHandler displayHandler = this.getDisplayHandler(session);
        displayHandler.displaySuiteRunning(suite);
        this.displayInWindow(session, displayHandler);
    }

    public void displayReport(TestSession session, Report report) {
        this.displayReport(session, report, true);
    }

    public synchronized void displayReport(TestSession session, Report report, boolean completed) {
        report.setCompleted(completed);
        ResultDisplayHandler displayHandler = this.getDisplayHandler(session);
        displayHandler.displayReport(report);
        this.displayInWindow(session, displayHandler);
    }

    private void displayMessage(TestSession session, String message) {
        this.displayMessage(session, message, false);
    }

    private void displayMessage(TestSession session, String message, boolean sessionEnd) {
        ResultDisplayHandler displayHandler = this.getDisplayHandler(session);
        this.displayInWindow(session, displayHandler, sessionEnd);
        if (!sessionEnd) {
            displayHandler.displayMessage(message);
        } else {
            displayHandler.displayMessageSessionFinished(message);
        }
    }

    private void displayInWindow(TestSession session, ResultDisplayHandler displayHandler) {
        this.displayInWindow(session, displayHandler, false);
    }

    private void displayInWindow(final TestSession session, final ResultDisplayHandler displayHandler, boolean sessionEnd) {
        boolean firstDisplay;
        boolean bl = firstDisplay = this.testSessions.add(session);
        boolean promote = session.getSessionType() == TestSession.SessionType.TEST ? firstDisplay || sessionEnd : sessionEnd;
        TestSession.SessionResult sessionResult = session.getSessionResult();
        boolean automaticallyOpen = NbPreferences.forModule(StatisticsPanel.class).getBoolean("alwaysOpenTRW", false);
        if (automaticallyOpen || sessionResult.getErrors() + sessionResult.getFailed() > 0) {
            int displayIndex = this.getDisplayIndex(session);
            if (displayIndex == -1) {
                this.addDisplay(session);
                Mutex.EVENT.writeAccess((Runnable)new Displayer(displayHandler, promote));
            } else if (promote) {
                Mutex.EVENT.writeAccess((Runnable)new Displayer(null, promote));
            }
        } else if (sessionEnd) {
            Mutex.EVENT.writeAccess(new Runnable(){

                @Override
                public void run() {
                    boolean isInSlidingMode;
                    final ResultWindow window = ResultWindow.getInstance();
                    Mode mode = WindowManager.getDefault().findMode((TopComponent)window);
                    boolean bl = isInSlidingMode = mode != null && mode.getName().contains("SlidingSide");
                    if (window.isOpened() && !isInSlidingMode) {
                        window.promote();
                    } else if (!window.isOpened() || window.isOpened() && !window.isShowing() && isInSlidingMode) {
                        String title;
                        ImageIcon icon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/ui/resources/testResults.png"));
                        String projectname = ProjectUtils.getInformation((Project)session.getProject()).getDisplayName();
                        int total = displayHandler.getTotalTests();
                        String string = title = total == 0 ? Bundle.LBL_NotificationDisplayer_NoTestsExecuted_title(projectname) : Bundle.LBL_NotificationDisplayer_title(total, projectname);
                        if (Manager.this.bubbleTask.cancel()) {
                            Manager.this.bubbleTask.schedule(0);
                        }
                        Manager.this.bubbleNotification = NotificationDisplayer.getDefault().notify(title, (Icon)icon, Bundle.LBL_NotificationDisplayer_detailsText(), new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                window.promote();
                                Manager.this.bubbleTask.cancel();
                            }
                        });
                        Manager.this.bubbleTask.schedule(15000);
                    }
                }
            });
        }
    }

    private synchronized ResultDisplayHandler getDisplayHandler(TestSession session) {
        assert (session != null) : Bundle.Null_Session_Error();
        ResultDisplayHandler displayHandler = null;
        if (this.displayHandlers != null) {
            WeakReference<ResultDisplayHandler> reference = this.displayHandlers.get(session);
            if (reference != null) {
                displayHandler = (ResultDisplayHandler)reference.get();
            }
        } else {
            this.displayHandlers = new WeakHashMap<TestSession, WeakReference<ResultDisplayHandler>>(7);
        }
        if (displayHandler == null) {
            displayHandler = new ResultDisplayHandler(session);
            this.createIO(displayHandler);
            this.displayHandlers.put(session, new WeakReference<ResultDisplayHandler>(displayHandler));
            final ResultDisplayHandler dispHandler = displayHandler;
            this.lock = new Semaphore(1);
            try {
                this.lock.acquire(1);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.FINE, "Current thread was interrupted while acquiring a permit: {0}", e);
            }
            Mutex.EVENT.writeAccess(new Runnable(){

                @Override
                public void run() {
                    StatisticsPanel comp = (StatisticsPanel)dispHandler.getDisplayComponent().getLeftComponent();
                    dispHandler.setTreePanel(comp.getTreePanel());
                    Manager.this.lock.release();
                }
            });
            try {
                this.lock.acquire(1);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.FINE, "Current thread was interrupted while acquiring a permit: {0}", e);
            }
        }
        return displayHandler;
    }

    private void createIO(final ResultDisplayHandler displayHandler) {
        try {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    ResultWindow window = ResultWindow.getInstance();
                    window.setOutputComp(displayHandler.getOutputComponent());
                    InputOutput io = displayHandler.createIO(window.getIOContainer());
                    window.addDisplayComponent(displayHandler.getDisplayComponent(), io);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeAndWait(r);
            }
        }
        catch (InterruptedException r) {
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private int getDisplayIndex(TestSession session) {
        if (this.displaysMap == null) {
            return -1;
        }
        Boolean o = this.displaysMap.get(session);
        return o != null ? 0 : -1;
    }

    private void addDisplay(TestSession session) {
        if (this.displaysMap == null) {
            this.displaysMap = new WeakHashMap<TestSession, Boolean>(4);
        }
        this.displaysMap.put(session, Boolean.TRUE);
    }

    static {
        LOGGER = Logger.getLogger(Manager.class.getName());
        DEFAULT_LINE_HANDLER = new OutputLineHandler(){

            @Override
            public void handleLine(OutputWriter out, String text) {
                out.println(text);
            }
        };
    }

    private class Displayer
    implements Runnable {
        private final ResultDisplayHandler displayHandler;
        private final boolean promote;

        Displayer(ResultDisplayHandler displayHandler, boolean promote) {
            this.displayHandler = displayHandler;
            this.promote = promote;
        }

        @Override
        public void run() {
            ResultWindow window = ResultWindow.getInstance();
            if (this.promote) {
                window.promote();
            }
        }
    }
}

