/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatInternalFrameTitlePane;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class FlatInternalFrameUI
extends BasicInternalFrameUI {
    public static ComponentUI createUI(JComponent c) {
        return new FlatInternalFrameUI((JInternalFrame)c);
    }

    public FlatInternalFrameUI(JInternalFrame b) {
        super(b);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        LookAndFeel.installProperty(this.frame, "opaque", false);
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame w) {
        return new FlatInternalFrameTitlePane(w);
    }

    public static class FlatInternalFrameBorder
    extends FlatEmptyBorder {
        private final Color activeBorderColor = UIManager.getColor("InternalFrame.activeBorderColor");
        private final Color inactiveBorderColor = UIManager.getColor("InternalFrame.inactiveBorderColor");
        private final int borderLineWidth = FlatUIUtils.getUIInt("InternalFrame.borderLineWidth", 1);

        public FlatInternalFrameBorder() {
            super(UIManager.getInsets("InternalFrame.borderMargins"));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            if (c instanceof JInternalFrame && ((JInternalFrame)c).isMaximum()) {
                insets.left = UIScale.scale(Math.min(this.borderLineWidth, this.left));
                insets.top = UIScale.scale(Math.min(this.borderLineWidth, this.top));
                insets.right = UIScale.scale(Math.min(this.borderLineWidth, this.right));
                insets.bottom = UIScale.scale(Math.min(this.borderLineWidth, this.bottom));
                return insets;
            }
            return super.getBorderInsets(c, insets);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            JInternalFrame f = (JInternalFrame)c;
            Insets insets = this.getBorderInsets(c);
            float lineWidth = UIScale.scale((float)this.borderLineWidth);
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                FlatUIUtils.setRenderingHints(g2);
                g2.setColor(f.isSelected() ? this.activeBorderColor : this.inactiveBorderColor);
                g2.fill(FlatUIUtils.createRectangle((float)(x + insets.left) - lineWidth, (float)(y + insets.top) - lineWidth, (float)(width - insets.left - insets.right) + lineWidth * 2.0f, (float)(height - insets.top - insets.bottom) + lineWidth * 2.0f, lineWidth));
            }
            finally {
                g2.dispose();
            }
        }
    }
}

