/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.queries;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.JavacTask;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Pair;
import org.openide.util.Parameters;

public class DefaultSourceLevelQueryImpl
implements SourceLevelQueryImplementation,
FileChangeListener {
    private static final Logger LOG = Logger.getLogger(DefaultSourceLevelQueryImpl.class.getName());
    private static final String JAVA_EXT = "java";
    private static final String MODULE_INFO = "module-info";
    private static final SpecificationVersion JDK9 = new SpecificationVersion("9");
    private final AtomicReference<Pair<Reference<FileObject>, Reference<FileObject>>> rootCache = new AtomicReference();
    private final AtomicReference<Pair<Pair<Reference<FileObject>, File>, Boolean>> modCache = new AtomicReference();

    public String getSourceLevel(FileObject javaFile) {
        assert (javaFile != null) : "javaFile has to be non null";
        String ext = javaFile.getExt();
        if (JAVA_EXT.equalsIgnoreCase(ext)) {
            JavaPlatform jp = JavaPlatformManager.getDefault().getDefaultPlatform();
            assert (jp != null) : "JavaPlatformManager.getDefaultPlatform returned null";
            SpecificationVersion ver = jp.getSpecification().getVersion();
            if (JDK9.compareTo((Object)ver) > 0 && this.isModular(javaFile)) {
                return JDK9.toString();
            }
            return ver.toString();
        }
        return null;
    }

    public void fileFolderCreated(FileEvent fe) {
        this.resetModCache();
    }

    public void fileDataCreated(FileEvent fe) {
        this.resetModCache();
    }

    public void fileDeleted(FileEvent fe) {
        this.resetModCache();
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.resetModCache();
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    public void fileChanged(FileEvent fe) {
    }

    private void resetModCache() {
        Pair entry = this.modCache.getAndSet(null);
        if (entry != null && ((Pair)entry.first()).second() != null) {
            FileUtil.removeFileChangeListener((FileChangeListener)this, (File)((File)((Pair)entry.first()).second()));
        }
    }

    private boolean isModular(FileObject javaFile) {
        FileObject meKye;
        FileObject root;
        FileObject file;
        if (MODULE_INFO.equals(javaFile.getName())) {
            return true;
        }
        Pair<Reference<FileObject>, Reference<FileObject>> entry = this.rootCache.get();
        if (entry == null || (file = (FileObject)((Reference)entry.first()).get()) == null || !file.equals(javaFile) || (root = (FileObject)((Reference)entry.second()).get()) == null) {
            root = Optional.ofNullable(ClassPath.getClassPath((FileObject)javaFile, (String)"classpath/source")).map(scp -> scp.findOwnerRoot(javaFile)).orElseGet(() -> {
                String pkg = DefaultSourceLevelQueryImpl.parsePackage(javaFile);
                String[] pkgElements = pkg.isEmpty() ? new String[]{} : pkg.split("\\.");
                FileObject owner = javaFile.getParent();
                for (int i = 0; owner != null && i < pkgElements.length; owner = owner.getParent(), ++i) {
                }
                return owner;
            });
            this.rootCache.set((Pair<Reference<FileObject>, Reference<FileObject>>)Pair.of(new WeakReference<FileObject>(javaFile), new WeakReference<FileObject>(root)));
            LOG.log(Level.FINE, "rootCache updated: {0}", root);
        }
        if (root == null) {
            return false;
        }
        Pair<Pair<Reference<FileObject>, File>, Boolean> modEntry = this.modCache.get();
        if (modEntry == null || (meKye = (FileObject)((Reference)((Pair)modEntry.first()).first()).get()) == null || !meKye.equals(root)) {
            FileObject modInfo = root.getFileObject(MODULE_INFO, JAVA_EXT);
            boolean res = modInfo != null && modInfo.isData();
            Pair newModEntry = Pair.of((Object)Pair.of(new WeakReference<FileObject>(root), (Object)FileUtil.toFile((FileObject)root)), (Object)res);
            if (this.modCache.compareAndSet(modEntry, (Pair<Pair<Reference<FileObject>, File>, Boolean>)newModEntry)) {
                if (modEntry != null && ((Pair)modEntry.first()).second() != null) {
                    FileUtil.removeFileChangeListener((FileChangeListener)this, (File)((File)((Pair)modEntry.first()).second()));
                }
                if (newModEntry != null && ((Pair)newModEntry.first()).second() != null) {
                    FileUtil.addFileChangeListener((FileChangeListener)this, (File)((File)((Pair)newModEntry.first()).second()));
                }
                LOG.log(Level.FINE, "modCache updated: {0}", res);
            }
            return res;
        }
        return (Boolean)modEntry.second();
    }

    @NonNull
    private static String parsePackage(@NonNull FileObject javaFile) {
        String pkg = "";
        try {
            JavacTask jt = (JavacTask)ToolProvider.getSystemJavaCompiler().getTask(null, null, null, Collections.emptyList(), Collections.emptyList(), Collections.singleton(new JFO(javaFile)));
            Iterator<? extends CompilationUnitTree> cus = jt.parse().iterator();
            if (cus.hasNext()) {
                pkg = Optional.ofNullable(cus.next().getPackage()).map(pt -> pt.getPackageName()).map(xt -> xt.toString()).orElse(pkg);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pkg;
    }

    private static final class JFO
    implements JavaFileObject {
        private final FileObject delegate;

        JFO(@NonNull FileObject delegate) {
            Parameters.notNull((CharSequence)"delegate", (Object)delegate);
            this.delegate = delegate;
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return JavaFileObject.Kind.SOURCE;
        }

        @Override
        public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
            return this.delegate.getName().equals(simpleName) && this.getKind() == kind;
        }

        @Override
        public NestingKind getNestingKind() {
            return NestingKind.TOP_LEVEL;
        }

        @Override
        public Modifier getAccessLevel() {
            return null;
        }

        @Override
        public URI toUri() {
            return this.delegate.toURI();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return this.delegate.getInputStream();
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.delegate.getOutputStream();
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            return new InputStreamReader(this.openInputStream(), this.encoding());
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            StringBuilder content = new StringBuilder();
            char[] data = new char[4096];
            try (Reader in = this.openReader(ignoreEncodingErrors);){
                int len = in.read(data, 0, data.length);
                while (len > 0) {
                    content.append(data, 0, len);
                    len = in.read(data, 0, data.length);
                }
            }
            return content;
        }

        @Override
        public Writer openWriter() throws IOException {
            return new OutputStreamWriter(this.openOutputStream(), this.encoding());
        }

        @Override
        public long getLastModified() {
            return this.delegate.lastModified().getTime();
        }

        @Override
        public boolean delete() {
            try {
                this.delegate.delete();
                return true;
            }
            catch (IOException ioe) {
                return false;
            }
        }

        private Charset encoding() {
            return FileEncodingQuery.getEncoding((FileObject)this.delegate);
        }
    }
}

