/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.dtd.grammar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.netbeans.api.xml.parsers.SAXEntityParser;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.dtd.grammar.DTDGrammar;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.helpers.DefaultHandler;

public class DTDParser {
    static final String SAX_PROPERTY = "http://xml.org/sax/properties/";
    static final String DECL_HANDLER = "declaration-handler";
    private boolean dtdOnly;

    public DTDParser() {
        this(false);
    }

    public DTDParser(boolean dtdOnly) {
        this.dtdOnly = dtdOnly;
    }

    public GrammarQuery parse(InputSource in) {
        EntityResolverWrapper res;
        Handler handler;
        block10: {
            handler = new Handler();
            res = null;
            try {
                XMLReader parser = XMLUtil.createXMLReader((!this.dtdOnly ? 1 : 0) != 0);
                parser.setContentHandler(handler);
                parser.setErrorHandler(handler);
                parser.setDTDHandler(handler);
                UserCatalog catalog = UserCatalog.getDefault();
                if (catalog != null) {
                    res = new EntityResolverWrapper(catalog.getEntityResolver());
                }
                if (res != null) {
                    parser.setEntityResolver(res);
                }
                parser.setProperty("http://xml.org/sax/properties/declaration-handler", handler);
                if (this.dtdOnly) {
                    new SAXEntityParser(parser, false).parse(in);
                } else {
                    parser.parse(in);
                }
                throw new IllegalStateException("How we can get here?");
            }
            catch (Stop parser) {
            }
            catch (SAXException ex) {
                if (Boolean.getBoolean("netbeans.debug.xml") || Boolean.getBoolean("netbeans.debug.exceptions")) {
                    ex.printStackTrace();
                    if (ex.getException() instanceof RuntimeException) {
                        ex.getException().printStackTrace();
                    }
                }
            }
            catch (IOException ex) {
                if (!Boolean.getBoolean("netbeans.debug.xml")) break block10;
                ex.printStackTrace();
            }
        }
        DTDGrammar dtdGrammar = handler.getDTDGrammar();
        dtdGrammar.setResolvedEntities(res == null ? Collections.EMPTY_LIST : res.getResolvedSystemIds());
        return dtdGrammar;
    }

    private class EntityResolverWrapper
    implements EntityResolver {
        private EntityResolver resolver;
        private ArrayList resolvedSystemIds = new ArrayList(3);

        public EntityResolverWrapper(EntityResolver resolver) {
            this.resolver = resolver;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            this.resolvedSystemIds.add(systemId);
            return this.resolver.resolveEntity(publicId, systemId);
        }

        public List getResolvedSystemIds() {
            return this.resolvedSystemIds;
        }
    }

    private class Stop
    extends SAXException {
        private static final long serialVersionUID = -6466279601744402792L;

        Stop() {
            super("STOP");
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private class Handler
    extends DefaultHandler
    implements DeclHandler {
        private Map attrs = new HashMap();
        private Map elements = new HashMap();
        private Map models = new HashMap();
        private Map enums;
        private Map attrDefaults;
        private Set notations = new TreeSet();
        private Set entities = new TreeSet();
        private Set anys = new HashSet();
        private Set emptyElements;
        private DTDGrammar dtd;

        Handler() {
            this.enums = new HashMap();
            this.attrDefaults = new HashMap();
            this.emptyElements = new HashSet();
            this.dtd = new DTDGrammar(this.elements, this.models, this.attrs, this.attrDefaults, this.enums, this.entities, this.notations, this.emptyElements);
        }

        DTDGrammar getDTDGrammar() {
            for (String name : this.anys) {
                this.elements.put(name, this.elements.keySet());
            }
            return this.dtd;
        }

        @Override
        public void elementDecl(String name, String model) throws SAXException {
            if ("ANY".equals(model)) {
                this.anys.add(name);
                this.elements.put(name, Collections.EMPTY_SET);
                return;
            }
            if ("EMPTY".equals(model)) {
                this.elements.put(name, Collections.EMPTY_SET);
                this.emptyElements.add(name);
                return;
            }
            if ("(#PCDATA)".equals(model)) {
                this.elements.put(name, Collections.EMPTY_SET);
                return;
            }
            StringTokenizer tokenizer = new StringTokenizer(model, " \t\n|,()?+*");
            TreeSet<String> modelset = new TreeSet<String>();
            while (tokenizer.hasMoreTokens()) {
                String next = tokenizer.nextToken().trim();
                if ("#PCDATA".equals(next)) continue;
                modelset.add(next);
            }
            this.elements.put(name, modelset);
            this.models.put(name, model);
        }

        @Override
        public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
            if (name.startsWith("%")) {
                return;
            }
            this.entities.add(name);
        }

        @Override
        public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
            TreeSet<String> set = (TreeSet<String>)this.attrs.get(eName);
            if (set == null) {
                set = new TreeSet<String>();
                this.attrs.put(eName, set);
            }
            set.add(aName);
            if (type != null && type.startsWith("(")) {
                StringTokenizer tokenizer = new StringTokenizer(type, "()|", false);
                ArrayList<String> tokens = new ArrayList<String>(7);
                while (tokenizer.hasMoreTokens()) {
                    tokens.add(tokenizer.nextToken());
                }
                this.enums.put(eName + " " + aName, tokens);
            }
            String key = eName + " " + aName;
            this.attrDefaults.put(key, valueDefault);
        }

        @Override
        public void internalEntityDecl(String name, String value) throws SAXException {
            if (name.startsWith("%")) {
                return;
            }
            this.entities.add(name);
        }

        @Override
        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
            this.notations.add(name);
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            throw new Stop();
        }
    }
}

