/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.modules.maven.api.MavenValidators;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.embedder.exec.ProgressTransferListener;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.newproject.BasicWizardPanel;
import org.netbeans.modules.maven.newproject.Bundle;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.validation.api.AbstractValidator;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ValidatorUtils;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidators;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationItem;
import org.netbeans.validation.api.ui.ValidationListener;
import org.netbeans.validation.api.ui.ValidationUI;
import org.netbeans.validation.api.ui.swing.SwingValidationGroup;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class BasicPanelVisual
extends JPanel
implements DocumentListener,
WindowFocusListener,
Runnable {
    public static final String PROP_PROJECT_NAME = "projectName";
    private static final String ERROR_MSG = "WizardPanel_errorMessage";
    private static final ArtifactVersion BORDER_VERSION = new DefaultArtifactVersion("2.0.7");
    private boolean askedForVersion;
    private ArtifactVersion mavenVersion;
    private static final Object MAVEN_VERSION_LOCK = new Object();
    private BasicWizardPanel panel;
    private final Archetype arch;
    private final ValidationGroup vg;
    private boolean changedPackage = false;
    private AggregateProgressHandle handle;
    private final Object HANDLE_LOCK = new Object();
    private static final RequestProcessor RPgetver = new RequestProcessor("BasicPanelVisual-getCommandLineMavenVersion");
    private static final RequestProcessor RPprep = new RequestProcessor("BasicPanelVisual-prepareAdditionalProperties", 5);
    private Archetype currentArchetype;
    private JButton browseButton;
    private JButton btnSetupNewer;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JLabel lblAdditionalProps;
    private JLabel lblArtifactId;
    private JLabel lblGroupId;
    private JLabel lblPackage;
    private JLabel lblVersion;
    private JPanel pnlAdditionals;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JTable tblAdditionalProps;
    private JTextField txtArtifactId;
    private JTextField txtGroupId;
    private JTextField txtPackage;
    private JTextField txtVersion;
    private static final String SETTINGS_HAVE_READ = "BasicPanelVisual-read-properties-before";

    BasicPanelVisual(BasicWizardPanel panel, Archetype arch) {
        this.panel = panel;
        this.arch = arch;
        this.initComponents();
        SwingValidationGroup.setComponentName((JComponent)this.projectLocationTextField, (String)Bundle.VAL_projectLocationTextField());
        SwingValidationGroup.setComponentName((JComponent)this.projectNameTextField, (String)Bundle.VAL_projectNameTextField());
        SwingValidationGroup.setComponentName((JComponent)this.txtArtifactId, (String)Bundle.VAL_ArtifactId());
        SwingValidationGroup.setComponentName((JComponent)this.txtVersion, (String)Bundle.VAL_Version());
        SwingValidationGroup.setComponentName((JComponent)this.txtGroupId, (String)Bundle.VAL_GroupId());
        SwingValidationGroup.setComponentName((JComponent)this.txtPackage, (String)Bundle.VAL_Package());
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
        this.txtArtifactId.getDocument().addDocumentListener(this);
        this.txtGroupId.getDocument().addDocumentListener(this);
        this.txtVersion.getDocument().addDocumentListener(this);
        this.txtPackage.getDocument().addDocumentListener(this);
        this.tblAdditionalProps.setVisible(false);
        this.lblAdditionalProps.setVisible(false);
        this.jScrollPane1.setVisible(false);
        this.btnSetupNewer.setVisible(false);
        this.getAccessibleContext().setAccessibleDescription(Bundle.LBL_CreateProjectStep2());
        this.txtGroupId.setText(MavenSettings.getDefault().getLastArchetypeGroupId());
        this.txtVersion.setText(MavenSettings.getDefault().getLastArchetypeVersion());
        this.vg = ValidationGroup.create((ValidationUI[])new ValidationUI[0]);
        this.runInAWT(new Runnable(){

            @Override
            public void run() {
                BasicPanelVisual.this.vg.add((Object)BasicPanelVisual.this.txtGroupId, MavenValidators.createGroupIdValidators());
                BasicPanelVisual.this.vg.add((Object)BasicPanelVisual.this.txtArtifactId, MavenValidators.createArtifactIdValidators());
                BasicPanelVisual.this.vg.add((Object)BasicPanelVisual.this.txtVersion, MavenValidators.createVersionValidators());
                BasicPanelVisual.this.vg.add((Object)BasicPanelVisual.this.txtPackage, ValidatorUtils.merge((Validator)StringValidators.JAVA_PACKAGE_NAME, (Validator)new AbstractValidator<String>(String.class){

                    public void validate(Problems problems, String compName, String model) {
                        if (model != null && !model.isEmpty() && model.charAt(model.length() - 1) == '.') {
                            problems.add(Bundle.ERR_Package_ends_in_dot());
                        }
                    }
                }));
                BasicPanelVisual.this.vg.add((Object)BasicPanelVisual.this.projectNameTextField, ValidatorUtils.merge(MavenValidators.createArtifactIdValidators(), (Validator)StringValidators.REQUIRE_VALID_FILENAME));
                BasicPanelVisual.this.vg.add((Object)BasicPanelVisual.this.projectLocationTextField, (Validator)new AbstractValidator<String>(String.class){

                    public void validate(Problems problems, String compName, String model) {
                        File fil;
                        File projLoc;
                        for (projLoc = fil = FileUtil.normalizeFile((File)new File(model)); projLoc != null && !projLoc.exists(); projLoc = projLoc.getParentFile()) {
                        }
                        if (projLoc == null || !projLoc.canWrite()) {
                            problems.add(Bundle.ERR_Project_Folder_cannot_be_created());
                            return;
                        }
                        if (FileUtil.toFileObject((File)projLoc) == null) {
                            problems.add(Bundle.ERR_Project_Folder_is_not_valid_path());
                            return;
                        }
                        if (Utilities.isWindows() && fil.getAbsolutePath().startsWith("\\\\")) {
                            problems.add(Bundle.ERR_Project_Folder_is_UNC());
                        }
                    }
                });
                BasicPanelVisual.this.vg.addItem((ValidationItem)new ValidationListener<Void>(Void.class, ValidationUI.NO_OP, null){

                    protected void performValidation(Problems problems) {
                        boolean tooOld = BasicPanelVisual.this.isMavenTooOld();
                        BasicPanelVisual.this.btnSetupNewer.setVisible(tooOld);
                        if (tooOld) {
                            problems.add(Bundle.ERR_old_maven(BasicPanelVisual.this.getCommandLineMavenVersion()));
                            return;
                        }
                        File destFolder = FileUtil.normalizeFile((File)new File(new File(BasicPanelVisual.this.projectLocationTextField.getText().trim()), BasicPanelVisual.this.projectNameTextField.getText().trim()).getAbsoluteFile());
                        if (destFolder.exists() && !destFolder.isDirectory()) {
                            problems.add(Bundle.ERR_Project_Folder_not_directory());
                            return;
                        }
                        File[] kids = destFolder.listFiles();
                        if (destFolder.exists() && kids != null && kids.length > 0) {
                            problems.add(Bundle.ERR_Project_Folder_exists());
                        }
                    }
                }, true);
            }
        });
    }

    public String getProjectName() {
        return this.projectNameTextField.getText();
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.lblArtifactId = new JLabel();
        this.txtArtifactId = new JTextField();
        this.lblGroupId = new JLabel();
        this.txtGroupId = new JTextField();
        this.lblVersion = new JLabel();
        this.txtVersion = new JTextField();
        this.lblPackage = new JLabel();
        this.txtPackage = new JTextField();
        this.jLabel1 = new JLabel();
        this.pnlAdditionals = new JPanel();
        this.lblAdditionalProps = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tblAdditionalProps = new JTable();
        this.btnSetupNewer = new JButton();
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(BasicPanelVisual.class, (String)"LBL_ProjectName"));
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(BasicPanelVisual.class, (String)"LBL_ProjectLocation"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(BasicPanelVisual.class, (String)"BTN_Browse"));
        this.browseButton.setActionCommand("BROWSE");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicPanelVisual.this.browseButtonActionPerformed(evt);
            }
        });
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage(BasicPanelVisual.class, (String)"LBL_ProjectFolder"));
        this.createdFolderTextField.setEditable(false);
        this.createdFolderTextField.setEnabled(false);
        this.lblArtifactId.setLabelFor(this.txtArtifactId);
        Mnemonics.setLocalizedText((JLabel)this.lblArtifactId, (String)NbBundle.getMessage(BasicPanelVisual.class, (String)"LBL_ArtifactId"));
        this.txtArtifactId.setEditable(false);
        this.txtArtifactId.setEnabled(false);
        this.lblGroupId.setLabelFor(this.txtGroupId);
        Mnemonics.setLocalizedText((JLabel)this.lblGroupId, (String)NbBundle.getMessage(BasicPanelVisual.class, (String)"LBL_GroupId"));
        this.lblVersion.setLabelFor(this.txtVersion);
        Mnemonics.setLocalizedText((JLabel)this.lblVersion, (String)NbBundle.getMessage(BasicPanelVisual.class, (String)"LBL_Version"));
        this.txtVersion.setText("1.0-SNAPSHOT");
        this.lblPackage.setLabelFor(this.txtPackage);
        Mnemonics.setLocalizedText((JLabel)this.lblPackage, (String)NbBundle.getMessage(BasicPanelVisual.class, (String)"LBL_Package"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(BasicPanelVisual.class, (String)"LBL_Optional"));
        this.lblAdditionalProps.setLabelFor(this.tblAdditionalProps);
        Mnemonics.setLocalizedText((JLabel)this.lblAdditionalProps, (String)"<additional properties>");
        this.tblAdditionalProps.setModel(this.createPropModel());
        this.tblAdditionalProps.setColumnSelectionAllowed(true);
        this.jScrollPane1.setViewportView(this.tblAdditionalProps);
        this.tblAdditionalProps.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.tblAdditionalProps.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.tblAdditionalProps.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetupNewer, (String)NbBundle.getMessage(BasicPanelVisual.class, (String)"BTN_SetupNewer.text"));
        this.btnSetupNewer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicPanelVisual.this.btnSetupNewerActionPerformed(evt);
            }
        });
        GroupLayout pnlAdditionalsLayout = new GroupLayout(this.pnlAdditionals);
        this.pnlAdditionals.setLayout(pnlAdditionalsLayout);
        pnlAdditionalsLayout.setHorizontalGroup(pnlAdditionalsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlAdditionalsLayout.createSequentialGroup().addComponent(this.lblAdditionalProps).addContainerGap(379, Short.MAX_VALUE)).addGroup(pnlAdditionalsLayout.createSequentialGroup().addComponent(this.btnSetupNewer).addContainerGap()).addComponent(this.jScrollPane1, -1, 550, Short.MAX_VALUE));
        pnlAdditionalsLayout.setVerticalGroup(pnlAdditionalsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlAdditionalsLayout.createSequentialGroup().addComponent(this.lblAdditionalProps).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 102, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSetupNewer)));
        this.btnSetupNewer.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.btnSetupNewer.AccessibleContext.accessibleDescription"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.createdFolderLabel).addComponent(this.projectLocationLabel).addComponent(this.projectNameLabel).addComponent(this.lblPackage).addComponent(this.lblVersion).addComponent(this.lblGroupId).addComponent(this.lblArtifactId)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtArtifactId, -1, 322, Short.MAX_VALUE).addComponent(this.txtGroupId, -1, 322, Short.MAX_VALUE).addComponent(this.txtVersion, -1, 322, Short.MAX_VALUE).addComponent(this.txtPackage, -1, 322, Short.MAX_VALUE).addComponent(this.createdFolderTextField, -1, 322, Short.MAX_VALUE).addComponent(this.projectLocationTextField, -1, 322, Short.MAX_VALUE).addComponent(this.projectNameTextField, -1, 322, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.browseButton, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel1).addContainerGap()))).addGroup(layout.createSequentialGroup().addComponent(this.pnlAdditionals, -1, -1, Short.MAX_VALUE).addContainerGap(12, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectNameTextField, -2, -1, -2).addComponent(this.projectNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectLocationTextField, -2, -1, -2).addComponent(this.browseButton).addComponent(this.projectLocationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createdFolderTextField, -2, -1, -2).addComponent(this.createdFolderLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtArtifactId, -2, -1, -2).addComponent(this.lblArtifactId)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtGroupId, -2, -1, -2).addComponent(this.lblGroupId)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtVersion, -2, -1, -2).addComponent(this.lblVersion)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtPackage, -2, -1, -2).addComponent(this.lblPackage).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlAdditionals, -1, -1, Short.MAX_VALUE)));
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.projectNameTextField.AccessibleContext.accessibleDescription"));
        this.projectLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.projectLocationTextField.AccessibleContext.accessibleDescription"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.browseButton.AccessibleContext.accessibleDescription"));
        this.createdFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.createdFolderTextField.AccessibleContext.accessibleDescription"));
        this.txtArtifactId.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.txtArtifactId.AccessibleContext.accessibleDescription"));
        this.txtGroupId.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.txtGroupId.AccessibleContext.accessibleDescription"));
        this.txtVersion.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.txtVersion.AccessibleContext.accessibleDescription"));
        this.txtPackage.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.txtPackage.AccessibleContext.accessibleDescription"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.jLabel1.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicPanelVisual.class, (String)"BasicPanelVisual.AccessibleContext.accessibleDescription"));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if ("BROWSE".equals(command)) {
            File f;
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(null);
            chooser.setDialogTitle(Bundle.TIT_Select_Project_Location());
            chooser.setFileSelectionMode(1);
            String path = this.projectLocationTextField.getText();
            if (path.length() > 0 && (f = new File(path)).exists()) {
                chooser.setSelectedFile(f);
            }
            if (0 == chooser.showOpenDialog(this)) {
                File projectDir = chooser.getSelectedFile();
                this.projectLocationTextField.setText(FileUtil.normalizeFile((File)projectDir).getAbsolutePath());
            }
            this.panel.fireChangeEvent();
        }
    }

    private void btnSetupNewerActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("Java/Maven");
        this.panel.getValidationGroup().performValidation();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
        this.tblAdditionalProps.setVisible(false);
        this.lblAdditionalProps.setVisible(false);
        this.jScrollPane1.setVisible(false);
        SwingUtilities.getWindowAncestor(this).addWindowFocusListener(this);
    }

    static boolean containsMultiByte(String text, WizardDescriptor wd) {
        char[] textChars = text.toCharArray();
        for (int i = 0; i < textChars.length; ++i) {
            if (textChars[i] <= '\u00ff') continue;
            wd.putProperty(ERROR_MSG, (Object)Bundle.ERR_multibyte());
            return true;
        }
        return false;
    }

    private boolean isMavenTooOld() {
        ArtifactVersion version = this.getCommandLineMavenVersion();
        return version != null ? BORDER_VERSION.compareTo((Object)version) > 0 : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArtifactVersion getCommandLineMavenVersion() {
        Object object = MAVEN_VERSION_LOCK;
        synchronized (object) {
            if (!this.askedForVersion) {
                this.askedForVersion = true;
                RPgetver.post((Runnable)this);
            }
            return this.mavenVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store(WizardDescriptor d) {
        Object object = this.HANDLE_LOCK;
        synchronized (object) {
            if (this.handle != null) {
                this.handle.finish();
                this.handle = null;
            }
        }
        String name = this.projectNameTextField.getText().trim();
        String folder = this.createdFolderTextField.getText().trim();
        File projectFolder = new File(folder);
        d.putProperty("projdir", (Object)projectFolder);
        if (d instanceof TemplateWizard) {
            ((TemplateWizard)d).setTargetFolderLazy(() -> {
                projectFolder.mkdirs();
                return DataFolder.findFolder((FileObject)FileUtil.toFileObject((File)projectFolder));
            });
        }
        d.putProperty("name", (Object)name);
        if (d instanceof TemplateWizard) {
            ((TemplateWizard)d).setTargetName(name);
        }
        d.putProperty("artifactId", (Object)this.txtArtifactId.getText().trim());
        d.putProperty("groupId", (Object)this.txtGroupId.getText().trim());
        MavenSettings.getDefault().setLastArchetypeGroupId(this.txtGroupId.getText().trim());
        d.putProperty("version", (Object)this.txtVersion.getText().trim());
        MavenSettings.getDefault().setLastArchetypeVersion(this.txtVersion.getText().trim());
        d.putProperty("package", (Object)this.txtPackage.getText().trim());
        if (this.tblAdditionalProps.isVisible()) {
            TableCellEditor edito;
            if (this.tblAdditionalProps.isEditing() && (edito = this.tblAdditionalProps.getCellEditor()) != null) {
                edito.stopCellEditing();
            }
            TableModel mdl = this.tblAdditionalProps.getModel();
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < mdl.getRowCount(); ++i) {
                map.put((String)mdl.getValueAt(i, 0), (String)mdl.getValueAt(i, 1));
            }
            d.putProperty("additionalProps", map);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BasicPanelVisual.this.panel.getValidationGroup().remove((ValidationItem)BasicPanelVisual.this.vg);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read(WizardDescriptor settings, final Map<String, String> defaultProps) {
        String ver;
        String gr;
        Object object = this.HANDLE_LOCK;
        synchronized (object) {
            if (this.handle != null) {
                this.handle.finish();
                this.handle = null;
            }
        }
        boolean haveRead = Boolean.parseBoolean((String)settings.getProperty(SETTINGS_HAVE_READ));
        File projectFolder = (File)settings.getProperty("projdir");
        File projectLocation = !haveRead && projectFolder != null ? projectFolder : (projectFolder == null || projectFolder.getParentFile() == null || !projectFolder.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : projectFolder.getParentFile());
        if (!haveRead) {
            settings.putProperty(SETTINGS_HAVE_READ, (Object)"true");
        }
        this.projectLocationTextField.setText(projectLocation.getAbsolutePath());
        String projectName = (String)settings.getProperty("name");
        if (projectName == null) {
            int baseCount = 1;
            while ((projectName = this.validFreeProjectName(projectLocation, Bundle.TXT_MavenProjectName(baseCount))) == null) {
                ++baseCount;
            }
        }
        if ((gr = (String)settings.getProperty("groupId")) != null) {
            this.txtGroupId.setText(gr);
        }
        if ((ver = (String)settings.getProperty("version")) != null) {
            this.txtVersion.setText(ver);
        }
        this.projectNameTextField.setText(projectName);
        this.projectNameTextField.selectAll();
        if (this.panel.areAdditional()) {
            Archetype archet;
            this.currentArchetype = archet = this.getArchetype(settings);
            this.lblAdditionalProps.setText(Bundle.TXT_Checking1());
            this.lblAdditionalProps.setVisible(true);
            this.tblAdditionalProps.setVisible(false);
            this.jScrollPane1.setVisible(false);
            RPprep.post(new Runnable(){

                @Override
                public void run() {
                    BasicPanelVisual.this.prepareAdditionalProperties(archet, defaultProps);
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BasicPanelVisual.this.panel.getValidationGroup().addItem((ValidationItem)BasicPanelVisual.this.vg, true);
            }
        });
    }

    private void prepareAdditionalProperties(Archetype arch, Map<String, String> defaultProps) {
        final DefaultTableModel dtm = new DefaultTableModel();
        dtm.addColumn(Bundle.COL_Key());
        dtm.addColumn(Bundle.COL_Value());
        try {
            Artifact art = this.downloadArchetype(arch);
            File fil = art.getFile();
            if (fil.exists()) {
                Map<String, String> props = arch.loadRequiredProperties();
                for (String key : props.keySet()) {
                    String defVal = props.get(key);
                    if ("groupId".equals(key) || "artifactId".equals(key) || "version".equals(key)) continue;
                    if (defaultProps != null && defaultProps.containsKey(key)) {
                        defVal = defaultProps.get(key);
                    }
                    if (defVal == null) {
                        defVal = "";
                    }
                    dtm.addRow(new Object[]{key, defVal});
                }
            }
        }
        catch (ArtifactResolutionException ex) {
            Logger.getLogger(BasicPanelVisual.class.getName()).log(Level.FINE, "Cannot download archetype", ex);
        }
        catch (ArtifactNotFoundException ex) {
            Logger.getLogger(BasicPanelVisual.class.getName()).log(Level.FINE, "Cannot download archetype", ex);
        }
        if (arch != this.currentArchetype || !this.isVisible()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (dtm.getRowCount() > 0) {
                    Mnemonics.setLocalizedText((JLabel)BasicPanelVisual.this.lblAdditionalProps, (String)Bundle.TXT_Checking2());
                    BasicPanelVisual.this.lblAdditionalProps.setVisible(true);
                    BasicPanelVisual.this.jScrollPane1.setVisible(true);
                    BasicPanelVisual.this.tblAdditionalProps.setModel(dtm);
                    BasicPanelVisual.this.tblAdditionalProps.setVisible(true);
                } else {
                    BasicPanelVisual.this.tblAdditionalProps.setVisible(false);
                    BasicPanelVisual.this.lblAdditionalProps.setVisible(false);
                    BasicPanelVisual.this.jScrollPane1.setVisible(false);
                }
            }
        });
    }

    private Archetype getArchetype(WizardDescriptor settings) {
        if (this.arch != null) {
            return this.arch;
        }
        return (Archetype)settings.getProperty("archetype");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Artifact downloadArchetype(Archetype arch) throws ArtifactResolutionException, ArtifactNotFoundException {
        AggregateProgressHandle hndl = AggregateProgressFactory.createHandle((String)Bundle.Handle_Download(), (ProgressContributor[])new ProgressContributor[]{AggregateProgressFactory.createProgressContributor((String)"zaloha")}, (Cancellable)ProgressTransferListener.cancellable(), null);
        Object object = this.HANDLE_LOCK;
        synchronized (object) {
            this.handle = hndl;
        }
        try {
            arch.resolveArtifacts(hndl);
        }
        finally {
            object = this.HANDLE_LOCK;
            synchronized (object) {
                if (hndl == this.handle) {
                    this.handle = null;
                }
            }
        }
        RepositoryIndexer.updateIndexWithArtifacts((RepositoryInfo)RepositoryPreferences.getInstance().getLocalRepository(), Collections.singletonList(arch.getArtifact()));
        return arch.getArtifact();
    }

    private TableModel createPropModel() {
        return new DefaultTableModel();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    private void updateTexts(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.projectNameTextField.getDocument() || doc == this.projectLocationTextField.getDocument()) {
            String projectName = this.projectNameTextField.getText();
            String projectFolder = this.projectLocationTextField.getText();
            this.createdFolderTextField.setText(projectFolder + File.separatorChar + projectName);
        }
        if (this.projectNameTextField.getDocument() == doc) {
            String projName = this.projectNameTextField.getText().trim();
            this.txtArtifactId.setText(projName.replaceAll(" ", ""));
        }
        if (!(this.changedPackage || this.projectNameTextField.getDocument() != doc && this.txtGroupId.getDocument() != doc)) {
            this.txtPackage.getDocument().removeDocumentListener(this);
            this.txtPackage.setText(BasicPanelVisual.getPackageName(this.txtGroupId.getText() + "." + this.txtArtifactId.getText().replace("-", ".")));
            this.txtPackage.getDocument().addDocumentListener(this);
        }
        if (this.txtPackage.getDocument() == doc) {
            boolean bl = this.changedPackage = this.txtPackage.getText().trim().length() != 0;
        }
        if (this.vg != null) {
            this.vg.performValidation();
        }
    }

    private String validFreeProjectName(File parentFolder, String name) {
        File file = new File(parentFolder, name);
        return file.exists() ? null : name;
    }

    static String getPackageName(String displayName) {
        StringBuilder builder = new StringBuilder();
        boolean firstLetter = true;
        for (int i = 0; i < displayName.length(); ++i) {
            char c = displayName.charAt(i);
            if (!firstLetter && Character.isJavaIdentifierPart(c) || firstLetter && Character.isJavaIdentifierStart(c)) {
                firstLetter = false;
                if (Character.isUpperCase(c)) {
                    c = Character.toLowerCase(c);
                }
                builder.append(c);
                continue;
            }
            if (firstLetter || c != '.') continue;
            firstLetter = true;
            builder.append(c);
        }
        String toRet = builder.length() == 0 ? "pkg" : builder.toString();
        return toRet;
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.askedForVersion = false;
        this.getCommandLineMavenVersion();
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    @Override
    public void run() {
        if (!EventQueue.isDispatchThread()) {
            String version = MavenSettings.getCommandLineMavenVersion();
            this.mavenVersion = version != null ? new DefaultArtifactVersion(version.trim()) : null;
            SwingUtilities.invokeLater(this);
        } else {
            this.vg.performValidation();
        }
    }

    private void runInAWT(Runnable runnable) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }
}

