/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.registration;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.payara.spi.PayaraModule;
import org.netbeans.modules.payara.tooling.data.PayaraVersion;
import org.netbeans.modules.payara.tooling.utils.ServerUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class AutomaticRegistration {
    private static final Logger LOGGER = Logger.getLogger(AutomaticRegistration.class.getName());

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Parameters: <ide clusterDir> <PayaraHome> <Java 7 or later home>");
            System.exit(-1);
        }
        String javaExe = args.length == 3 ? args[2] : "";
        int status = AutomaticRegistration.autoregisterPayaraInstance(args[0], args[1], javaExe);
        System.exit(status);
    }

    private static int autoregisterPayaraInstance(String clusterDirValue, String payaraRoot, String jdk7orLaterPath) throws IOException {
        String displayName;
        boolean ok;
        System.setProperty("netbeans.user", clusterDirValue);
        File payaraHome = new File(payaraRoot);
        if (!payaraHome.exists()) {
            LOGGER.log(Level.INFO, "Cannot register the default Payara server. The Payara Root directory {0} does not exist.", payaraRoot);
            return 3;
        }
        String config = "PayaraEE6/Instances";
        String deployer = "deployer:pfv3ee6";
        String defaultDisplayNamePrefix = "Payara Server ";
        PayaraVersion version = ServerUtils.getServerVersion((String)payaraRoot);
        if (PayaraVersion.ge((Enum)version, (Enum)PayaraVersion.PF_4_1_144)) {
            deployer = "deployer:pfv4ee7";
        }
        if (PayaraVersion.ge((Enum)version, (Enum)PayaraVersion.PF_5_181)) {
            deployer = "deployer:pfv5ee8";
        }
        StringBuilder sb = new StringBuilder(defaultDisplayNamePrefix.length() + 12);
        if (version == null) {
            LOGGER.log(Level.INFO, "Cannot register the default Payara server. The Payara Root directory {0} is of unknown version.", payaraRoot);
            return 4;
        }
        sb.append(defaultDisplayNamePrefix);
        sb.append(version.toString());
        String defaultDisplayName = sb.toString();
        FileObject serverInstanceDir = FileUtil.getConfigFile((String)config);
        if (serverInstanceDir == null && (serverInstanceDir = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)config)) == null) {
            LOGGER.log(Level.INFO, "Cannot register the default Payara server. The config/{0} folder cannot be created.", config);
            return 2;
        }
        payaraRoot = new File(payaraRoot).getAbsolutePath();
        String url = "[" + payaraRoot + File.pathSeparator + payaraRoot + File.separator + "domains" + File.separator + "domain1]" + deployer + ":localhost:4848";
        for (FileObject fo : serverInstanceDir.getChildren()) {
            if (!url.equals(fo.getAttribute("url"))) continue;
            return 0;
        }
        File jdk7orLaterExecutable = new File(jdk7orLaterPath);
        if (!jdk7orLaterExecutable.exists()) {
            jdk7orLaterExecutable = null;
        }
        if (ok = AutomaticRegistration.registerServerInstanceFO(serverInstanceDir, url, displayName = AutomaticRegistration.generateUniqueDisplayName(serverInstanceDir, defaultDisplayName), payaraHome, jdk7orLaterExecutable)) {
            return 0;
        }
        return 6;
    }

    private static String generateUniqueDisplayName(FileObject serverInstanceDir, String defaultDisplayName) {
        String displayName = defaultDisplayName;
        boolean unique = true;
        int i = 1;
        while (true) {
            for (FileObject fo : serverInstanceDir.getChildren()) {
                if (!displayName.equals(fo.getAttribute("displayName"))) continue;
                unique = false;
                break;
            }
            if (unique) break;
            displayName = defaultDisplayName + " " + i++;
            unique = true;
        }
        return displayName;
    }

    private static boolean registerServerInstanceFO(FileObject serverInstanceDir, String url, String displayName, File payaraRoot, File java7orLaterExecutable) {
        String name = FileUtil.findFreeFileName((FileObject)serverInstanceDir, (String)"payara_autoregistered_instance", null);
        try {
            FileObject instanceFO = serverInstanceDir.createData(name);
            instanceFO.setAttribute("url", (Object)url);
            instanceFO.setAttribute("username", (Object)"admin");
            instanceFO.setAttribute("password", (Object)"");
            instanceFO.setAttribute("displayName", (Object)displayName);
            instanceFO.setAttribute("adminPort", (Object)"4848");
            instanceFO.setAttribute("installfolder", (Object)payaraRoot.getParent());
            instanceFO.setAttribute("debugPort", (Object)"");
            instanceFO.setAttribute("domainname", (Object)"domain1");
            instanceFO.setAttribute("domainsfolder", (Object)new File(payaraRoot, "domains").getAbsolutePath());
            instanceFO.setAttribute("driverDeployOn", (Object)"true");
            instanceFO.setAttribute("installfolder", (Object)payaraRoot.getParent());
            instanceFO.setAttribute("host", (Object)"localhost");
            instanceFO.setAttribute("homefolder", (Object)payaraRoot.getAbsolutePath());
            instanceFO.setAttribute("java.platform", (Object)(java7orLaterExecutable == null ? "" : java7orLaterExecutable.getAbsolutePath()));
            instanceFO.setAttribute("httpportnumber", (Object)"8080");
            instanceFO.setAttribute("httphostname", (Object)"localhost");
            instanceFO.setAttribute("jvmMode", (Object)PayaraModule.NORMAL_MODE);
            instanceFO.setAttribute("hotDeploy", (Object)false);
            instanceFO.setAttribute("preserveSessionsOn", (Object)true);
            instanceFO.setAttribute("useIDEProxyOn", (Object)true);
            instanceFO.setAttribute("use.shared.mem", (Object)false);
            return true;
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Cannot register the default Payara server.");
            LOGGER.log(Level.INFO, null, e);
            return false;
        }
    }
}

