/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContextCache {
    private final Map<MergedContextConfiguration, ApplicationContext> contextMap = new ConcurrentHashMap<MergedContextConfiguration, ApplicationContext>(64);
    private final Map<MergedContextConfiguration, Set<MergedContextConfiguration>> hierarchyMap = new ConcurrentHashMap<MergedContextConfiguration, Set<MergedContextConfiguration>>(64);
    private final AtomicInteger hitCount = new AtomicInteger();
    private final AtomicInteger missCount = new AtomicInteger();

    ContextCache() {
    }

    public void clear() {
        this.contextMap.clear();
        this.hierarchyMap.clear();
    }

    public void clearStatistics() {
        this.hitCount.set(0);
        this.missCount.set(0);
    }

    public boolean contains(MergedContextConfiguration key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.contextMap.containsKey(key);
    }

    public ApplicationContext get(MergedContextConfiguration key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        ApplicationContext context = this.contextMap.get(key);
        if (context == null) {
            this.missCount.incrementAndGet();
        } else {
            this.hitCount.incrementAndGet();
        }
        return context;
    }

    public int getHitCount() {
        return this.hitCount.get();
    }

    public int getMissCount() {
        return this.missCount.get();
    }

    public void put(MergedContextConfiguration key, ApplicationContext context) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)context, (String)"ApplicationContext must not be null");
        this.contextMap.put(key, context);
        MergedContextConfiguration child = key;
        MergedContextConfiguration parent = child.getParent();
        while (parent != null) {
            Set<MergedContextConfiguration> list = this.hierarchyMap.get(parent);
            if (list == null) {
                list = new HashSet<MergedContextConfiguration>();
                this.hierarchyMap.put(parent, list);
            }
            list.add(child);
            child = parent;
            parent = child.getParent();
        }
    }

    public void remove(MergedContextConfiguration key, DirtiesContext.HierarchyMode hierarchyMode) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        MergedContextConfiguration startKey = key;
        if (hierarchyMode == DirtiesContext.HierarchyMode.EXHAUSTIVE) {
            while (startKey.getParent() != null) {
                startKey = startKey.getParent();
            }
        }
        ArrayList<MergedContextConfiguration> removedContexts = new ArrayList<MergedContextConfiguration>();
        this.remove(removedContexts, startKey);
        for (MergedContextConfiguration currentKey : removedContexts) {
            for (Set<MergedContextConfiguration> children : this.hierarchyMap.values()) {
                children.remove(currentKey);
            }
        }
        for (MergedContextConfiguration currentKey : this.hierarchyMap.keySet()) {
            if (!this.hierarchyMap.get(currentKey).isEmpty()) continue;
            this.hierarchyMap.remove(currentKey);
        }
    }

    private void remove(List<MergedContextConfiguration> removedContexts, MergedContextConfiguration key) {
        ApplicationContext context;
        Assert.notNull((Object)key, (String)"Key must not be null");
        Set<MergedContextConfiguration> children = this.hierarchyMap.get(key);
        if (children != null) {
            for (MergedContextConfiguration child : children) {
                this.remove(removedContexts, child);
            }
            this.hierarchyMap.remove(key);
        }
        if ((context = this.contextMap.remove(key)) instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)context).close();
        }
        removedContexts.add(key);
    }

    public int size() {
        return this.contextMap.size();
    }

    public int getParentContextCount() {
        return this.hierarchyMap.size();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("size", this.size()).append("hitCount", this.getHitCount()).append("missCount", this.getMissCount()).append("parentContextCount", this.getParentContextCount()).toString();
    }
}

