/*
 * Decompiled with CFR 0.152.
 */
package javax.faces;

import com.sun.faces.config.ConfigManager;
import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.ServletContextFacesContextFactory;
import javax.faces.TypedCollections;
import javax.faces.application.ApplicationFactory;
import javax.faces.component.search.SearchExpressionContextFactory;
import javax.faces.component.visit.VisitContextFactory;
import javax.faces.context.ExceptionHandlerFactory;
import javax.faces.context.ExternalContextFactory;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.FlashFactory;
import javax.faces.context.PartialViewContextFactory;
import javax.faces.flow.FlowHandlerFactory;
import javax.faces.lifecycle.ClientWindowFactory;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKitFactory;
import javax.faces.view.ViewDeclarationLanguageFactory;
import javax.faces.view.facelets.FaceletCacheFactory;
import javax.faces.view.facelets.TagHandlerDelegateFactory;

final class FactoryFinderInstance {
    private static final Logger LOGGER = Logger.getLogger("javax.faces", "javax.faces.LogStrings");
    private static final String INJECTION_PROVIDER_KEY = FactoryFinder.class.getPackage().getName() + "INJECTION_PROVIDER_KEY";
    private final Map<String, Object> factories = new ConcurrentHashMap<String, Object>();
    private final Map<String, List<String>> savedFactoryNames = new ConcurrentHashMap<String, List<String>>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final String createdBy;
    private ServletContextFacesContextFactory servletContextFinder = new ServletContextFacesContextFactory();
    private final List<String> factoryNames = this.asSortedList("javax.faces.application.ApplicationFactory", "javax.faces.component.visit.VisitContextFactory", "javax.faces.context.ExceptionHandlerFactory", "javax.faces.context.ExternalContextFactory", "javax.faces.context.FacesContextFactory", "javax.faces.context.FlashFactory", "javax.faces.flow.FlowHandlerFactory", "javax.faces.context.PartialViewContextFactory", "javax.faces.lifecycle.ClientWindowFactory", "javax.faces.lifecycle.LifecycleFactory", "javax.faces.render.RenderKitFactory", "javax.faces.view.ViewDeclarationLanguageFactory", "javax.faces.view.facelets.FaceletCacheFactory", "javax.faces.view.facelets.TagHandlerDelegateFactory", "javax.faces.component.search.SearchExpressionContextFactory");
    private final Map<String, Class<?>> factoryClasses = this.buildFactoryClassesMap();

    FactoryFinderInstance(FacesContext facesContext) {
        for (String name : this.factoryNames) {
            this.factories.put(name, new ArrayList(4));
        }
        this.copyInjectionProviderFromFacesContext(facesContext);
        this.createdBy = Util.generateCreatedBy((FacesContext)facesContext);
    }

    FactoryFinderInstance(FacesContext facesContext, FactoryFinderInstance toCopy) {
        this.factories.putAll(toCopy.savedFactoryNames);
        this.copyInjectionProviderFromFacesContext(facesContext);
        this.createdBy = Util.generateCreatedBy((FacesContext)facesContext);
    }

    public String toString() {
        return super.toString() + " created by" + this.createdBy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFactory(String factoryName, String implementationClassName) {
        this.validateFactoryName(factoryName);
        Object result = this.factories.get(factoryName);
        this.lock.writeLock().lock();
        try {
            if (result instanceof List) {
                TypedCollections.dynamicallyCastList((List)result, String.class).add(0, implementationClassName);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getFactory(String factoryName) {
        Object factoryOrList;
        this.validateFactoryName(factoryName);
        if (factoryName.equals("com.sun.faces.ServletContextFacesContextFactory")) {
            return this.servletContextFinder;
        }
        if (factoryName.equals("com.sun.faces.ServletContextFacesContextFactory_Removal")) {
            try {
                this.lock.writeLock().lock();
                this.servletContextFinder = null;
                Object var2_2 = null;
                return var2_2;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.lock.readLock().lock();
        try {
            factoryOrList = this.factories.get(factoryName);
            if (!(factoryOrList instanceof List)) {
                Object object = factoryOrList;
                return object;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            factoryOrList = this.factories.get(factoryName);
            if (!(factoryOrList instanceof List)) {
                Object object = factoryOrList;
                return object;
            }
            this.savedFactoryNames.put(factoryName, new ArrayList((List)factoryOrList));
            Object factory = this.getImplementationInstance(Util.getContextClassLoader2(), factoryName, (List)factoryOrList);
            if (factory == null) {
                this.logNoFactory(factoryName);
                factory = FactoryFinder.FACTORIES_CACHE.getFallbackFactory(this, factoryName);
                this.notNullFactory(factoryName, factory);
            }
            this.factories.put(factoryName, factory);
            Object object = factory;
            return object;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    InjectionProvider getInjectionProvider() {
        return (InjectionProvider)this.factories.get(INJECTION_PROVIDER_KEY);
    }

    void clearInjectionProvider() {
        this.factories.remove(INJECTION_PROVIDER_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseFactories() {
        InjectionProvider provider = this.getInjectionProvider();
        if (provider != null) {
            this.lock.writeLock().lock();
            try {
                for (Map.Entry<String, Object> entry : this.factories.entrySet()) {
                    Object curFactory = entry.getValue();
                    if (INJECTION_PROVIDER_KEY.equals(entry.getKey()) || curFactory == null || curFactory instanceof String) continue;
                    try {
                        provider.invokePreDestroy(curFactory);
                    }
                    catch (Exception ex) {
                        this.logPreDestroyFail(entry.getValue(), ex);
                    }
                }
            }
            finally {
                this.factories.clear();
                this.lock.writeLock().unlock();
            }
        } else {
            LOGGER.log(Level.SEVERE, "Unable to call @PreDestroy annotated methods because no InjectionProvider can be found. Does this container implement the Mojarra Injection SPI?");
        }
    }

    Collection<Object> getFactories() {
        return this.factories.values();
    }

    private void copyInjectionProviderFromFacesContext(FacesContext facesContext) {
        InjectionProvider injectionProvider = null;
        if (facesContext != null) {
            injectionProvider = (InjectionProvider)facesContext.getAttributes().get(ConfigManager.INJECTION_PROVIDER_KEY);
        }
        if (injectionProvider != null) {
            this.factories.put(INJECTION_PROVIDER_KEY, injectionProvider);
        } else {
            LOGGER.log(Level.SEVERE, "Unable to obtain InjectionProvider from init time FacesContext. Does this container implement the Mojarra Injection SPI?");
        }
    }

    private Object getImplementationInstance(ClassLoader classLoader, String factoryName, List<String> implementations) throws FacesException {
        List<String> fromServices;
        String curImplClass;
        int len;
        Object implementation = null;
        if (implementations != null && (1 < (len = implementations.size()) || 1 == len)) {
            curImplClass = implementations.remove(len - 1);
            implementation = this.getImplGivenPreviousImpl(classLoader, factoryName, curImplClass, null);
        }
        if ((fromServices = this.getImplNameFromServices(classLoader, factoryName)) != null) {
            for (String name : fromServices) {
                implementation = this.getImplGivenPreviousImpl(classLoader, factoryName, name, implementation);
            }
        }
        if (implementations != null) {
            for (len = implementations.size() - 1; 0 <= len; --len) {
                curImplClass = implementations.remove(len);
                implementation = this.getImplGivenPreviousImpl(classLoader, factoryName, curImplClass, implementation);
            }
        }
        return implementation;
    }

    private List<String> getImplNameFromServices(ClassLoader classLoader, String factoryName) {
        ArrayList<String> implementationNames;
        block13: {
            implementationNames = new ArrayList<String>();
            String resourceName = "META-INF/services/" + factoryName;
            try {
                Enumeration<URL> resources = classLoader.getResources(resourceName);
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    URLConnection connection = url.openConnection();
                    connection.setUseCaches(false);
                    InputStream stream = connection.getInputStream();
                    Throwable throwable = null;
                    try {
                        if (stream == null) continue;
                        implementationNames.add(this.readLineFromStream(stream));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
            }
            catch (IOException | SecurityException e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block13;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
        return implementationNames;
    }

    private Object getImplGivenPreviousImpl(ClassLoader classLoader, String factoryName, String factoryImplClassName, Object previousFactoryImplementation) {
        Object factoryImplementation = null;
        Class<?> factoryClass = this.getFactoryClass(factoryName);
        if (!Util.isAnyNull((Object[])new Object[]{previousFactoryImplementation, factoryClass})) {
            try {
                factoryImplementation = Class.forName(factoryImplClassName, false, classLoader).getConstructor(factoryClass).newInstance(previousFactoryImplementation);
            }
            catch (NoSuchMethodException nsme) {
                factoryClass = null;
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
                throw new FacesException(factoryImplClassName, e);
            }
        }
        if (Util.isAnyNull((Object[])new Object[]{previousFactoryImplementation, factoryClass})) {
            try {
                factoryImplementation = Class.forName(factoryImplClassName, false, classLoader).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new FacesException(factoryImplClassName, e);
            }
        }
        this.injectImplementation(factoryImplClassName, factoryImplementation);
        return factoryImplementation;
    }

    private Class<?> getFactoryClass(String factoryClassName) {
        return this.factoryClasses.get(factoryClassName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readLineFromStream(InputStream stream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));){
            String throwable3 = reader.readLine();
            return throwable3;
        }
        catch (UnsupportedEncodingException uee) {
            try (BufferedReader reader2 = new BufferedReader(new InputStreamReader(stream));){
                String string = reader2.readLine();
                return string;
            }
        }
    }

    private void injectImplementation(String implementationName, Object implementation) {
        if (implementation != null) {
            InjectionProvider provider = this.getInjectionProvider();
            if (provider != null) {
                try {
                    provider.inject(implementation);
                    provider.invokePostConstruct(implementation);
                }
                catch (Exception e) {
                    throw new FacesException(implementationName, e);
                }
            } else {
                LOGGER.log(Level.SEVERE, "Unable to inject {0} because no InjectionProvider can be found. Does this container implement the Mojarra Injection SPI?", implementation);
            }
        }
    }

    private void logNoFactory(String factoryName) {
        if (LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.log(Level.SEVERE, MessageFormat.format(LOGGER.getResourceBundle().getString("severe.no_factory"), factoryName));
        }
    }

    private void logPreDestroyFail(Object factory, Exception ex) {
        if (LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.log(Level.SEVERE, MessageFormat.format("Unable to invoke @PreDestroy annotated methods on {0}.", factory), ex);
        }
    }

    private void notNullFactory(String factoryName, Object factory) {
        if (factory == null) {
            throw new IllegalStateException(MessageFormat.format(LOGGER.getResourceBundle().getString("severe.no_factory_backup_failed"), factoryName));
        }
    }

    private void validateFactoryName(String factoryName) {
        if (factoryName == null) {
            throw new NullPointerException();
        }
        if (Util.isOneOf((Object)factoryName, (Object[])new String[]{"com.sun.faces.ServletContextFacesContextFactory", "com.sun.faces.ServletContextFacesContextFactory_Removal"})) {
            return;
        }
        if (Collections.binarySearch(this.factoryNames, factoryName) < 0) {
            throw new IllegalArgumentException(factoryName);
        }
    }

    private Map<String, Class<?>> buildFactoryClassesMap() {
        HashMap<String, Class<SearchExpressionContextFactory>> buildUpFactoryClasses = new HashMap<String, Class<SearchExpressionContextFactory>>();
        buildUpFactoryClasses.put("javax.faces.application.ApplicationFactory", ApplicationFactory.class);
        buildUpFactoryClasses.put("javax.faces.component.visit.VisitContextFactory", VisitContextFactory.class);
        buildUpFactoryClasses.put("javax.faces.context.ExceptionHandlerFactory", ExceptionHandlerFactory.class);
        buildUpFactoryClasses.put("javax.faces.context.ExternalContextFactory", ExternalContextFactory.class);
        buildUpFactoryClasses.put("javax.faces.context.FacesContextFactory", FacesContextFactory.class);
        buildUpFactoryClasses.put("javax.faces.context.FlashFactory", FlashFactory.class);
        buildUpFactoryClasses.put("javax.faces.context.PartialViewContextFactory", PartialViewContextFactory.class);
        buildUpFactoryClasses.put("javax.faces.lifecycle.LifecycleFactory", LifecycleFactory.class);
        buildUpFactoryClasses.put("javax.faces.lifecycle.ClientWindowFactory", ClientWindowFactory.class);
        buildUpFactoryClasses.put("javax.faces.render.RenderKitFactory", RenderKitFactory.class);
        buildUpFactoryClasses.put("javax.faces.view.ViewDeclarationLanguageFactory", ViewDeclarationLanguageFactory.class);
        buildUpFactoryClasses.put("javax.faces.view.facelets.FaceletCacheFactory", FaceletCacheFactory.class);
        buildUpFactoryClasses.put("javax.faces.view.facelets.TagHandlerDelegateFactory", TagHandlerDelegateFactory.class);
        buildUpFactoryClasses.put("javax.faces.flow.FlowHandlerFactory", FlowHandlerFactory.class);
        buildUpFactoryClasses.put("javax.faces.component.search.SearchExpressionContextFactory", SearchExpressionContextFactory.class);
        return Collections.unmodifiableMap(buildUpFactoryClasses);
    }

    private List<String> asSortedList(String ... names) {
        List<String> list = Arrays.asList(names);
        Collections.sort(list);
        return list;
    }
}

