/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.helper;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.helper.IsPristineObjectNode;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=IsPristineObjectNode.class)
public final class IsPristineObjectNodeGen
extends IsPristineObjectNode {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private CachedData cached_cache;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private Assumption[] dynamic_assumption0_;

    private IsPristineObjectNodeGen(JSClass jsClass, Shape initialPrototypeShape, Object ... propertyKeys) {
        super(jsClass, initialPrototypeShape, propertyKeys);
    }

    @Override
    @ExplodeLoop
    public boolean execute(DynamicObject arg0Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0) {
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    if (!Assumption.isValidAssumption((Assumption[])s1_.assumption0_)) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.removeCached_(s1_);
                        return this.executeAndSpecialize(arg0Value);
                    }
                    if (s1_.cachedShape_.check(arg0Value)) {
                        return this.doCached(arg0Value, s1_.cachedShape_, s1_.isInstanceAndDoesNotOverwriteProps_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                if (!Assumption.isValidAssumption((Assumption[])this.dynamic_assumption0_)) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.removeDynamic_();
                    return this.executeAndSpecialize(arg0Value);
                }
                return this.doDynamic(arg0Value);
            }
            if ((state & 4) != 0) {
                return this.doAssumptionsInvalid(arg0Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAndSpecialize(DynamicObject arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            Assumption[] dynamic_assumption0;
            if (exclude == 0) {
                Assumption[] assumption0;
                Shape cachedShape__;
                int count1_ = 0;
                CachedData s1_ = this.cached_cache;
                if ((state & 1) != 0) {
                    while (s1_ != null && (!s1_.cachedShape_.check(arg0Value) || s1_.assumption0_ != null && !Assumption.isValidAssumption((Assumption[])s1_.assumption0_))) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && (cachedShape__ = arg0Value.getShape()).check(arg0Value) && Assumption.isValidAssumption((Assumption[])(assumption0 = this.getPropertyFinalAssumptions())) && count1_ < 3) {
                    s1_ = new CachedData(this.cached_cache);
                    s1_.cachedShape_ = cachedShape__;
                    s1_.isInstanceAndDoesNotOverwriteProps_ = this.isInstanceAndDoesNotOverwriteProps(cachedShape__);
                    s1_.assumption0_ = assumption0;
                    this.cached_cache = s1_;
                    this.state_ = state |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doCached(arg0Value, s1_.cachedShape_, s1_.isInstanceAndDoesNotOverwriteProps_);
                    return bl;
                }
            }
            if (Assumption.isValidAssumption((Assumption[])(dynamic_assumption0 = this.getPropertyFinalAssumptions()))) {
                this.dynamic_assumption0_ = dynamic_assumption0;
                this.exclude_ = exclude |= 1;
                this.cached_cache = null;
                state &= 0xFFFFFFFE;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doDynamic(arg0Value);
                return bl;
            }
            this.state_ = state |= 4;
            lock.unlock();
            hasLock = false;
            boolean bl = this.doAssumptionsInvalid(arg0Value);
            return bl;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        CachedData s1_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCached_(Object s1_) {
        Lock lock = this.getLock();
        lock.lock();
        try {
            CachedData prev = null;
            CachedData cur = this.cached_cache;
            while (cur != null) {
                if (cur == s1_) {
                    if (prev == null) {
                        this.cached_cache = cur.next_;
                        break;
                    }
                    prev.next_ = cur.next_;
                    break;
                }
                prev = cur;
                cur = cur.next_;
            }
            if (this.cached_cache == null) {
                this.state_ &= 0xFFFFFFFE;
            }
        }
        finally {
            lock.unlock();
        }
    }

    void removeDynamic_() {
        Lock lock = this.getLock();
        lock.lock();
        try {
            this.state_ &= 0xFFFFFFFD;
        }
        finally {
            lock.unlock();
        }
    }

    public static IsPristineObjectNode create(JSClass jsClass, Shape initialPrototypeShape, Object ... propertyKeys) {
        return new IsPristineObjectNodeGen(jsClass, initialPrototypeShape, propertyKeys);
    }

    @GeneratedBy(value=IsPristineObjectNode.class)
    private static final class CachedData {
        @CompilerDirectives.CompilationFinal
        CachedData next_;
        @CompilerDirectives.CompilationFinal
        Shape cachedShape_;
        @CompilerDirectives.CompilationFinal
        boolean isInstanceAndDoesNotOverwriteProps_;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        Assumption[] assumption0_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }
    }
}

