/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.TokenType;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class RuntimeNode
extends Expression {
    private final Request request;
    private final List<Expression> args;

    public RuntimeNode(long token, int finish, Request request, List<Expression> args) {
        super(token, finish);
        this.request = request;
        this.args = args;
    }

    private RuntimeNode(RuntimeNode runtimeNode, Request request, List<Expression> args) {
        super(runtimeNode);
        this.request = request;
        this.args = args;
    }

    public RuntimeNode(long token, int finish, Request request, Expression ... args) {
        this(token, finish, request, Arrays.asList(args));
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterRuntimeNode(this)) {
            return visitor.leaveRuntimeNode(this.setArgs(Node.accept(visitor, this.args)));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> visitor) {
        return visitor.enterRuntimeNode(this);
    }

    @Override
    public void toString(StringBuilder sb, boolean printType) {
        sb.append("Runtime.");
        sb.append((Object)this.request);
        sb.append('(');
        boolean first = true;
        for (Node node : this.args) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            node.toString(sb, printType);
        }
        sb.append(')');
    }

    public List<Expression> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    public RuntimeNode setArgs(List<Expression> args) {
        if (this.args == args) {
            return this;
        }
        return new RuntimeNode(this, this.request, args);
    }

    public Request getRequest() {
        return this.request;
    }

    public static enum Request {
        REFERENCE_ERROR,
        TO_STRING(TokenType.VOID, Object.class, 1),
        GET_TEMPLATE_OBJECT(TokenType.TEMPLATE, Object.class, 2);

        private final TokenType tokenType;
        private final Class<?> returnType;
        private final int arity;

        private Request() {
            this(TokenType.VOID, Object.class, 0);
        }

        private Request(TokenType tokenType, Class<?> returnType, int arity) {
            this.tokenType = tokenType;
            this.returnType = returnType;
            this.arity = arity;
        }

        public int getArity() {
            return this.arity;
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }

        public TokenType getTokenType() {
            return this.tokenType;
        }
    }
}

