/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugScope;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.debug.SuspendedContext;
import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Iterator;
import java.util.Objects;

public final class DebugStackFrame {
    final SuspendedEvent event;
    private final FrameInstance currentFrame;
    private final int depth;

    DebugStackFrame(SuspendedEvent session, FrameInstance instance, int depth) {
        this.event = session;
        this.currentFrame = instance;
        this.depth = depth;
    }

    public boolean isInternal() {
        this.verifyValidState(true);
        RootNode root = this.findCurrentRoot();
        if (root == null) {
            return true;
        }
        return root.isInternal();
    }

    public String getName() throws DebugException {
        this.verifyValidState(true);
        RootNode root = this.findCurrentRoot();
        if (root == null) {
            return null;
        }
        try {
            return root.getName();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            throw new DebugException(this.event.getSession(), ex, root.getLanguageInfo(), null, true, null);
        }
    }

    public SourceSection getSourceSection() {
        this.verifyValidState(true);
        if (this.currentFrame == null) {
            SuspendedContext context = this.getContext();
            return this.event.getSession().resolveSection(context.getInstrumentedSourceSection());
        }
        Node callNode = this.currentFrame.getCallNode();
        if (callNode != null) {
            return this.event.getSession().resolveSection(callNode);
        }
        return null;
    }

    public LanguageInfo getLanguage() {
        this.verifyValidState(true);
        RootNode root = this.findCurrentRoot();
        if (root == null) {
            return null;
        }
        return root.getLanguageInfo();
    }

    public DebugScope getScope() throws DebugException {
        this.verifyValidState(false);
        SuspendedContext context = this.getContext();
        RootNode root = this.findCurrentRoot();
        if (root == null) {
            return null;
        }
        Node node = this.currentFrame == null ? context.getInstrumentedNode() : this.currentFrame.getCallNode();
        LanguageInfo languageInfo = node.getRootNode().getLanguageInfo();
        if (languageInfo == null) {
            return null;
        }
        DebuggerSession session = this.event.getSession();
        Frame frame = this.findTruffleFrame(FrameInstance.FrameAccess.READ_WRITE);
        try {
            Iterable<Scope> scopes = session.getDebugger().getEnv().findLocalScopes(node, frame);
            Iterator<Scope> it = scopes.iterator();
            if (!it.hasNext()) {
                return null;
            }
            return new DebugScope(it.next(), it, session, this.event, frame, root);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            throw new DebugException(session, ex, languageInfo, null, true, null);
        }
    }

    public Node getRawNode(Class<? extends TruffleLanguage<?>> languageClass) {
        Objects.requireNonNull(languageClass);
        RootNode rootNode = this.findCurrentRoot();
        if (rootNode == null) {
            return null;
        }
        TruffleLanguage<?> language = Debugger.ACCESSOR.nodeSupport().getLanguage(rootNode);
        return language != null && language.getClass() == languageClass ? this.getCurrentNode() : null;
    }

    public Frame getRawFrame(Class<? extends TruffleLanguage<?>> languageClass, FrameInstance.FrameAccess access) {
        Objects.requireNonNull(languageClass);
        RootNode rootNode = this.findCurrentRoot();
        if (rootNode == null) {
            return null;
        }
        TruffleLanguage<?> language = Debugger.ACCESSOR.nodeSupport().getLanguage(rootNode);
        return language != null && language.getClass() == languageClass ? this.findTruffleFrame(access) : null;
    }

    DebugValue wrapHeapValue(Object result) {
        RootNode root = this.findCurrentRoot();
        LanguageInfo language = root != null ? root.getLanguageInfo() : null;
        return new DebugValue.HeapValue(this.event.getSession(), language, null, result);
    }

    public DebugValue eval(String code) throws DebugException {
        this.verifyValidState(false);
        Object result = DebuggerSession.evalInContext(this.event, code, this.currentFrame);
        return this.wrapHeapValue(result);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DebugStackFrame) {
            DebugStackFrame other = (DebugStackFrame)obj;
            return this.event == other.event && (this.currentFrame == other.currentFrame || this.currentFrame != null && other.currentFrame != null && this.currentFrame.getFrame(FrameInstance.FrameAccess.READ_ONLY) == other.currentFrame.getFrame(FrameInstance.FrameAccess.READ_ONLY));
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.event, this.currentFrame);
    }

    Frame findTruffleFrame(FrameInstance.FrameAccess access) {
        if (this.currentFrame == null) {
            return this.event.getMaterializedFrame();
        }
        return this.currentFrame.getFrame(access);
    }

    int getDepth() {
        return this.depth;
    }

    private SuspendedContext getContext() {
        SuspendedContext context = this.event.getContext();
        if (context == null) {
            this.verifyValidState(true);
            assert (false) : "should not be reachable";
        }
        return context;
    }

    RootNode findCurrentRoot() {
        SuspendedContext context = this.getContext();
        if (this.currentFrame == null) {
            return context.getInstrumentedNode().getRootNode();
        }
        return ((RootCallTarget)this.currentFrame.getCallTarget()).getRootNode();
    }

    RootCallTarget getCallTarget() {
        SuspendedContext context = this.getContext();
        if (this.currentFrame == null) {
            return context.getInstrumentedNode().getRootNode().getCallTarget();
        }
        return (RootCallTarget)this.currentFrame.getCallTarget();
    }

    Node getCurrentNode() {
        if (this.currentFrame == null) {
            return this.getContext().getInstrumentedNode();
        }
        Node callNode = this.currentFrame.getCallNode();
        if (callNode != null) {
            return callNode;
        }
        CallTarget target = this.currentFrame.getCallTarget();
        if (target instanceof RootCallTarget) {
            return ((RootCallTarget)target).getRootNode();
        }
        return null;
    }

    void verifyValidState(boolean allowDifferentThread) {
        this.event.verifyValidState(allowDifferentThread);
    }
}

