/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.vars.impl;

import java.io.InvalidObjectException;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.truffle.LanguageName;
import org.netbeans.modules.debugger.jpda.truffle.access.CurrentPCInfo;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.modules.debugger.jpda.truffle.source.SourcePosition;
import org.netbeans.modules.debugger.jpda.truffle.vars.TruffleVariable;
import org.openide.util.Exceptions;

public class TruffleVariableImpl
implements TruffleVariable {
    private static final String GUEST_OBJECT_TYPE = "org.netbeans.modules.debugger.jpda.backend.truffle.GuestObject";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_LANGUAGE = "language";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_READABLE = "readable";
    private static final String FIELD_WRITABLE = "writable";
    private static final String FIELD_INTERNAL = "internal";
    private static final String FIELD_LEAF = "leaf";
    private static final String FIELD_DISPLAY_VALUE = "displayValue";
    private static final String METHOD_GET_CHILDREN = "getProperties";
    private static final String METHOD_GET_CHILDREN_SIG = "()[Lorg/netbeans/modules/debugger/jpda/backend/truffle/GuestObject;";
    private static final String METHOD_SET_VALUE = "setValue";
    private static final String METHOD_SET_VALUE_SIG = "(Lcom/oracle/truffle/api/debug/DebugStackFrame;Ljava/lang/String;)Lorg/netbeans/modules/debugger/jpda/backend/truffle/GuestObject;";
    private static final String FIELD_VALUE_SOURCE = "valueSourcePosition";
    private static final String FIELD_TYPE_SOURCE = "typeSourcePosition";
    private final ObjectVariable guestObject;
    private final String name;
    private final LanguageName language;
    private final String type;
    private final String displayValue;
    private final boolean readable;
    private final boolean writable;
    private final boolean internal;
    private final boolean leaf;
    private final boolean hasValueSource;
    private final boolean hasTypeSource;
    private SourcePosition valueSource;
    private SourcePosition typeSource;

    private TruffleVariableImpl(ObjectVariable guestObject, String name, LanguageName language, String type, String displayValue, boolean readable, boolean writable, boolean internal, boolean hasValueSource, boolean hasTypeSource, boolean leaf) {
        this.guestObject = guestObject;
        this.name = name;
        this.language = language;
        this.type = type;
        this.displayValue = displayValue;
        this.readable = readable;
        this.writable = writable;
        this.internal = internal;
        this.hasValueSource = hasValueSource;
        this.hasTypeSource = hasTypeSource;
        this.leaf = leaf;
    }

    public static TruffleVariableImpl get(Variable var) {
        if (GUEST_OBJECT_TYPE.equals(var.getType())) {
            ObjectVariable truffleObj = (ObjectVariable)var;
            Field f = truffleObj.getField(FIELD_NAME);
            if (f == null) {
                return null;
            }
            String name = (String)f.createMirrorObject();
            f = truffleObj.getField(FIELD_LANGUAGE);
            if (f == null) {
                return null;
            }
            LanguageName language = LanguageName.parse((String)f.createMirrorObject());
            f = truffleObj.getField(FIELD_TYPE);
            if (f == null) {
                return null;
            }
            String type = (String)f.createMirrorObject();
            f = truffleObj.getField(FIELD_DISPLAY_VALUE);
            if (f == null) {
                return null;
            }
            String dispVal = (String)f.createMirrorObject();
            f = truffleObj.getField(FIELD_READABLE);
            boolean readable = f == null ? true : (Boolean)f.createMirrorObject();
            f = truffleObj.getField(FIELD_WRITABLE);
            boolean writable = f == null ? true : (Boolean)f.createMirrorObject();
            f = truffleObj.getField(FIELD_INTERNAL);
            boolean internal = f == null ? true : (Boolean)f.createMirrorObject();
            f = truffleObj.getField(FIELD_VALUE_SOURCE);
            boolean hasValueSource = ((ObjectVariable)f).getUniqueID() != 0L;
            f = truffleObj.getField(FIELD_TYPE_SOURCE);
            boolean hasTypeSource = ((ObjectVariable)f).getUniqueID() != 0L;
            boolean leaf = TruffleVariableImpl.isLeaf(truffleObj);
            return new TruffleVariableImpl(truffleObj, name, language, type, dispVal, readable, writable, internal, hasValueSource, hasTypeSource, leaf);
        }
        return null;
    }

    static boolean isLeaf(ObjectVariable truffleObj) {
        Field f = TruffleVariableImpl.getFieldChecked(FIELD_LEAF, truffleObj);
        Boolean mirrorLeaf = (Boolean)f.createMirrorObject();
        boolean leaf = mirrorLeaf == null ? false : mirrorLeaf;
        return leaf;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LanguageName getLanguage() {
        return this.language;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isReadable() {
        return this.readable;
    }

    @Override
    public boolean isWritable() {
        return this.writable;
    }

    @Override
    public boolean isInternal() {
        return this.internal;
    }

    @Override
    public String getDisplayValue() {
        return this.displayValue;
    }

    @Override
    public Object getValue() {
        return this.displayValue;
    }

    @Override
    public ObjectVariable setValue(JPDADebugger debugger, String newExpression) {
        if (this.displayValue.equals(newExpression)) {
            return null;
        }
        return TruffleVariableImpl.setValue(debugger, this.guestObject, newExpression);
    }

    static ObjectVariable setValue(JPDADebugger debugger, ObjectVariable guestObject, String newExpression) {
        CurrentPCInfo currentPCInfo = TruffleAccess.getCurrentPCInfo(debugger.getCurrentThread());
        if (currentPCInfo != null) {
            ObjectVariable selectedFrame = currentPCInfo.getSelectedStackFrame().getStackFrameInstance();
            try {
                Variable retVar = guestObject.invokeMethod(METHOD_SET_VALUE, METHOD_SET_VALUE_SIG, new Variable[]{selectedFrame, debugger.createMirrorVar((Object)newExpression)});
                if (retVar instanceof ObjectVariable) {
                    return (ObjectVariable)retVar;
                }
            }
            catch (InvalidObjectException | NoSuchMethodException | InvalidExpressionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public boolean hasValueSource() {
        return this.hasValueSource;
    }

    @Override
    public synchronized SourcePosition getValueSource() {
        if (this.valueSource == null) {
            Field f = TruffleVariableImpl.getFieldChecked(FIELD_VALUE_SOURCE, this.guestObject);
            this.valueSource = TruffleAccess.getSourcePosition((JPDADebugger)((AbstractVariable)f).getDebugger(), (ObjectVariable)f);
        }
        return this.valueSource;
    }

    @Override
    public boolean hasTypeSource() {
        return this.hasTypeSource;
    }

    @Override
    public synchronized SourcePosition getTypeSource() {
        if (this.typeSource == null) {
            Field f = TruffleVariableImpl.getFieldChecked(FIELD_TYPE_SOURCE, this.guestObject);
            this.typeSource = TruffleAccess.getSourcePosition((JPDADebugger)((AbstractVariable)f).getDebugger(), (ObjectVariable)f);
        }
        return this.typeSource;
    }

    @Override
    public boolean isLeaf() {
        return this.leaf;
    }

    @Override
    public Object[] getChildren() {
        return TruffleVariableImpl.getChildren(this.guestObject);
    }

    static Object[] getChildren(ObjectVariable guestObject) {
        try {
            Variable children = guestObject.invokeMethod(METHOD_GET_CHILDREN, METHOD_GET_CHILDREN_SIG, new Variable[0]);
            if (children instanceof ObjectVariable) {
                Field[] fields = ((ObjectVariable)children).getFields(0, Integer.MAX_VALUE);
                int n = fields.length;
                Object[] ch = new Object[n];
                for (int i = 0; i < n; ++i) {
                    TruffleVariableImpl tv = TruffleVariableImpl.get((Variable)fields[i]);
                    ch[i] = tv != null ? tv : fields[i].createMirrorObject();
                }
                return ch;
            }
        }
        catch (NoSuchMethodException | InvalidExpressionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return new Object[0];
    }

    private static Field getFieldChecked(String fieldName, ObjectVariable guestObject) {
        Field f = guestObject.getField(fieldName);
        if (f == null) {
            try {
                throw new IllegalStateException("No " + fieldName + " field in " + guestObject.getToStringValue());
            }
            catch (InvalidExpressionException iex) {
                throw new IllegalStateException("No " + fieldName + " field in " + guestObject);
            }
        }
        return f;
    }
}

