/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.java.adapter;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public final class JavaAdapterServices {
    private static final MethodHandle VALUE_EXECUTE_METHOD_HANDLE;
    private static final MethodHandle VALUE_EXECUTE_VOID_METHOD_HANDLE;
    private static final MethodHandle VALUE_AS_METHOD_HANDLE;
    private static final Source HAS_OWN_PROPERTY_SOURCE;
    private static final ThreadLocal<Value> classOverrides;

    private JavaAdapterServices() {
        assert (!JSTruffleOptions.SubstrateVM);
    }

    public static Value getClassOverrides() {
        Value overrides = classOverrides.get();
        assert (overrides != null);
        return overrides;
    }

    static void setClassOverrides(Value overrides) {
        classOverrides.set(overrides);
    }

    @CompilerDirectives.TruffleBoundary
    public static Value getFunction(Value obj, String name) {
        if ("toString".equals(name) && !JavaAdapterServices.hasOwnProperty(obj, "toString")) {
            return null;
        }
        Value fnObj = obj.getMember(name);
        if (fnObj == null) {
            return null;
        }
        if (fnObj.canExecute()) {
            return fnObj;
        }
        if (fnObj.isNull()) {
            return null;
        }
        throw Errors.createTypeErrorNotAFunction(fnObj);
    }

    private static boolean hasOwnProperty(Value obj, String name) {
        Value hasOwnProperty = Context.getCurrent().eval(HAS_OWN_PROPERTY_SOURCE);
        try {
            return hasOwnProperty.execute(new Object[]{obj, name}).asBoolean();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFunction(Object obj) {
        return obj instanceof Value && ((Value)obj).canExecute();
    }

    @CompilerDirectives.TruffleBoundary
    public static MethodHandle getHandle(MethodType type) {
        MethodHandle call = type.returnType() == Void.TYPE ? VALUE_EXECUTE_VOID_METHOD_HANDLE : VALUE_EXECUTE_METHOD_HANDLE;
        call = call.asCollector(Object[].class, type.parameterCount());
        if (type.returnType() != Void.TYPE) {
            call = MethodHandles.filterReturnValue(call, JavaAdapterServices.createReturnValueConverter(type.returnType()));
        }
        call = call.asType(type.insertParameterTypes(0, Value.class));
        return call;
    }

    public static UnsupportedOperationException unsupported(String methodName) {
        return new UnsupportedOperationException(methodName);
    }

    public static RuntimeException wrapThrowable(Throwable t) {
        return new RuntimeException(t);
    }

    private static MethodHandle createReturnValueConverter(Class<?> returnType) {
        return MethodHandles.insertArguments(VALUE_AS_METHOD_HANDLE, 1, returnType);
    }

    static {
        HAS_OWN_PROPERTY_SOURCE = Source.newBuilder((String)"js", (CharSequence)"(function(obj, name){return Object.prototype.hasOwnProperty.call(obj, name);})", (String)"hasOwnProperty").buildLiteral();
        classOverrides = new ThreadLocal();
        try {
            VALUE_EXECUTE_METHOD_HANDLE = MethodHandles.publicLookup().findVirtual(Value.class, "execute", MethodType.methodType(Value.class, Object[].class));
            VALUE_EXECUTE_VOID_METHOD_HANDLE = MethodHandles.publicLookup().findVirtual(Value.class, "executeVoid", MethodType.methodType(Void.TYPE, Object[].class));
            VALUE_AS_METHOD_HANDLE = MethodHandles.publicLookup().findVirtual(Value.class, "as", MethodType.methodType(Object.class, Class.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

