/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSFunctionFactory;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.util.CompilableBiFunction;
import com.oracle.truffle.js.runtime.util.CompilableFunction;
import java.util.Objects;

public abstract class JSObjectFactory {
    protected final JSContext context;
    private final boolean inObjectProto;

    public static UnboundProto createUnbound(JSContext context, DynamicObjectFactory factory) {
        return new UnboundProto(context, factory);
    }

    public static BoundProto createBound(JSContext context, DynamicObject prototype, DynamicObjectFactory factory) {
        return new BoundProto(context, prototype, factory);
    }

    public static JSObjectFactory createDefault(JSContext context, PrototypeSupplier prototypeSupplier, DynamicObjectFactory factory) {
        return new Eager(context, prototypeSupplier, factory);
    }

    static JSObjectFactory createIntrinsic(JSContext context, PrototypeSupplier prototypeSupplier, CompilableBiFunction<JSContext, DynamicObject, Shape> shapeSupplier, int slot) {
        return new LazySupplier(context, prototypeSupplier, shapeSupplier, slot);
    }

    static <T extends JSClass> JSObjectFactory createIntrinsic(JSContext context, T jsclass, int slot) {
        return new LazyJSClass<T>(context, jsclass, slot);
    }

    protected JSObjectFactory(JSContext context, boolean inObjectProto) {
        this.context = context;
        this.inObjectProto = inObjectProto;
    }

    public final DynamicObject createWithPrototype(JSRealm realm, DynamicObject prototype, Object ... values) {
        assert (prototype != null);
        DynamicObjectFactory factory = this.getFactory(realm, prototype);
        if (this.isInObjectProto()) {
            Object[] protoAndValues = new Object[values.length + 1];
            protoAndValues[0] = prototype;
            System.arraycopy(values, 0, protoAndValues, 1, values.length);
            return JSObjectFactory.newInstance(factory, protoAndValues);
        }
        assert (JSObjectFactory.verifyPrototype(factory, prototype));
        return JSObjectFactory.newInstance(factory, values);
    }

    public final DynamicObject createWithPrototype(JSRealm realm, DynamicObject prototype, Object value) {
        assert (prototype != null);
        DynamicObjectFactory factory = this.getFactory(realm, prototype);
        if (this.isInObjectProto()) {
            return JSObjectFactory.newInstance(factory, prototype, value);
        }
        assert (JSObjectFactory.verifyPrototype(factory, prototype));
        return JSObjectFactory.newInstance(factory, value);
    }

    static DynamicObject newInstance(DynamicObjectFactory factory, Object ... initialValues) {
        if (CompilerDirectives.isPartialEvaluationConstant((Object)factory)) {
            return factory.newInstance(initialValues);
        }
        return JSObjectFactory.newInstanceBoundary(factory, initialValues);
    }

    @CompilerDirectives.TruffleBoundary
    private static DynamicObject newInstanceBoundary(DynamicObjectFactory factory, Object[] initialValues) {
        return factory.newInstance(initialValues);
    }

    static boolean verifyPrototype(DynamicObjectFactory factory, DynamicObject prototype) {
        return JSShape.getPrototypeProperty(factory.getShape()).getLocation().isConstant() && JSShape.getPrototypeProperty(factory.getShape()).getLocation().get(null) == prototype;
    }

    public final DynamicObject createWithRealm(JSRealm realm, Object ... values) {
        return this.createWithPrototype(realm, this.getPrototype(realm), values);
    }

    public final DynamicObject createWithRealm(JSRealm realm, Object value) {
        return this.createWithPrototype(realm, this.getPrototype(realm), value);
    }

    protected abstract DynamicObject getPrototype(JSRealm var1);

    static boolean hasInObjectProto(DynamicObjectFactory factory) {
        return !JSShape.getPrototypeProperty(factory.getShape()).getLocation().isConstant();
    }

    protected abstract DynamicObjectFactory getFactory(JSRealm var1, DynamicObject var2);

    protected final boolean isInObjectProto() {
        return this.inObjectProto && this.context.isMultiContext();
    }

    private static final class LazyJSClass<T extends JSClass>
    extends Lazy {
        protected final T jsclass;

        protected LazyJSClass(JSContext context, T jsclass, int slot) {
            super(context, slot);
            this.jsclass = jsclass;
        }

        @Override
        protected DynamicObject getPrototype(JSRealm realm) {
            return ((PrototypeSupplier)this.jsclass).getIntrinsicDefaultProto(realm);
        }

        @Override
        protected Shape makeInitialShape(DynamicObject prototype) {
            return ((JSClass)((Object)this.jsclass)).makeInitialShape(this.context, prototype);
        }
    }

    private static final class LazySupplier
    extends Lazy {
        protected final PrototypeSupplier prototypeSupplier;
        protected final CompilableBiFunction<JSContext, DynamicObject, Shape> shapeSupplier;

        protected LazySupplier(JSContext context, PrototypeSupplier prototypeSupplier, CompilableBiFunction<JSContext, DynamicObject, Shape> shapeSupplier, int slot) {
            super(context, slot);
            this.prototypeSupplier = prototypeSupplier;
            this.shapeSupplier = shapeSupplier;
        }

        @Override
        protected DynamicObject getPrototype(JSRealm realm) {
            return this.prototypeSupplier.getIntrinsicDefaultProto(realm);
        }

        @Override
        protected Shape makeInitialShape(DynamicObject prototype) {
            return (Shape)this.shapeSupplier.apply(this.context, prototype);
        }
    }

    private static abstract class Lazy
    extends JSObjectFactory {
        @CompilerDirectives.CompilationFinal
        private DynamicObjectFactory factory;
        private final int slot;

        protected Lazy(JSContext context, int slot) {
            super(context, context.isMultiContext());
            this.slot = slot;
        }

        @Override
        protected final DynamicObjectFactory getFactory(JSRealm realm, DynamicObject prototype) {
            if (this.context.isMultiContext()) {
                if (this.factory == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.factory = this.makeInitialShape(this.isInObjectProto() ? null : prototype).createFactory();
                    assert (this.isInObjectProto() == Lazy.hasInObjectProto(this.factory));
                }
                return this.factory;
            }
            DynamicObjectFactory realmFactory = realm.getObjectFactories().factories[this.slot];
            if (realmFactory == null) {
                DynamicObjectFactory newFactory;
                CompilerDirectives.transferToInterpreterAndInvalidate();
                realmFactory = realm.getObjectFactories().factories[this.slot] = (newFactory = this.makeInitialShape(prototype).createFactory());
                assert (this.isInObjectProto() == Lazy.hasInObjectProto(realmFactory));
            }
            return realmFactory;
        }

        protected abstract Shape makeInitialShape(DynamicObject var1);
    }

    private static final class Eager
    extends JSObjectFactory {
        protected final PrototypeSupplier prototypeSupplier;
        protected final DynamicObjectFactory factory;

        protected Eager(JSContext context, PrototypeSupplier prototypeSupplier, DynamicObjectFactory factory) {
            super(context, Eager.hasInObjectProto(factory));
            this.prototypeSupplier = prototypeSupplier;
            this.factory = factory;
        }

        @Override
        protected DynamicObject getPrototype(JSRealm realm) {
            return this.prototypeSupplier.getIntrinsicDefaultProto(realm);
        }

        @Override
        protected DynamicObjectFactory getFactory(JSRealm realm, DynamicObject prototype) {
            return this.factory;
        }
    }

    public static final class BoundProto
    extends JSObjectFactory {
        private final DynamicObject prototype;
        private final DynamicObjectFactory factory;

        protected BoundProto(JSContext context, DynamicObject prototype, DynamicObjectFactory factory) {
            super(context, BoundProto.hasInObjectProto(factory));
            this.prototype = Objects.requireNonNull(prototype);
            this.factory = factory;
        }

        @Override
        protected DynamicObject getPrototype(JSRealm realm) {
            return this.prototype;
        }

        @Override
        protected DynamicObjectFactory getFactory(JSRealm realm, DynamicObject proto) {
            assert (proto == this.prototype);
            return this.factory;
        }

        public DynamicObject createBound(Object ... values) {
            return this.createWithPrototype((JSRealm)null, this.prototype, values);
        }

        public DynamicObject createBound(Object value) {
            return this.createWithPrototype((JSRealm)null, this.prototype, value);
        }
    }

    public static final class UnboundProto
    extends JSObjectFactory {
        private final DynamicObjectFactory factory;

        protected UnboundProto(JSContext context, DynamicObjectFactory factory) {
            super(context, UnboundProto.hasInObjectProto(factory));
            this.factory = factory;
        }

        @Override
        protected DynamicObjectFactory getFactory(JSRealm realm, DynamicObject proto) {
            return this.factory;
        }

        @Override
        protected DynamicObject getPrototype(JSRealm realm) {
            throw Errors.shouldNotReachHere();
        }
    }

    public static final class RealmData {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final DynamicObjectFactory[] factories;

        public RealmData(int count) {
            this.factories = new DynamicObjectFactory[count];
        }
    }

    public static final class IntrinsicBuilder {
        private final JSContext context;
        private int count;
        private boolean closed;

        public IntrinsicBuilder(JSContext context) {
            this.context = context;
        }

        public JSObjectFactory create(PrototypeSupplier prototypeSupplier, CompilableBiFunction<JSContext, DynamicObject, Shape> shapeSupplier) {
            assert (!this.closed);
            int index = this.count++;
            return JSObjectFactory.createIntrinsic(this.context, prototypeSupplier, shapeSupplier, index);
        }

        public <T extends JSClass> JSObjectFactory create(T jsclass) {
            assert (!this.closed);
            int index = this.count++;
            return JSObjectFactory.createIntrinsic(this.context, jsclass, index);
        }

        public JSFunctionFactory function(CompilableFunction<JSRealm, DynamicObject> intrinsicDefaultProto, boolean isStrict, boolean isAnonymous, boolean isConstructor, boolean isGenerator, boolean isBound, boolean isAsync) {
            assert (!this.closed);
            int index = this.count++;
            return JSFunctionFactory.createIntrinsic(this.context, intrinsicDefaultProto, isStrict, isAnonymous, isConstructor, isGenerator, isBound, isAsync, index);
        }

        public int finish() {
            assert (!this.closed);
            this.closed = true;
            return this.count;
        }
    }
}

