/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser;

import com.oracle.js.parser.Namespace;
import com.oracle.js.parser.Parser;
import com.oracle.js.parser.ParserContextBaseNode;
import com.oracle.js.parser.ParserContextBlockNode;
import com.oracle.js.parser.Token;
import com.oracle.js.parser.TokenType;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.ExpressionStatement;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.Module;
import com.oracle.js.parser.ir.ParameterNode;
import com.oracle.js.parser.ir.Scope;
import com.oracle.js.parser.ir.Symbol;
import com.oracle.js.parser.ir.VarNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

class ParserContextFunctionNode
extends ParserContextBaseNode {
    private final String name;
    private final IdentNode ident;
    private final Namespace namespace;
    private final int line;
    private final Scope parentScope;
    private List<IdentNode> parameters;
    private ParserContextBlockNode parameterBlock;
    private ParserContextBlockNode bodyBlock;
    private final long token;
    private long lastToken;
    private Object endParserState;
    private int length;
    private int parameterCount;
    private HashSet<String> parameterBoundNames;
    private IdentNode duplicateParameterBinding;
    private boolean simpleParameterList = true;
    private boolean containsDefaultParameter;
    private Module module;

    ParserContextFunctionNode(long token, IdentNode ident, String name, Namespace namespace, int line, int flags, List<IdentNode> parameters, int length, Scope parentScope) {
        super(flags);
        this.ident = ident;
        this.namespace = namespace;
        this.line = line;
        this.name = name;
        this.parameters = parameters;
        this.token = token;
        this.length = length;
        this.parentScope = parentScope;
        int n = this.parameterCount = parameters == null ? 0 : parameters.size();
        assert (ParserContextFunctionNode.calculateLength(parameters) == length);
    }

    public String getName() {
        return this.name;
    }

    public IdentNode getIdent() {
        return this.ident;
    }

    public boolean isProgram() {
        return this.getFlag(8192) != 0;
    }

    public boolean isStrict() {
        return this.getFlag(4) != 0;
    }

    public boolean hasNestedEval() {
        return this.getFlag(64) != 0;
    }

    public boolean hasScopeBlock() {
        return this.getFlag(128) != 0;
    }

    public String uniqueName(String base) {
        return this.namespace.uniqueName(base);
    }

    public int getLineNumber() {
        return this.line;
    }

    public List<IdentNode> getParameters() {
        if (this.parameters == null) {
            return Collections.emptyList();
        }
        return this.parameters;
    }

    void setParameters(List<IdentNode> parameters) {
        this.parameters = parameters;
    }

    public void setLastToken(long token) {
        this.lastToken = token;
    }

    public long getLastToken() {
        return this.lastToken;
    }

    public Object getEndParserState() {
        return this.endParserState;
    }

    public void setEndParserState(Object endParserState) {
        this.endParserState = endParserState;
    }

    public int getId() {
        return this.isProgram() ? -1 : Token.descPosition(this.token);
    }

    public boolean isMethod() {
        return this.getFlag(0x100000) != 0;
    }

    public boolean isClassConstructor() {
        return this.getFlag(0x200000) != 0;
    }

    public boolean isSubclassConstructor() {
        return this.getFlag(0x400000) != 0;
    }

    public int getLength() {
        return this.length;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public void addParameter(IdentNode param) {
        this.addParameterBinding(param);
        if (this.parameterBlock != null) {
            this.addParameterInit(param, this.getParameterCount());
        } else {
            if (this.parameters == null) {
                this.parameters = new ArrayList<IdentNode>();
            }
            this.parameters.add(param);
        }
        this.recordParameter(false, param.isRestParameter(), false);
    }

    private void recordParameter(boolean isDefault, boolean isRest, boolean isPattern) {
        if (!isDefault && !isRest) {
            if (!this.containsDefaultParameter) {
                ++this.length;
            }
        } else {
            this.containsDefaultParameter = true;
        }
        if ((isDefault || isRest || isPattern) && this.simpleParameterList) {
            this.recordNonSimpleParameterList();
        }
        ++this.parameterCount;
    }

    private void recordNonSimpleParameterList() {
        this.simpleParameterList = false;
        this.setFlag(0x4000000);
    }

    private boolean addParameterBinding(IdentNode bindingIdentifier) {
        if (Parser.isArguments(bindingIdentifier)) {
            this.setFlag(256);
        }
        if (this.parameterBoundNames == null) {
            this.parameterBoundNames = new HashSet();
        }
        if (this.parameterBoundNames.add(bindingIdentifier.getName())) {
            this.declareParameter(bindingIdentifier.getName());
            return true;
        }
        this.duplicateParameterBinding = bindingIdentifier;
        return false;
    }

    public IdentNode getDuplicateParameterBinding() {
        return this.duplicateParameterBinding;
    }

    public boolean isSimpleParameterList() {
        return this.simpleParameterList;
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public boolean isAsync() {
        return this.getFlag(0x2000000) != 0;
    }

    public boolean isArrow() {
        return this.getFlag(65536) != 0;
    }

    public boolean isGenerator() {
        return this.getFlag(0x1000000) != 0;
    }

    public boolean isScriptOrModule() {
        return this.getFlag(132096) != 0;
    }

    public ParserContextBlockNode getParameterBlock() {
        return this.parameterBlock;
    }

    public void addDefaultParameter(VarNode varNode) {
        this.ensureParameterBlock();
        this.parameterBlock.appendStatement(varNode);
        this.addParameterBinding(varNode.getName());
        this.recordParameter(true, false, false);
    }

    public void addParameterBindingDeclaration(VarNode varNode) {
        this.ensureParameterBlock();
        this.parameterBlock.appendStatement(varNode);
        this.addParameterBinding(varNode.getName());
    }

    public void addParameterInitialization(int lineNumber, Expression assignment, boolean isDefault) {
        this.ensureParameterBlock();
        this.parameterBlock.appendStatement(new ExpressionStatement(lineNumber, assignment.getToken(), assignment.getFinish(), assignment));
        this.recordParameter(isDefault, false, true);
    }

    private void ensureParameterBlock() {
        if (this.parameterBlock == null) {
            this.initParameterBlock();
        }
    }

    private void initParameterBlock() {
        assert (this.bodyBlock == null);
        this.parameterBlock = new ParserContextBlockNode(this.token, Scope.createParameter(this.parentScope));
        this.parameterBlock.setFlag(64);
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                IdentNode paramIdent = this.parameters.get(i);
                this.addParameterInit(paramIdent, i);
            }
        }
        this.parameters = Collections.emptyList();
    }

    private void addParameterInit(IdentNode param, int index) {
        long paramToken = param.getToken();
        int paramFinish = param.getFinish();
        ParameterNode paramValue = param.isRestParameter() ? new ParameterNode(paramToken, paramFinish, index, true) : new ParameterNode(paramToken, paramFinish, index);
        this.parameterBlock.appendStatement(new VarNode(this.line, Token.recast(paramToken, TokenType.LET), paramFinish, param, paramValue, 1));
        this.declareParameter(param.getName());
    }

    private void declareParameter(String parameterName) {
        if (this.parameterBlock != null) {
            this.parameterBlock.getScope().putSymbol(new Symbol(parameterName, 17));
        }
    }

    private void finalizeParameters() {
        if (this.parameterBlock == null) {
            if (this.parameters != null) {
                for (int i = 0; i < this.parameters.size(); ++i) {
                    IdentNode parameter = this.parameters.get(i);
                    this.bodyBlock.getScope().putSymbol(new Symbol(parameter.getName(), 20));
                }
            }
        } else {
            this.parameterBlock.getScope().close();
        }
    }

    public ParserContextBlockNode getBodyBlock() {
        return this.bodyBlock;
    }

    public void setBodyBlock(ParserContextBlockNode bodyBlock) {
        assert (this.bodyBlock == null);
        this.bodyBlock = bodyBlock;
        this.finalizeParameters();
    }

    private static int calculateLength(List<IdentNode> parameters) {
        int length = 0;
        if (parameters != null) {
            for (IdentNode param : parameters) {
                if (param.isRestParameter()) break;
                ++length;
            }
        }
        return length;
    }
}

