/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.web;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ArtifactListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javaee.project.api.ClientSideDevelopmentSupport;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.j2ee.CopyOnSave;
import org.netbeans.modules.maven.j2ee.utils.MavenProjectSupport;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.common.api.CssPreprocessors;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class WebCopyOnSave
extends CopyOnSave
implements PropertyChangeListener,
J2eeModuleProvider.ConfigSupport.DeployOnSaveListener {
    private static final RequestProcessor RP = new RequestProcessor("Maven Copy on Save", 5);
    private static final Logger LOG = Logger.getLogger(WebCopyOnSave.class.getName());
    private static final List<String> nonStaticResources = new ArrayList<String>();
    private final Project project;
    private final FileChangeListener listener;
    private FileObject docBase;
    private FileObject webInf;
    private boolean active;

    public WebCopyOnSave(Project project) {
        super(project);
        this.project = project;
        this.listener = new FileListenerImpl();
        this.active = false;
    }

    private WebModule getWebModule() {
        J2eeModuleProvider moduleProvider = this.getJ2eeModuleProvider();
        if (moduleProvider != null && moduleProvider instanceof WebModuleProviderImpl) {
            return ((WebModuleProviderImpl)moduleProvider).findWebModule(this.getProject().getProjectDirectory());
        }
        return null;
    }

    @Override
    public void initialize() {
        if (!this.active) {
            this.initializeListeners();
            NbMavenProject.addPropertyChangeListener((Project)this.getProject(), (PropertyChangeListener)this);
            this.active = true;
        }
    }

    private void initializeListeners() {
        J2eeModuleProvider moduleProvider;
        WebModule webModule = this.getWebModule();
        if (webModule != null) {
            this.docBase = webModule.getDocumentBase();
            if (this.docBase != null) {
                this.docBase.addRecursiveListener(this.listener);
            }
            this.webInf = webModule.getWebInf();
            if (this.webInf != null) {
                this.webInf.addRecursiveListener(this.listener);
            }
        }
        if ((moduleProvider = this.getJ2eeModuleProvider()) != null) {
            moduleProvider.getConfigSupport().addDeployOnSaveListener((J2eeModuleProvider.ConfigSupport.DeployOnSaveListener)this);
        }
    }

    @Override
    public void cleanup() {
        if (this.active) {
            this.cleanUpListeners();
            NbMavenProject.removePropertyChangeListener((Project)this.getProject(), (PropertyChangeListener)this);
            this.active = false;
        }
    }

    private void cleanUpListeners() {
        J2eeModuleProvider moduleProvider;
        if (this.docBase != null) {
            this.docBase.removeRecursiveListener(this.listener);
        }
        if (this.webInf != null) {
            this.webInf.removeRecursiveListener(this.listener);
        }
        if ((moduleProvider = this.getJ2eeModuleProvider()) != null) {
            moduleProvider.getConfigSupport().removeDeployOnSaveListener((J2eeModuleProvider.ConfigSupport.DeployOnSaveListener)this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("MavenProject".equals(evt.getPropertyName()) && this.active) {
            this.cleanUpListeners();
            this.initializeListeners();
        }
    }

    public void deployed(Iterable<ArtifactListener.Artifact> artifacts) {
        ClientSideDevelopmentSupport easelSupport = (ClientSideDevelopmentSupport)this.project.getLookup().lookup(ClientSideDevelopmentSupport.class);
        if (easelSupport == null || !easelSupport.canReload()) {
            return;
        }
        for (ArtifactListener.Artifact artifact : artifacts) {
            FileObject fileObject = this.getReloadFileObject(artifact);
            if (fileObject == null) continue;
            easelSupport.reload(fileObject);
        }
    }

    private FileObject getReloadFileObject(ArtifactListener.Artifact artifact) {
        File file = artifact.getFile();
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObject == null) {
            return null;
        }
        return this.getWebDocFileObject(fileObject);
    }

    private FileObject getWebDocFileObject(FileObject artifact) {
        J2eeModule j2eeModule = this.getJ2eeModule();
        if (j2eeModule != null) {
            try {
                FileObject webBuildBase = j2eeModule.getContentDirectory();
                if (this.docBase != null && webBuildBase != null) {
                    if (!FileUtil.isParentOf((FileObject)webBuildBase, (FileObject)artifact)) {
                        return null;
                    }
                    String path = FileUtil.getRelativePath((FileObject)webBuildBase, (FileObject)artifact);
                    return this.docBase.getFileObject(path);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    @Override
    protected String getDestinationSubFolderName() {
        return "WEB-INF/classes";
    }

    static {
        nonStaticResources.add("java");
        nonStaticResources.add("groovy");
    }

    private class FileListenerImpl
    extends FileChangeAdapter {
        private FileListenerImpl() {
        }

        private void checkPreprocessors(FileObject fileObject) {
            CssPreprocessors.getDefault().process(WebCopyOnSave.this.project, fileObject);
        }

        private void checkPreprocessors(FileObject fileObject, String originalName, String originalExtension) {
            CssPreprocessors.getDefault().process(WebCopyOnSave.this.project, fileObject, originalName, originalExtension);
        }

        public void fileFolderCreated(final FileEvent fe) {
            if (SwingUtilities.isEventDispatchThread()) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        FileListenerImpl.this.fileFolderCreated(fe);
                    }
                });
                return;
            }
            this.handleFolderCreated(fe.getFile());
        }

        public void fileChanged(final FileEvent fe) {
            if (SwingUtilities.isEventDispatchThread()) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        FileListenerImpl.this.fileChanged(fe);
                    }
                });
                return;
            }
            this.handleFileChangeEvent(fe.getFile());
        }

        public void fileDataCreated(final FileEvent fe) {
            if (SwingUtilities.isEventDispatchThread()) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        FileListenerImpl.this.fileDataCreated(fe);
                    }
                });
                return;
            }
            this.handleFileChangeEvent(fe.getFile());
        }

        public void fileRenamed(final FileRenameEvent fe) {
            if (SwingUtilities.isEventDispatchThread()) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        FileListenerImpl.this.fileRenamed(fe);
                    }
                });
                return;
            }
            try {
                this.checkPreprocessors(fe.getFile(), fe.getName(), fe.getExt());
                if (this.isInPlace()) {
                    return;
                }
                FileObject fo = fe.getFile();
                FileObject base = this.findWebDocRoot(fo);
                if (base != null) {
                    this.handleFileCopying(fo);
                    FileObject parent = fo.getParent();
                    String path = FileUtil.isParentOf((FileObject)base, (FileObject)parent) ? FileUtil.getRelativePath((FileObject)base, (FileObject)fo.getParent()) + "/" + fe.getName() + "." + fe.getExt() : fe.getName() + "." + fe.getExt();
                    if (!this.isSynchronizationAppropriate(path)) {
                        return;
                    }
                    this.handleFileDeletion(fo, path);
                }
            }
            catch (IOException e) {
                this.logIOException(fe.getFile(), e);
            }
        }

        public void fileDeleted(final FileEvent fe) {
            if (SwingUtilities.isEventDispatchThread()) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        FileListenerImpl.this.fileDeleted(fe);
                    }
                });
                return;
            }
            try {
                this.checkPreprocessors(fe.getFile());
                if (!this.isInPlace()) {
                    this.handleFileDeletion(fe.getFile(), null);
                }
            }
            catch (IOException e) {
                this.logIOException(fe.getFile(), e);
            }
        }

        private void logIOException(FileObject fo, IOException ex) {
            LOG.log(Level.INFO, "IOException occured while trying to use Compile on Save/Deploy on Save feature on a changed file ({1}). Please attach this message log to NetBeans bugzilla issue (ID number #236766) with some more datails about what you have been doing when the problem occuered.", fo);
            LOG.log(Level.INFO, "Compile on Save: ", RunUtils.isCompileOnSaveEnabled((Project)WebCopyOnSave.this.project));
            LOG.log(Level.INFO, "Deploy on Save: ", MavenProjectSupport.isDeployOnSave(WebCopyOnSave.this.project));
            LOG.log(Level.INFO, "Copy on Save for static resrouces: ", MavenProjectSupport.isCopyStaticResourcesOnSave(WebCopyOnSave.this.project));
            LOG.log(Level.INFO, "Stacktrace:", ex);
        }

        private boolean isInPlace() throws IOException {
            WebModule webModule = WebCopyOnSave.this.getWebModule();
            J2eeModule j2eeModule = WebCopyOnSave.this.getJ2eeModule();
            if (j2eeModule == null || webModule == null) {
                return false;
            }
            FileObject fo = j2eeModule.getContentDirectory();
            if (fo == null) {
                return false;
            }
            return fo.equals(webModule.getDocumentBase());
        }

        private void handleFolderCreated(FileObject folder) {
            FileObject[] fos;
            for (FileObject fo : fos = folder.getChildren()) {
                if (fo.isData()) {
                    this.handleFileChangeEvent(fo);
                    continue;
                }
                this.handleFolderCreated(fo);
            }
        }

        private void handleFileChangeEvent(FileObject fo) {
            try {
                this.checkPreprocessors(fo);
                if (!this.isInPlace()) {
                    this.handleFileCopying(fo);
                }
            }
            catch (IOException e) {
                this.logIOException(fo, e);
            }
        }

        private void handleFileCopying(FileObject fo) throws IOException {
            boolean compileOnSave = RunUtils.isCompileOnSaveEnabled((Project)WebCopyOnSave.this.project);
            boolean deployOnSave = !compileOnSave ? false : MavenProjectSupport.isDeployOnSave(WebCopyOnSave.this.project);
            boolean copyStaticResourcesOnSave = MavenProjectSupport.isCopyStaticResourcesOnSave(WebCopyOnSave.this.project);
            if (deployOnSave && copyStaticResourcesOnSave) {
                this.copyFileToDestDir(fo);
            }
            if (!deployOnSave && copyStaticResourcesOnSave && this.isStaticResource(fo.getExt())) {
                this.copyFileToDestDir(fo);
            }
        }

        private void handleFileDeletion(FileObject fo, String path) throws IOException {
            boolean compileOnSave = RunUtils.isCompileOnSaveEnabled((Project)WebCopyOnSave.this.project);
            boolean deployOnSave = !compileOnSave ? false : MavenProjectSupport.isDeployOnSave(WebCopyOnSave.this.project);
            boolean copyStaticResourcesOnSave = MavenProjectSupport.isCopyStaticResourcesOnSave(WebCopyOnSave.this.project);
            if (deployOnSave && copyStaticResourcesOnSave) {
                this.deleteFileToDestDir(fo, path);
            }
            if (!deployOnSave && copyStaticResourcesOnSave && this.isStaticResource(fo.getExt())) {
                this.deleteFileToDestDir(fo, path);
            }
        }

        private boolean isStaticResource(String fileExt) {
            return !nonStaticResources.contains(fileExt);
        }

        private void deleteFileToDestDir(FileObject fo, String path) throws IOException {
            FileObject root = this.findWebDocRoot(fo);
            if (root != null) {
                FileObject toDelete;
                String string = path = path != null ? path : FileUtil.getRelativePath((FileObject)root, (FileObject)fo);
                if (!this.isSynchronizationAppropriate(path)) {
                    return;
                }
                J2eeModule j2eeModule = WebCopyOnSave.this.getJ2eeModule();
                if (j2eeModule == null) {
                    return;
                }
                FileObject webBuildBase = j2eeModule.getContentDirectory();
                if (webBuildBase != null && (toDelete = webBuildBase.getFileObject(path)) != null) {
                    File fil = FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)toDelete));
                    toDelete.delete();
                    WebCopyOnSave.this.fireArtifactChange(Collections.singleton(ArtifactListener.Artifact.forFile((File)fil)));
                }
            }
        }

        private void copyFileToDestDir(FileObject fo) throws IOException {
            FileObject documentBase;
            if (!fo.isVirtual() && (documentBase = this.findWebDocRoot(fo)) != null) {
                String path = FileUtil.getRelativePath((FileObject)documentBase, (FileObject)fo);
                if (!this.isSynchronizationAppropriate(path)) {
                    return;
                }
                J2eeModule j2eeModule = WebCopyOnSave.this.getJ2eeModule();
                if (j2eeModule == null) {
                    return;
                }
                FileObject webBuildBase = j2eeModule.getContentDirectory();
                if (webBuildBase != null) {
                    if (FileUtil.isParentOf((FileObject)documentBase, (FileObject)webBuildBase) || FileUtil.isParentOf((FileObject)webBuildBase, (FileObject)documentBase)) {
                        return;
                    }
                    FileObject destFile = WebCopyOnSave.this.ensureDestinationFileExists(webBuildBase, path, fo.isFolder());
                    File fil = FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)destFile));
                    WebCopyOnSave.this.copySrcToDest(fo, destFile);
                    WebCopyOnSave.this.fireArtifactChange(Collections.singleton(ArtifactListener.Artifact.forFile((File)fil)));
                }
            }
        }

        private boolean isSynchronizationAppropriate(String filePath) {
            if (filePath.startsWith("WEB-INF/classes")) {
                return false;
            }
            if (filePath.startsWith("WEB-INF/src")) {
                return false;
            }
            return !filePath.startsWith("WEB-INF/lib");
        }

        private FileObject findWebDocRoot(FileObject child) {
            FileObject documentBase;
            WebModule webModule = WebCopyOnSave.this.getWebModule();
            if (webModule != null && (documentBase = webModule.getDocumentBase()) != null && FileUtil.isParentOf((FileObject)documentBase, (FileObject)child)) {
                return documentBase;
            }
            return null;
        }
    }
}

