/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.api.ui.ConsoleDataDisplayer;
import org.netbeans.modules.hudson.api.ui.FailureDataDisplayer;
import org.netbeans.modules.hudson.api.ui.OpenableInBrowser;
import org.netbeans.modules.hudson.impl.Bundle;
import org.netbeans.modules.hudson.impl.HudsonJobImpl;
import org.netbeans.modules.hudson.spi.BuilderConnector;
import org.netbeans.modules.hudson.spi.ConsoleDataDisplayerImpl;
import org.netbeans.modules.hudson.spi.FailureDataDisplayerImpl;
import org.netbeans.modules.hudson.spi.HudsonJobChangeItem;
import org.openide.filesystems.FileSystem;

public class HudsonJobBuildImpl
implements HudsonJobBuild,
OpenableInBrowser {
    private static final Logger LOG = Logger.getLogger(HudsonJobBuildImpl.class.getName());
    private final HudsonJobImpl job;
    private final int build;
    private boolean building;
    private HudsonJobBuild.Result result;
    private final BuilderConnector connector;
    private Collection<? extends HudsonJobChangeItem> changes;

    HudsonJobBuildImpl(BuilderConnector connector, HudsonJobImpl job, int build, boolean building, HudsonJobBuild.Result result) {
        this.connector = connector;
        this.job = job;
        this.build = build;
        this.building = building;
        this.result = result;
    }

    @Override
    public HudsonJob getJob() {
        return this.job;
    }

    @Override
    public int getNumber() {
        return this.build;
    }

    @Override
    public String getUrl() {
        return this.job.getUrl() + this.build + "/";
    }

    public String toString() {
        return this.getUrl();
    }

    @Override
    public boolean isBuilding() {
        this.getResult();
        return this.building;
    }

    @Override
    public synchronized HudsonJobBuild.Result getResult() {
        if (this.result == null && !this.building) {
            AtomicBoolean _building = new AtomicBoolean();
            AtomicReference<HudsonJobBuild.Result> _result = new AtomicReference<HudsonJobBuild.Result>(HudsonJobBuild.Result.NOT_BUILT);
            this.connector.getJobBuildResult(this, _building, _result);
            this.building = _building.get();
            this.result = _result.get();
        }
        return this.result != null ? this.result : HudsonJobBuild.Result.NOT_BUILT;
    }

    @Override
    public Collection<? extends HudsonJobChangeItem> getChanges() {
        if (this.changes == null || this.changes.isEmpty()) {
            this.changes = this.connector.getJobBuildChanges(this);
        }
        return this.changes;
    }

    @Override
    public FileSystem getArtifacts() {
        return this.job.getInstance().getArtifacts(this);
    }

    @Override
    public Collection<? extends HudsonMavenModuleBuild> getMavenModules() {
        ArrayList<HudsonMavenModuleBuildImpl> modules = new ArrayList<HudsonMavenModuleBuildImpl>();
        for (HudsonJobImpl.HudsonMavenModule module : this.job.mavenModules) {
            modules.add(new HudsonMavenModuleBuildImpl(module));
        }
        return modules;
    }

    @Override
    public String getDisplayName() {
        return Bundle.HudsonJobBuildImpl_display_name(this.job.getDisplayName(), this.getNumber());
    }

    private ConsoleDataDisplayer createDisplayerFromImpl(final ConsoleDataDisplayerImpl displayerImpl) {
        return new ConsoleDataDisplayer(){

            @Override
            public void open() {
                displayerImpl.open();
            }

            @Override
            public boolean writeLine(String line) {
                return displayerImpl.writeLine(line);
            }

            @Override
            public void close() {
                displayerImpl.close();
            }
        };
    }

    private FailureDataDisplayer createDisplayerFromImpl(final FailureDataDisplayerImpl displayerImpl) {
        return new FailureDataDisplayer(){

            @Override
            public void open() {
                displayerImpl.open();
            }

            @Override
            public void showSuite(FailureDataDisplayer.Suite suite) {
                displayerImpl.showSuite(suite);
            }

            @Override
            public void close() {
                displayerImpl.close();
            }
        };
    }

    @Override
    public boolean canShowConsole() {
        return this.connector.getConsoleDataProvider() != null;
    }

    @Override
    public void showConsole(ConsoleDataDisplayerImpl displayer) {
        BuilderConnector.ConsoleDataProvider cd = this.connector.getConsoleDataProvider();
        if (cd != null) {
            cd.showConsole(this, this.createDisplayerFromImpl(displayer));
        }
    }

    @Override
    public boolean canShowFailures() {
        return this.connector.getFailureDataProvider() != null;
    }

    @Override
    public void showFailures(FailureDataDisplayerImpl displayer) {
        BuilderConnector.FailureDataProvider fd = this.connector.getFailureDataProvider();
        if (fd != null) {
            fd.showFailures(this, this.createDisplayerFromImpl(displayer));
        }
    }

    private final class HudsonMavenModuleBuildImpl
    implements HudsonMavenModuleBuild,
    OpenableInBrowser {
        private final HudsonJobImpl.HudsonMavenModule module;

        HudsonMavenModuleBuildImpl(HudsonJobImpl.HudsonMavenModule module) {
            this.module = module;
        }

        @Override
        public String getName() {
            return this.module.name;
        }

        @Override
        public String getDisplayName() {
            return this.module.displayName;
        }

        @Override
        public HudsonJob.Color getColor() {
            return this.module.color;
        }

        @Override
        public String getUrl() {
            return this.module.url + HudsonJobBuildImpl.this.build + "/";
        }

        @Override
        public HudsonJobBuild getBuild() {
            return HudsonJobBuildImpl.this;
        }

        @Override
        public FileSystem getArtifacts() {
            return HudsonJobBuildImpl.this.job.getInstance().getArtifacts(this);
        }

        public String toString() {
            return this.getUrl();
        }

        @Override
        public String getBuildDisplayName() {
            return Bundle.HudsonJobBuildImpl_display_name(this.getDisplayName(), HudsonJobBuildImpl.this.getNumber());
        }

        @Override
        public boolean canShowConsole() {
            return this.getBuild().canShowConsole();
        }

        @Override
        public void showConsole(ConsoleDataDisplayerImpl displayer) {
            BuilderConnector.ConsoleDataProvider cd = HudsonJobBuildImpl.this.connector.getConsoleDataProvider();
            if (cd != null) {
                cd.showConsole(this, HudsonJobBuildImpl.this.createDisplayerFromImpl(displayer));
            }
        }

        @Override
        public boolean canShowFailures() {
            return this.getBuild().canShowFailures();
        }

        @Override
        public void showFailures(FailureDataDisplayerImpl displayer) {
            BuilderConnector.FailureDataProvider fp = HudsonJobBuildImpl.this.connector.getFailureDataProvider();
            if (fp != null) {
                fp.showFailures(this, HudsonJobBuildImpl.this.createDisplayerFromImpl(displayer));
            }
        }
    }
}

