/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.jakartaee.db;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DatasourceManager;
import org.netbeans.modules.j2ee.sun.dd.api.RootInterface;
import org.netbeans.modules.javaee.specs.support.api.util.JndiNamespacesDefinition;
import org.netbeans.modules.payara.common.PayaraState;
import org.netbeans.modules.payara.common.parser.TreeParser;
import org.netbeans.modules.payara.eecommon.api.UrlData;
import org.netbeans.modules.payara.eecommon.api.config.PayaraConfiguration;
import org.netbeans.modules.payara.jakartaee.ApplicationScopedResourcesUtils;
import org.netbeans.modules.payara.jakartaee.Hk2DeploymentManager;
import org.netbeans.modules.payara.jakartaee.db.DataSourcesReader;
import org.netbeans.modules.payara.jakartaee.db.DbUtil;
import org.netbeans.modules.payara.jakartaee.db.DriverMaps;
import org.netbeans.modules.payara.jakartaee.db.SunDatasource;
import org.netbeans.modules.payara.jakartaee.db.VendorNameMgr;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.data.PayaraVersion;
import org.netbeans.modules.payara.tooling.utils.OsUtils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Hk2DatasourceManager
implements DatasourceManager {
    private static final String DOMAIN_XML_PATH = OsUtils.joinPaths((String)"config", (String)"domain.xml");
    private Hk2DeploymentManager dm;
    private static final String CP_TAG_1 = "    <jdbc-connection-pool allow-non-component-callers=\"false\" associate-with-thread=\"false\" connection-creation-retry-attempts=\"0\" connection-creation-retry-interval-in-seconds=\"10\" connection-leak-reclaim=\"false\" connection-leak-timeout-in-seconds=\"0\" connection-validation-method=\"auto-commit\" ";
    private static final String ATTR_DATASOURCE_CLASSNAME = "datasource-classname";
    private static final String CP_TAG_2 = "fail-all-connections=\"false\" idle-timeout-in-seconds=\"300\" is-connection-validation-required=\"false\" is-isolation-level-guaranteed=\"true\" lazy-connection-association=\"false\" lazy-connection-enlistment=\"false\" match-connections=\"false\" max-connection-usage-count=\"0\" max-pool-size=\"32\" max-wait-time-in-millis=\"60000\" ";
    private static final String ATTR_POOL_NAME = "name";
    private static final String CP_TAG_3 = "non-transactional-connections=\"false\" pool-resize-quantity=\"2\" ";
    private static final String ATTR_RES_TYPE = "res-type";
    private static final String CP_TAG_4 = "statement-timeout-in-seconds=\"-1\" steady-pool-size=\"8\" validate-atmost-once-period-in-seconds=\"0\" wrap-jdbc-objects=\"false\">\n";
    private static final String PROP_SERVER_NAME = "serverName";
    private static final String PROP_PORT_NUMBER = "portNumber";
    private static final String PROP_DATABASE_NAME = "databaseName";
    private static final String PROP_USER = "User";
    private static final String PROP_PASSWORD = "Password";
    private static final String PROP_URL = "URL";
    private static final String PROP_DRIVER_CLASS = "driverClass";
    private static final String CP_TAG_5 = "    </jdbc-connection-pool>\n";
    private static final String RESTYPE_DATASOURCE = "javax.sql.DataSource";
    private static final String JDBC_TAG_1 = "    <jdbc-resource enabled=\"true\" ";
    private static final String ATTR_POOLNAME = "pool-name";
    private static final String ATTR_JNDINAME = "jndi-name";
    private static final String JDBC_TAG_2 = " object-type=\"user\"/>\n";
    private static final String SUN_RESOURCES_XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE resources PUBLIC \"-//Sun Microsystems, Inc.//DTD Application Server 9.0 Resource Definitions //EN\" \"http://www.sun.com/software/appserver/dtds/sun-resources_1_3.dtd\">\n<resources/>";
    private static final String GF_RESOURCES_XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE resources PUBLIC \"-//GlassFish.org//DTD GlassFish Application Server 3.1 Resource Definitions//EN\" \"http://glassfish.org/dtds/glassfish-resources_1_5.dtd\">\n<resources/>";

    public Hk2DatasourceManager(Hk2DeploymentManager dm) {
        this.dm = dm;
    }

    public Set<Datasource> getDatasources() throws ConfigurationException {
        DataSourcesReader dataSourcesReader;
        Set<Datasource> dataSources;
        PayaraServer server = this.dm.getCommonServerSupport().getInstance();
        String domainsDir = server.getDomainsFolder();
        String domainName = server.getDomainName();
        if ((PayaraState.isOnline((PayaraServer)server) || server.isRemote()) && (dataSources = (dataSourcesReader = new DataSourcesReader(server)).getDataSourcesFromServer()) != null) {
            return Hk2DatasourceManager.translate(dataSources);
        }
        if (!server.isRemote() && null != domainsDir) {
            File domainXml = new File(domainsDir, domainName + File.separatorChar + DOMAIN_XML_PATH);
            return Hk2DatasourceManager.readDatasources(domainXml, "/domain/", null, server.getVersion(), false);
        }
        return Collections.emptySet();
    }

    public void deployDatasources(Set<Datasource> datasources) throws ConfigurationException, DatasourceAlreadyExistsException {
    }

    public static Set<Datasource> getDatasources(J2eeModule module, PayaraVersion version) {
        Pair result = PayaraConfiguration.getExistingResourceFile((J2eeModule)module, (PayaraVersion)version);
        if (result != null) {
            return Hk2DatasourceManager.readDatasources((File)result.first(), "/", module, version, (Boolean)result.second());
        }
        return new HashSet<Datasource>();
    }

    private static Set<Datasource> translate(Collection<Datasource> sources) {
        HashSet<Datasource> ret = new HashSet<Datasource>();
        for (Datasource ds : sources) {
            ret.add(new SunDatasource(ds.getJndiName(), ds.getUrl(), ds.getUsername(), ds.getPassword(), ds.getDriverClassName()));
        }
        return ret;
    }

    private static ApplicationScopedResourcesUtils.ResourceFileDescription resourceFileForDSCreation(String jndiName, String url, String username, String password, String driver, J2eeModule module, PayaraVersion version, ConnectionPoolFinder cpFinder) throws ConfigurationException, DatasourceAlreadyExistsException {
        File file;
        Pair pair = PayaraConfiguration.getExistingResourceFile((J2eeModule)module, (PayaraVersion)version);
        File file2 = file = pair == null ? null : (File)pair.first();
        if (file != null && file.exists()) {
            DuplicateJdbcResourceFinder jdbcFinder = new DuplicateJdbcResourceFinder(jndiName);
            JndiNamespaceFinder namespaceFinder = new JndiNamespaceFinder();
            ArrayList<TreeParser.Path> pathList = new ArrayList<TreeParser.Path>();
            pathList.add(new TreeParser.Path("/resources/jdbc-resource", (TreeParser.NodeReader)new ProxyNodeReader(jdbcFinder, namespaceFinder)));
            pathList.add(new TreeParser.Path("/resources/jdbc-connection-pool", (TreeParser.NodeReader)new ProxyNodeReader(cpFinder, namespaceFinder)));
            pathList.add(new TreeParser.Path("/resources/custom-resource", (TreeParser.NodeReader)namespaceFinder));
            pathList.add(new TreeParser.Path("/resources/mail-resource", (TreeParser.NodeReader)namespaceFinder));
            pathList.add(new TreeParser.Path("/resources/admin-object-resource", (TreeParser.NodeReader)namespaceFinder));
            pathList.add(new TreeParser.Path("/resources/connector-resource", (TreeParser.NodeReader)namespaceFinder));
            pathList.add(new TreeParser.Path("/resources/connector-connection-pool", (TreeParser.NodeReader)namespaceFinder));
            try {
                TreeParser.readXml((File)file, pathList);
                if (jdbcFinder.isDuplicate()) {
                    throw new DatasourceAlreadyExistsException((Datasource)new SunDatasource(jndiName, url, username, password, driver));
                }
            }
            catch (IllegalStateException ex) {
                Logger.getLogger("payara-jakartaee").log(Level.INFO, ex.getLocalizedMessage(), ex);
                throw new ConfigurationException(ex.getLocalizedMessage(), (Throwable)ex);
            }
            return new ApplicationScopedResourcesUtils.ResourceFileDescription(file, (Boolean)pair.second(), namespaceFinder.getNamespaces());
        }
        pair = PayaraConfiguration.getNewResourceFile((J2eeModule)module, (PayaraVersion)version);
        return new ApplicationScopedResourcesUtils.ResourceFileDescription((File)pair.first(), (Boolean)pair.second(), Collections.emptySet());
    }

    public static Datasource createDataSource(String jndiName, String url, String username, String password, String driver, J2eeModule module, PayaraVersion version) throws ConfigurationException, DatasourceAlreadyExistsException {
        SunDatasource ds;
        ConnectionPoolFinder cpFinder = new ConnectionPoolFinder();
        ApplicationScopedResourcesUtils.ResourceFileDescription fileDesc = Hk2DatasourceManager.resourceFileForDSCreation(jndiName, url, username, password, driver, module, version, cpFinder);
        File xmlFile = fileDesc.getFile();
        try {
            String vendorName = VendorNameMgr.vendorNameFromDbUrl(url);
            if (vendorName == null) {
                vendorName = jndiName;
            } else if ("derby_embedded".equals(vendorName)) {
                Logger.getLogger("payara-jakartaee").log(Level.WARNING, "Embedded derby not supported as a datasource");
                return null;
            }
            String defaultPoolName = Hk2DatasourceManager.computePoolName(url, vendorName, username);
            Map<String, CPool> pools = cpFinder.getPoolData();
            CPool defaultPool = pools.get(defaultPoolName);
            String poolName = null;
            if (defaultPool != null && Hk2DatasourceManager.isSameDatabaseConnection(defaultPool, url, username, password)) {
                poolName = defaultPoolName;
            } else {
                for (CPool pool : pools.values()) {
                    if (!Hk2DatasourceManager.isSameDatabaseConnection(pool, url, username, password)) continue;
                    poolName = pool.getPoolName();
                    break;
                }
            }
            if (poolName == null) {
                poolName = defaultPool == null ? defaultPoolName : Hk2DatasourceManager.generateUniqueName(defaultPoolName, pools.keySet());
                Hk2DatasourceManager.createConnectionPool(xmlFile, poolName, url, username, password, driver);
            }
            fileDesc = ApplicationScopedResourcesUtils.checkNamespaces(module, fileDesc, JndiNamespacesDefinition.getNamespace((String)jndiName));
            String realJndiName = ApplicationScopedResourcesUtils.getJndiName(jndiName, fileDesc);
            Hk2DatasourceManager.createJdbcResource(xmlFile, realJndiName, poolName);
            ds = new SunDatasource(realJndiName, url, username, password, driver, fileDesc.isIsApplicationScoped(), null);
        }
        catch (IOException ex) {
            Logger.getLogger("payara-jakartaee").log(Level.INFO, ex.getLocalizedMessage(), ex);
            throw new ConfigurationException(ex.getLocalizedMessage(), (Throwable)ex);
        }
        return ds;
    }

    private static Set<Datasource> readDatasources(File xmlFile, String xPathPrefix, J2eeModule module, PayaraVersion version, boolean applicationScoped) {
        HashSet<Datasource> dataSources = new HashSet<Datasource>();
        if (xmlFile.canRead()) {
            LinkedList<JdbcResource> jdbcResources = new LinkedList<JdbcResource>();
            HashMap<String, ConnectionPool> connectionPoolMap = new HashMap<String, ConnectionPool>();
            JndiNamespaceFinder namespaceFinder = new JndiNamespaceFinder();
            ArrayList<TreeParser.Path> pathList = new ArrayList<TreeParser.Path>();
            pathList.add(new TreeParser.Path(xPathPrefix + "resources/jdbc-resource", (TreeParser.NodeReader)new ProxyNodeReader(new JdbcReader(jdbcResources), namespaceFinder)));
            pathList.add(new TreeParser.Path(xPathPrefix + "resources/jdbc-connection-pool", (TreeParser.NodeReader)new ProxyNodeReader(new ConnectionPoolReader(connectionPoolMap), namespaceFinder)));
            pathList.add(new TreeParser.Path("/resources/custom-resource", (TreeParser.NodeReader)namespaceFinder));
            pathList.add(new TreeParser.Path("/resources/mail-resource", (TreeParser.NodeReader)namespaceFinder));
            pathList.add(new TreeParser.Path("/resources/admin-object-resource", (TreeParser.NodeReader)namespaceFinder));
            pathList.add(new TreeParser.Path("/resources/connector-resource", (TreeParser.NodeReader)namespaceFinder));
            pathList.add(new TreeParser.Path("/resources/connector-connection-pool", (TreeParser.NodeReader)namespaceFinder));
            try {
                TreeParser.readXml((File)xmlFile, pathList);
            }
            catch (IllegalStateException ex) {
                Logger.getLogger("payara-jakartaee").log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
            ApplicationScopedResourcesUtils.ResourceFileDescription fileDesc = new ApplicationScopedResourcesUtils.ResourceFileDescription(xmlFile, applicationScoped, namespaceFinder.getNamespaces());
            UserResolver resolver = applicationScoped && module != null ? new UserResolver(module, fileDesc) : null;
            for (JdbcResource jdbc : jdbcResources) {
                ConnectionPool pool = (ConnectionPool)connectionPoolMap.get(jdbc.getPoolName());
                if (pool == null) continue;
                try {
                    pool.normalize();
                    String url = pool.getProperty(PROP_URL);
                    String username = pool.getProperty(PROP_USER);
                    String password = pool.getProperty(PROP_PASSWORD);
                    String driverClassName = pool.getProperty(PROP_DRIVER_CLASS);
                    SunDatasource dataSource = new SunDatasource(jdbc.getJndiName(), url, username, password, driverClassName, applicationScoped, resolver);
                    dataSources.add(dataSource);
                    if (version == null || version.ordinal() < PayaraVersion.PF_4_1_144.ordinal() || !"jdbc/__default".equals(jdbc.getJndiName())) continue;
                    dataSources.add(dataSource.copy("java:comp/DefaultDataSource"));
                }
                catch (NullPointerException npe) {
                    Logger.getLogger("payara-jakartaee").log(Level.INFO, pool.toString(), npe);
                }
            }
        }
        return dataSources;
    }

    private static String generateUniqueName(String prefix, Set<String> keys) {
        int i = 1;
        String candidate;
        while (keys.contains(candidate = prefix + "_" + i)) {
            ++i;
        }
        return candidate;
    }

    private static boolean isSameDatabaseConnection(CPool pool, String url, String username, String password) {
        boolean result = false;
        UrlData urlData = new UrlData(url);
        boolean matchedSettings = DbUtil.strEmpty(pool.getUrl()) ? DbUtil.strEquivalent(urlData.getHostName(), pool.getHostname()) && DbUtil.strEquivalent(urlData.getPort(), pool.getPort()) && DbUtil.strEquivalent(urlData.getDatabaseName(), pool.getDatabaseName()) && DbUtil.strEquivalent(urlData.getSid(), pool.getSid()) : DbUtil.strEquivalent(url, pool.getUrl());
        if (matchedSettings && DbUtil.strEquivalent(username, pool.getUsername()) && DbUtil.strEquivalent(password, pool.getPassword())) {
            result = true;
        }
        return result;
    }

    public static void createConnectionPool(File sunResourcesXml, String poolName, String url, String username, String password, String driver) throws IOException {
        Node resourcesNode;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilder = docFactory.newDocumentBuilder();
            docBuilder.setEntityResolver(DDResolver.getInstance());
            doc = Hk2DatasourceManager.readResourceFile(docBuilder, sunResourcesXml);
        }
        catch (ParserConfigurationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (doc == null || docBuilder == null) {
            return;
        }
        NodeList resourcesNodes = doc.getElementsByTagName("resources");
        if (resourcesNodes.getLength() < 1) {
            resourcesNode = doc.createElement("resources");
            doc.getDocumentElement().appendChild(resourcesNode);
        } else {
            resourcesNode = resourcesNodes.item(0);
        }
        try {
            Node newPool = resourcesNode.appendChild(doc.importNode(docBuilder.parse(new InputSource(new StringReader("    <jdbc-connection-pool allow-non-component-callers=\"false\" associate-with-thread=\"false\" connection-creation-retry-attempts=\"0\" connection-creation-retry-interval-in-seconds=\"10\" connection-leak-reclaim=\"false\" connection-leak-timeout-in-seconds=\"0\" connection-validation-method=\"auto-commit\" fail-all-connections=\"false\" idle-timeout-in-seconds=\"300\" is-connection-validation-required=\"false\" is-isolation-level-guaranteed=\"true\" lazy-connection-association=\"false\" lazy-connection-enlistment=\"false\" match-connections=\"false\" max-connection-usage-count=\"0\" max-pool-size=\"32\" max-wait-time-in-millis=\"60000\" non-transactional-connections=\"false\" pool-resize-quantity=\"2\" statement-timeout-in-seconds=\"-1\" steady-pool-size=\"8\" validate-atmost-once-period-in-seconds=\"0\" wrap-jdbc-objects=\"false\">\n    </jdbc-connection-pool>\n"))).getDocumentElement(), true));
            UrlData urlData = new UrlData(url);
            String dsClassName = Hk2DatasourceManager.computeDataSourceClassName(url, driver);
            Hk2DatasourceManager.appendAttr(doc, newPool, ATTR_DATASOURCE_CLASSNAME, dsClassName, false);
            Hk2DatasourceManager.appendAttr(doc, newPool, ATTR_POOL_NAME, poolName, true);
            Hk2DatasourceManager.appendAttr(doc, newPool, ATTR_RES_TYPE, RESTYPE_DATASOURCE, true);
            Hk2DatasourceManager.appendProperty(doc, newPool, PROP_SERVER_NAME, urlData.getHostName(), true);
            Hk2DatasourceManager.appendProperty(doc, newPool, PROP_PORT_NUMBER, urlData.getPort(), false);
            Hk2DatasourceManager.appendProperty(doc, newPool, PROP_DATABASE_NAME, urlData.getDatabaseName(), false);
            Hk2DatasourceManager.appendProperty(doc, newPool, PROP_USER, username, true);
            if (password != null) {
                Hk2DatasourceManager.appendProperty(doc, newPool, PROP_PASSWORD, password, true);
            }
            Hk2DatasourceManager.appendProperty(doc, newPool, PROP_URL, url, true);
            Hk2DatasourceManager.appendProperty(doc, newPool, PROP_DRIVER_CLASS, driver, true);
            Logger.getLogger("payara-jakartaee").log(Level.FINER, "New connection pool resource:\n{0}", newPool.getTextContent());
        }
        catch (SAXException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        Hk2DatasourceManager.writeXmlResourceToFile(sunResourcesXml, doc);
    }

    private static String computeDataSourceClassName(String url, String driver) {
        String vendorName = VendorNameMgr.vendorNameFromDbUrl(url);
        String dsClassName = VendorNameMgr.dsClassNameFromVendorName(vendorName);
        if (!(dsClassName != null && dsClassName.length() != 0 || (dsClassName = DriverMaps.getDSClassName(url)) != null && dsClassName.length() != 0)) {
            dsClassName = driver;
        }
        return dsClassName;
    }

    private static String computePoolName(String url, String vendorName, String username) {
        UrlData urlData = new UrlData(url);
        StringBuilder poolName = new StringBuilder(vendorName);
        String dbName = Hk2DatasourceManager.getDatabaseName(urlData);
        if (dbName != null) {
            poolName.append("_").append(dbName);
        }
        if (username != null) {
            poolName.append("_").append(username);
        }
        poolName.append("Pool");
        return poolName.toString();
    }

    private static String getDatabaseName(UrlData urlData) {
        String databaseName = urlData.getDatabaseName();
        if (databaseName == null) {
            databaseName = urlData.getAlternateDBName();
        }
        return databaseName;
    }

    public static void createJdbcResource(File sunResourcesXml, String jndiName, String poolName) throws IOException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilder = docFactory.newDocumentBuilder();
            docBuilder.setEntityResolver(DDResolver.getInstance());
            doc = Hk2DatasourceManager.readResourceFile(docBuilder, sunResourcesXml);
        }
        catch (ParserConfigurationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (doc == null || docBuilder == null) {
            return;
        }
        NodeList resourcesNodes = doc.getElementsByTagName("resources");
        Node resourcesNode = null;
        if (resourcesNodes.getLength() < 1) {
            throw new IOException("Malformed XML");
        }
        resourcesNode = resourcesNodes.item(0);
        try {
            Node newJdbcRes = resourcesNode.appendChild(doc.importNode(docBuilder.parse(new InputSource(new StringReader("    <jdbc-resource enabled=\"true\"  object-type=\"user\"/>\n"))).getDocumentElement(), true));
            Hk2DatasourceManager.appendAttr(doc, newJdbcRes, ATTR_POOLNAME, poolName, true);
            Hk2DatasourceManager.appendAttr(doc, newJdbcRes, ATTR_JNDINAME, jndiName, true);
            Logger.getLogger("payara-jakartaee").log(Level.FINER, "New JDBC resource:\n{0}", newJdbcRes.getTextContent());
        }
        catch (SAXException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        Hk2DatasourceManager.writeXmlResourceToFile(sunResourcesXml, doc);
    }

    private static void appendAttr(Document doc, Node node, String name, String value, boolean force) {
        if (force || name != null && name.length() > 0) {
            Attr attr = doc.createAttribute(name);
            attr.setValue(value);
            NamedNodeMap attrs = node.getAttributes();
            attrs.setNamedItem(attr);
        }
    }

    private static void appendProperty(Document doc, Node node, String name, String value, boolean force) {
        if (force || value != null && value.length() > 0) {
            Element newProperty = doc.createElement("property");
            Attr nameAttr = doc.createAttribute(ATTR_POOL_NAME);
            nameAttr.setValue(name);
            Attr valueAttr = doc.createAttribute("value");
            valueAttr.setValue(value);
            NamedNodeMap attrs = newProperty.getAttributes();
            attrs.setNamedItem(nameAttr);
            attrs.setNamedItem(valueAttr);
            node.appendChild(newProperty);
        }
    }

    private static Document readResourceFile(DocumentBuilder docBuilder, File sunResourcesXml) throws IOException {
        boolean newOne = false;
        if (!sunResourcesXml.exists()) {
            FileUtil.createData((File)sunResourcesXml);
            newOne = true;
        }
        Document doc = null;
        try {
            doc = newOne ? (sunResourcesXml.getAbsolutePath().contains("sun-resources.xml") ? docBuilder.parse(new InputSource(new StringReader(SUN_RESOURCES_XML_HEADER))) : docBuilder.parse(new InputSource(new StringReader(GF_RESOURCES_XML_HEADER)))) : docBuilder.parse(sunResourcesXml);
        }
        catch (SAXException ex) {
            throw new IOException("Malformed XML: " + ex.getMessage());
        }
        return doc;
    }

    private static void writeXmlResourceToFile(final File sunResourcesXml, final Document doc) throws IOException {
        FileObject parentFolder = FileUtil.createFolder((File)sunResourcesXml.getParentFile());
        FileSystem fs = parentFolder.getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileLock lock = null;
                OutputStream os = null;
                try {
                    FileObject sunResourcesFO = FileUtil.createData((File)sunResourcesXml);
                    lock = sunResourcesFO.lock();
                    os = sunResourcesFO.getOutputStream(lock);
                    XMLUtil.write((Document)doc, (OutputStream)os, (String)doc.getXmlEncoding());
                }
                finally {
                    if (os != null) {
                        os.close();
                    }
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
            }
        });
    }

    private static class DDResolver
    implements EntityResolver {
        static DDResolver resolver;

        private DDResolver() {
        }

        static synchronized DDResolver getInstance() {
            if (resolver == null) {
                resolver = new DDResolver();
            }
            return resolver;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            String resource = null;
            if (systemId != null && systemId.endsWith("sun-resources_1_3.dtd")) {
                resource = "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-resources_1_3.dtd";
            }
            if (systemId != null && systemId.endsWith("glassfish-resources_1_5.dtd")) {
                resource = "/org/netbeans/modules/j2ee/sun/dd/impl/resources/glassfish-resources_1_5.dtd";
            }
            if (resource == null) {
                return null;
            }
            URL url = RootInterface.class.getResource(resource);
            return new InputSource(url.toString());
        }
    }

    private static class ProxyNodeReader
    extends TreeParser.NodeReader {
        private final TreeParser.NodeReader[] readers;

        public ProxyNodeReader(TreeParser.NodeReader ... readers) {
            this.readers = readers;
        }

        public void endNode(String qname) throws SAXException {
            for (TreeParser.NodeReader r : this.readers) {
                r.endNode(qname);
            }
        }

        public void readCData(String qname, char[] ch, int start, int length) throws SAXException {
            for (TreeParser.NodeReader r : this.readers) {
                r.readCData(qname, ch, start, length);
            }
        }

        public void readChildren(String qname, Attributes attributes) throws SAXException {
            for (TreeParser.NodeReader r : this.readers) {
                r.readChildren(qname, attributes);
            }
        }

        public void readAttributes(String qname, Attributes attributes) throws SAXException {
            for (TreeParser.NodeReader r : this.readers) {
                r.readAttributes(qname, attributes);
            }
        }
    }

    private static class JndiNamespaceFinder
    extends TreeParser.NodeReader {
        private final Set<String> namespaces = new HashSet<String>();

        private JndiNamespaceFinder() {
        }

        public void readAttributes(String qname, Attributes attributes) throws SAXException {
            String ns;
            String jndiName = attributes.getValue(Hk2DatasourceManager.ATTR_JNDINAME);
            if (jndiName == null) {
                jndiName = attributes.getValue(Hk2DatasourceManager.ATTR_POOL_NAME);
            }
            if (jndiName != null && (ns = JndiNamespacesDefinition.getNamespace((String)jndiName)) != null) {
                this.namespaces.add(ns);
            }
        }

        public Set<String> getNamespaces() {
            return this.namespaces;
        }
    }

    private static class CPool {
        private final String poolName;
        private final String url;
        private final String hostname;
        private final String port;
        private final String databaseName;
        private final String username;
        private final String password;
        private final String sid;

        public CPool(String poolName, String url, String hostName, String port, String databaseName, String username, String password, String sid) {
            this.poolName = poolName;
            this.url = url;
            this.hostname = hostName;
            this.port = port;
            this.databaseName = databaseName;
            this.username = username;
            this.password = password;
            this.sid = sid;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public String getUrl() {
            return this.url;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getPassword() {
            return this.password;
        }

        public String getPort() {
            return this.port;
        }

        public String getSid() {
            return this.sid;
        }

        public String getUsername() {
            return this.username;
        }
    }

    private static class ConnectionPoolFinder
    extends TreeParser.NodeReader {
        private Map<String, String> properties = null;
        private Map<String, CPool> pools = new HashMap<String, CPool>();

        private ConnectionPoolFinder() {
        }

        public void readAttributes(String qname, Attributes attributes) throws SAXException {
            this.properties = new HashMap<String, String>();
            String poolName = attributes.getValue(Hk2DatasourceManager.ATTR_POOL_NAME);
            if (poolName != null && poolName.length() > 0) {
                if (!this.pools.containsKey(poolName)) {
                    this.properties.put(Hk2DatasourceManager.ATTR_POOL_NAME, poolName);
                } else {
                    Logger.getLogger("payara-jakartaee").log(Level.WARNING, "Duplicate pool-names defined for JDBC Connection Pools.");
                }
            }
        }

        public void readChildren(String qname, Attributes attributes) throws SAXException {
            String key;
            if (null != attributes && null != this.properties && (key = attributes.getValue(Hk2DatasourceManager.ATTR_POOL_NAME)) != null && key.length() > 0) {
                this.properties.put(key.toLowerCase(Locale.ENGLISH), attributes.getValue("value"));
            }
        }

        public void endNode(String qname) throws SAXException {
            String poolName = this.properties.get(Hk2DatasourceManager.ATTR_POOL_NAME);
            CPool pool = new CPool(poolName, this.properties.get("url"), this.properties.get("servername"), this.properties.get("portnumber"), this.properties.get("databasename"), this.properties.get("user"), this.properties.get("password"), this.properties.get("connectionattributes"));
            this.pools.put(poolName, pool);
        }

        public List<String> getPoolNames() {
            return new ArrayList<String>(this.pools.keySet());
        }

        public Map<String, CPool> getPoolData() {
            return Collections.unmodifiableMap(this.pools);
        }
    }

    private static class DuplicateJdbcResourceFinder
    extends TreeParser.NodeReader {
        private final String targetJndiName;
        private boolean duplicate;
        private String poolName;

        public DuplicateJdbcResourceFinder(String jndiName) {
            this.targetJndiName = jndiName;
            this.duplicate = false;
            this.poolName = null;
        }

        public void readAttributes(String qname, Attributes attributes) throws SAXException {
            String jndiName = attributes.getValue(Hk2DatasourceManager.ATTR_JNDINAME);
            if (this.targetJndiName.equals(jndiName)) {
                if (this.duplicate) {
                    Logger.getLogger("payara-jakartaee").log(Level.WARNING, "Duplicate jndi-names defined for JDBC resources.");
                }
                this.duplicate = true;
                this.poolName = attributes.getValue(Hk2DatasourceManager.ATTR_POOLNAME);
            }
        }

        public boolean isDuplicate() {
            return this.duplicate;
        }

        public String getPoolName() {
            return this.poolName;
        }
    }

    private static class UserResolver
    implements ApplicationScopedResourcesUtils.JndiNameResolver {
        private final J2eeModule module;
        private ApplicationScopedResourcesUtils.ResourceFileDescription fileDesc;

        public UserResolver(J2eeModule module, ApplicationScopedResourcesUtils.ResourceFileDescription fileDesc) {
            this.module = module;
            this.fileDesc = fileDesc;
        }

        @Override
        public synchronized String resolveJndiName(String jndiName) {
            this.fileDesc = ApplicationScopedResourcesUtils.checkNamespaces(this.module, this.fileDesc, JndiNamespacesDefinition.getNamespace((String)jndiName));
            String jndi = ApplicationScopedResourcesUtils.getJndiName(jndiName, this.fileDesc);
            return jndi;
        }
    }

    private static class ConnectionPoolReader
    extends TreeParser.NodeReader {
        private Map<String, ConnectionPool> resourceMap;
        private ConnectionPool currentPool;

        public ConnectionPoolReader(Map<String, ConnectionPool> resourceMap) {
            this.resourceMap = resourceMap;
        }

        public void readAttributes(String qname, Attributes attributes) throws SAXException {
            String poolName = attributes.getValue(Hk2DatasourceManager.ATTR_POOL_NAME);
            if (poolName != null && poolName.length() > 0) {
                this.currentPool = new ConnectionPool(poolName);
                this.currentPool.setProperty("dsClassName", attributes.getValue(Hk2DatasourceManager.ATTR_DATASOURCE_CLASSNAME));
                this.currentPool.setProperty("resType", attributes.getValue(Hk2DatasourceManager.ATTR_RES_TYPE));
                this.resourceMap.put(poolName, this.currentPool);
            } else {
                this.currentPool = null;
            }
        }

        public void readChildren(String qname, Attributes attributes) throws SAXException {
            String key;
            if (this.currentPool != null && (key = attributes.getValue(Hk2DatasourceManager.ATTR_POOL_NAME)) != null && key.length() > 0) {
                this.currentPool.setProperty(key, attributes.getValue("value"));
            }
        }
    }

    private static class ConnectionPool {
        private final Map<String, String> properties = new HashMap<String, String>();

        public ConnectionPool(String poolName) {
        }

        public void setProperty(String key, String value) {
            this.properties.put(key, value);
        }

        public String getProperty(String key) {
            return this.properties.get(key);
        }

        public void normalize() {
            DbUtil.normalizePoolMap(this.properties);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Hk2DatasourceManager$ConnectionPool[");
            for (Map.Entry<String, String> e : this.properties.entrySet()) {
                sb.append(e.getKey());
                sb.append("=");
                sb.append(e.getValue());
                sb.append("--%%--");
            }
            return sb.append("]").toString();
        }
    }

    private static class JdbcReader
    extends TreeParser.NodeReader {
        private final List<JdbcResource> resources;

        public JdbcReader(List<JdbcResource> resources) {
            this.resources = resources;
        }

        public void readAttributes(String qname, Attributes attributes) throws SAXException {
            String type = attributes.getValue("object-type");
            String jndiName = attributes.getValue(Hk2DatasourceManager.ATTR_JNDINAME);
            String poolName = attributes.getValue(Hk2DatasourceManager.ATTR_POOLNAME);
            if (jndiName != null && jndiName.length() > 0 && poolName != null && poolName.length() > 0) {
                this.resources.add(new JdbcResource(jndiName, poolName));
            }
        }
    }

    private static class JdbcResource {
        private final String jndiName;
        private final String poolName;

        public JdbcResource(String jndiName) {
            this(jndiName, "");
        }

        public JdbcResource(String jndiName, String poolName) {
            this.jndiName = jndiName;
            this.poolName = poolName;
        }

        public String getJndiName() {
            return this.jndiName;
        }

        public String getPoolName() {
            return this.poolName;
        }
    }
}

