/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.util;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.regex.charset.Constants;
import com.oracle.truffle.regex.util.CompilationFinalBitSet;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DebugUtil {
    public static final TruffleLogger LOG_SWITCH_TO_EAGER = TruffleLogger.getLogger((String)"regex", (String)"SwitchToEager");
    public static final TruffleLogger LOG_TOTAL_COMPILATION_TIME = TruffleLogger.getLogger((String)"regex", (String)"TotalCompilationTime");
    public static final TruffleLogger LOG_PHASES = TruffleLogger.getLogger((String)"regex", (String)"Phases");
    public static final TruffleLogger LOG_BAILOUT_MESSAGES = TruffleLogger.getLogger((String)"regex", (String)"BailoutMessages");
    public static final TruffleLogger LOG_AUTOMATON_SIZES = TruffleLogger.getLogger((String)"regex", (String)"AutomatonSizes");
    public static final TruffleLogger LOG_COMPILER_FALLBACK = TruffleLogger.getLogger((String)"regex", (String)"CompilerFallback");
    public static final TruffleLogger LOG_INTERNAL_ERRORS = TruffleLogger.getLogger((String)"regex", (String)"InternalErrors");
    public static final TruffleLogger LOG_TREGEX_COMPILATIONS = TruffleLogger.getLogger((String)"regex", (String)"TRegexCompilations");
    private static final CompilationFinalBitSet validSpecialCharsForFileNames = CompilationFinalBitSet.valueOf(94, 36, 46, 42, 43, 45, 63, 40, 41, 91, 93, 123, 125, 124);
    private static final Pattern specialChars = Pattern.compile("[\"\\\\\u0000-\u001f\u007f-\u009f]");

    @CompilerDirectives.TruffleBoundary
    public static String charToString(int c) {
        if (Constants.WORD_CHARS.contains(c)) {
            return String.valueOf((char)c);
        }
        if (c <= 255) {
            return String.format("\\x%02x", c);
        }
        if (c <= 65535) {
            return String.format("\\u%04x", c);
        }
        return String.format("\\u{%06x}", c);
    }

    @CompilerDirectives.TruffleBoundary
    public static String escapeString(String s) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            ret.append(DebugUtil.charToString(s.charAt(i)));
        }
        return ret.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static StringBuilder appendNodeId(StringBuilder sb, int id) {
        return sb.append(DebugUtil.nodeID(id));
    }

    @CompilerDirectives.TruffleBoundary
    public static String nodeID(int id) {
        return String.format("%04x", id);
    }

    @CompilerDirectives.TruffleBoundary
    public static String jsStringEscape(String str) {
        StringBuffer escapedString = new StringBuffer();
        Matcher m = specialChars.matcher(str);
        while (m.find()) {
            String replacement;
            char c = str.charAt(m.start());
            if (c == '\"') {
                replacement = "\\\\\"";
            } else if (c == '\\') {
                replacement = "\\\\\\\\";
            } else {
                assert (Character.isISOControl(c));
                replacement = String.format("\\\\u%04x", c);
            }
            m.appendReplacement(escapedString, replacement);
        }
        m.appendTail(escapedString);
        return escapedString.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static String randomJsStringFromRanges(char[] ranges, int length) {
        Random random = new Random(System.currentTimeMillis());
        StringBuilder stringBuilder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char hi;
            int rangeIndex = random.nextInt(ranges.length / 2);
            char lo = ranges[rangeIndex * 2];
            char randChar = (char)(lo + random.nextInt((hi = ranges[rangeIndex * 2 + 1]) + '\u0001' - lo));
            if (randChar == '\"') {
                stringBuilder.append("\\\\\"");
                continue;
            }
            if (randChar == '\\') {
                stringBuilder.append("\\\\\\\\");
                continue;
            }
            if (randChar > '\u007f' || Character.isISOControl(randChar)) {
                stringBuilder.append(String.format("\\u%04x", randChar));
                continue;
            }
            stringBuilder.append(randChar);
        }
        return stringBuilder.toString();
    }

    public static boolean isValidCharForFileName(int c) {
        return Character.isLetterOrDigit(c) || validSpecialCharsForFileNames.get(c);
    }

    public static class Timer {
        private long startTime = 0L;

        public void start() {
            this.startTime = System.nanoTime();
        }

        public long getElapsed() {
            return System.nanoTime() - this.startTime;
        }

        public String elapsedToString() {
            return Timer.elapsedToString(this.getElapsed());
        }

        public static String elapsedToString(long elapsed) {
            return String.format("%fms", (double)elapsed / 1000000.0);
        }
    }
}

