/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer.type;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.web.beans.analysis.analyzer.ClassModelAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.ModelAnalyzer;
import org.netbeans.modules.web.beans.api.model.CdiException;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.openide.util.NbBundle;

public class SessionBeanAnalyzer
implements ClassModelAnalyzer.ClassAnalyzer {
    @Override
    public void analyze(TypeElement element, TypeElement parent, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        boolean isSingleton = AnnotationUtil.hasAnnotation(element, "javax.ejb.Singleton", (CompilationInfo)model.getCompilationController());
        boolean isStateless = AnnotationUtil.hasAnnotation(element, "javax.ejb.Stateless", (CompilationInfo)model.getCompilationController());
        if (cancel.get()) {
            return;
        }
        try {
            String scope = model.getScope(element);
            if (isSingleton) {
                if ("javax.enterprise.context.ApplicationScoped".equals(scope) || "javax.enterprise.context.Dependent".equals(scope)) {
                    return;
                }
                result.requireCdiEnabled(element, model);
                result.addError((Element)element, model, NbBundle.getMessage(SessionBeanAnalyzer.class, (String)"ERR_InvalidSingletonBeanScope"));
            } else if (isStateless && !"javax.enterprise.context.Dependent".equals(scope)) {
                result.addError((Element)element, model, NbBundle.getMessage(SessionBeanAnalyzer.class, (String)"ERR_InvalidStatelessBeanScope"));
            }
        }
        catch (CdiException e) {
            result.requireCdiEnabled(element, model);
            this.informCdiException(e, element, model, result);
        }
    }

    private void informCdiException(CdiException exception, Element element, WebBeansModel model, ModelAnalyzer.Result result) {
        result.addError(element, model, exception.getMessage());
    }
}

