/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.ResizableMouseInputAdapter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;

public class Resizable {
    public static final int NONE = 0;
    public static final int UPPER_LEFT = 1;
    public static final int UPPER = 2;
    public static final int UPPER_RIGHT = 4;
    public static final int RIGHT = 8;
    public static final int LOWER_RIGHT = 16;
    public static final int LOWER = 32;
    public static final int LOWER_LEFT = 64;
    public static final int LEFT = 128;
    public static final int ALL = 255;
    private int _resizableCorners = 255;
    private int _resizeCornerSize = 16;
    public static final String PROPERTY_RESIZABLE_CORNERS = "resizableCorner";
    public static final String PROPERTY_RESIZE_CORNER_SIZE = "resizeCornerSize";
    protected final JComponent _component;
    private Insets _resizeInsets;
    private MouseInputListener _mouseInputAdapter;
    private int _snapGridSize = 1;
    private boolean _topLevel;

    public Resizable(JComponent component) {
        this._component = component;
        this.installListeners();
    }

    public int getResizableCorners() {
        return this._resizableCorners;
    }

    public void setResizableCorners(int resizableCorners) {
        if (this._resizableCorners != resizableCorners) {
            int old = this._resizableCorners;
            this._resizableCorners = resizableCorners;
            this._component.firePropertyChange(PROPERTY_RESIZABLE_CORNERS, old, this._resizableCorners);
        }
    }

    public int getResizeCornerSize() {
        return this._resizeCornerSize;
    }

    public void setResizeCornerSize(int resizeCornerSize) {
        if (this._resizeCornerSize != resizeCornerSize) {
            int old = this._resizeCornerSize;
            this._resizeCornerSize = resizeCornerSize;
            this._component.firePropertyChange(PROPERTY_RESIZE_CORNER_SIZE, old, this._resizeCornerSize);
        }
    }

    protected void installListeners() {
        this._mouseInputAdapter = this.createMouseInputListener();
        this._component.addMouseListener(this._mouseInputAdapter);
        this._component.addMouseMotionListener(this._mouseInputAdapter);
    }

    public void uninstallListeners() {
        this._component.removeMouseListener(this._mouseInputAdapter);
        this._component.removeMouseMotionListener(this._mouseInputAdapter);
        this._mouseInputAdapter = null;
    }

    protected MouseInputListener createMouseInputListener() {
        return new ResizableMouseInputAdapter(this);
    }

    public MouseInputListener getMouseInputAdapter() {
        return this._mouseInputAdapter;
    }

    public void beginResizing(int resizeCorner) {
    }

    public void resizing(int resizeCorner, int newX, int newY, int newW, int newH) {
        Dimension minimumSize = this._component.getMinimumSize();
        Dimension maximumSize = this._component.getMaximumSize();
        if (newW < minimumSize.width) {
            newW = minimumSize.width;
        }
        if (newH < minimumSize.height) {
            newW = minimumSize.height;
        }
        if (newW > maximumSize.width) {
            newW = maximumSize.width;
        }
        if (newH > maximumSize.height) {
            newH = maximumSize.height;
        }
        this._component.setPreferredSize(new Dimension(newW, newH));
        this._component.getParent().doLayout();
    }

    public void endResizing(int resizeCorner) {
    }

    public boolean isTopLevel() {
        return this._topLevel;
    }

    public void setTopLevel(boolean topLevel) {
        this._topLevel = topLevel;
    }

    public JComponent getComponent() {
        return this._component;
    }

    public Insets getResizeInsets() {
        if (this._resizeInsets != null) {
            return this._resizeInsets;
        }
        return this.getComponent().getInsets();
    }

    public void setResizeInsets(Insets resizeInsets) {
        this._resizeInsets = resizeInsets;
    }

    public int getSnapGridSize() {
        return this._snapGridSize;
    }

    public void setSnapGridSize(int snapGridSize) {
        this._snapGridSize = snapGridSize;
    }

    public static class ResizeCorner
    extends JComponent {
        static final int SIZE = 16;
        private int _corner = 16;

        public ResizeCorner() {
        }

        public ResizeCorner(int corner) {
            this._corner = corner;
        }

        public int getCorner() {
            return this._corner;
        }

        public void setCorner(int corner) {
            this._corner = corner;
        }

        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int size = Math.min(this.getWidth(), this.getHeight());
            int count = Math.min(size / 4, 4);
            Color old = g.getColor();
            int corner = this.getCorner();
            boolean ltr = this.getComponentOrientation().isLeftToRight();
            switch (corner) {
                case 16: {
                    int i;
                    g.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
                    int delta = 0;
                    for (i = 0; i < count; ++i) {
                        delta += 4;
                        if (ltr) {
                            g.drawLine(size, size - delta, size - delta, size);
                            continue;
                        }
                        g.drawLine(0, delta, size - delta, size);
                    }
                    g.setColor(UIDefaultsLookup.getColor("controlShadow"));
                    delta = 0;
                    for (i = 0; i < count; ++i) {
                        delta += 4;
                        if (ltr) {
                            g.drawLine(size, size - delta + 1, size - delta + 1, size);
                            g.drawLine(size, size - delta + 2, size - delta + 2, size);
                            continue;
                        }
                        g.drawLine(0, delta + 1, size - delta - 1, size);
                        g.drawLine(0, delta + 2, size - delta - 2, size);
                    }
                    break;
                }
                case 4: {
                    int i;
                    g.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
                    int delta = 0;
                    for (i = 0; i < count; ++i) {
                        delta += 4;
                        if (ltr) {
                            g.drawLine(size - delta, 0, size, delta);
                            continue;
                        }
                        g.drawLine(delta, 0, size, size - delta);
                    }
                    g.setColor(UIDefaultsLookup.getColor("controlShadow"));
                    delta = 0;
                    for (i = 0; i < count; ++i) {
                        delta += 4;
                        if (ltr) {
                            g.drawLine(size - delta + 1, 0, size, delta - 1);
                            g.drawLine(size - delta + 2, 0, size, delta - 2);
                            continue;
                        }
                        g.drawLine(delta + 1, 0, size, size - delta - 1);
                        g.drawLine(delta + 2, 0, size, size - delta - 2);
                    }
                    break;
                }
            }
            g.setColor(old);
        }
    }
}

