/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.loader;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.loader.AbstractSerialStateHolder;
import org.apache.ibatis.executor.loader.ResultLoaderMap;
import org.apache.ibatis.reflection.ExceptionUtil;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.property.PropertyCopier;
import org.apache.ibatis.reflection.property.PropertyNamer;

public abstract class AbstractEnhancedDeserializationProxy {
    protected static final String FINALIZE_METHOD = "finalize";
    protected static final String WRITE_REPLACE_METHOD = "writeReplace";
    private final Class<?> type;
    private final Map<String, ResultLoaderMap.LoadPair> unloadedProperties;
    private final ObjectFactory objectFactory;
    private final List<Class<?>> constructorArgTypes;
    private final List<Object> constructorArgs;
    private final ReentrantLock lock = new ReentrantLock();
    private boolean reloadingProperty;

    protected AbstractEnhancedDeserializationProxy(Class<?> type, Map<String, ResultLoaderMap.LoadPair> unloadedProperties, ObjectFactory objectFactory, List<Class<?>> constructorArgTypes, List<Object> constructorArgs) {
        this.type = type;
        this.unloadedProperties = unloadedProperties;
        this.objectFactory = objectFactory;
        this.constructorArgTypes = constructorArgTypes;
        this.constructorArgs = constructorArgs;
        this.reloadingProperty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object invoke(Object enhanced, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (WRITE_REPLACE_METHOD.equals(methodName)) {
            Object original = this.constructorArgTypes.isEmpty() ? this.objectFactory.create(this.type) : this.objectFactory.create(this.type, this.constructorArgTypes, this.constructorArgs);
            PropertyCopier.copyBeanProperties(this.type, enhanced, original);
            return this.newSerialStateHolder(original, this.unloadedProperties, this.objectFactory, this.constructorArgTypes, this.constructorArgs);
        }
        this.lock.lock();
        try {
            Object property;
            String propertyKey;
            if (!FINALIZE_METHOD.equals(methodName) && PropertyNamer.isProperty(methodName) && !this.reloadingProperty && this.unloadedProperties.containsKey(propertyKey = ((String)(property = PropertyNamer.methodToProperty(methodName))).toUpperCase(Locale.ENGLISH))) {
                ResultLoaderMap.LoadPair loadPair = this.unloadedProperties.remove(propertyKey);
                if (loadPair != null) {
                    try {
                        this.reloadingProperty = true;
                        loadPair.load(enhanced);
                    }
                    finally {
                        this.reloadingProperty = false;
                    }
                } else {
                    throw new ExecutorException("An attempt has been made to read a not loaded lazy property '" + (String)property + "' of a disconnected object");
                }
            }
            property = enhanced;
            this.lock.unlock();
            return property;
        }
        catch (Throwable throwable) {
            try {
                this.lock.unlock();
                throw throwable;
            }
            catch (Throwable t) {
                throw ExceptionUtil.unwrapThrowable(t);
            }
        }
    }

    protected abstract AbstractSerialStateHolder newSerialStateHolder(Object var1, Map<String, ResultLoaderMap.LoadPair> var2, ObjectFactory var3, List<Class<?>> var4, List<Object> var5);
}

