/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.hotspot;

import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import io.prometheus.client.Predicate;
import io.prometheus.client.SampleNameFilter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class BufferPoolsExports
extends Collector {
    private static final String JVM_BUFFER_POOL_USED_BYTES = "jvm_buffer_pool_used_bytes";
    private static final String JVM_BUFFER_POOL_CAPACITY_BYTES = "jvm_buffer_pool_capacity_bytes";
    private static final String JVM_BUFFER_POOL_USED_BUFFERS = "jvm_buffer_pool_used_buffers";
    private static final Logger LOGGER = Logger.getLogger(BufferPoolsExports.class.getName());
    private final List<Object> bufferPoolMXBeans = new ArrayList<Object>();
    private Method getName;
    private Method getMemoryUsed;
    private Method getTotalCapacity;
    private Method getCount;

    public BufferPoolsExports() {
        try {
            Class<?> bufferPoolMXBeanClass = Class.forName("java.lang.management.BufferPoolMXBean");
            this.bufferPoolMXBeans.addAll(BufferPoolsExports.accessBufferPoolMXBeans(bufferPoolMXBeanClass));
            this.getName = bufferPoolMXBeanClass.getMethod("getName", new Class[0]);
            this.getMemoryUsed = bufferPoolMXBeanClass.getMethod("getMemoryUsed", new Class[0]);
            this.getTotalCapacity = bufferPoolMXBeanClass.getMethod("getTotalCapacity", new Class[0]);
            this.getCount = bufferPoolMXBeanClass.getMethod("getCount", new Class[0]);
        }
        catch (ClassNotFoundException e) {
            LOGGER.fine("BufferPoolMXBean not available, no metrics for buffer pools will be exported");
        }
        catch (NoSuchMethodException e) {
            LOGGER.fine("Can not get necessary accessor from BufferPoolMXBean: " + e.getMessage());
        }
    }

    private static List<Object> accessBufferPoolMXBeans(Class<?> bufferPoolMXBeanClass) {
        try {
            Method getPlatformMXBeansMethod = ManagementFactory.class.getMethod("getPlatformMXBeans", Class.class);
            Object listOfBufferPoolMXBeanInstances = getPlatformMXBeansMethod.invoke(null, bufferPoolMXBeanClass);
            return (List)listOfBufferPoolMXBeanInstances;
        }
        catch (NoSuchMethodException e) {
            LOGGER.fine("ManagementFactory.getPlatformMXBeans not available, no metrics for buffer pools will be exported");
            return Collections.emptyList();
        }
        catch (IllegalAccessException e) {
            LOGGER.fine("ManagementFactory.getPlatformMXBeans not accessible, no metrics for buffer pools will be exported");
            return Collections.emptyList();
        }
        catch (InvocationTargetException e) {
            LOGGER.warning("ManagementFactory.getPlatformMXBeans could not be invoked, no metrics for buffer pools will be exported");
            return Collections.emptyList();
        }
    }

    public List<Collector.MetricFamilySamples> collect() {
        return this.collect(null);
    }

    public List<Collector.MetricFamilySamples> collect(Predicate<String> nameFilter) {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        if (nameFilter == null) {
            nameFilter = SampleNameFilter.ALLOW_ALL;
        }
        GaugeMetricFamily used = null;
        if (nameFilter.test((Object)JVM_BUFFER_POOL_USED_BYTES)) {
            used = new GaugeMetricFamily(JVM_BUFFER_POOL_USED_BYTES, "Used bytes of a given JVM buffer pool.", Collections.singletonList("pool"));
            mfs.add((Collector.MetricFamilySamples)used);
        }
        GaugeMetricFamily capacity = null;
        if (nameFilter.test((Object)JVM_BUFFER_POOL_CAPACITY_BYTES)) {
            capacity = new GaugeMetricFamily(JVM_BUFFER_POOL_CAPACITY_BYTES, "Bytes capacity of a given JVM buffer pool.", Collections.singletonList("pool"));
            mfs.add((Collector.MetricFamilySamples)capacity);
        }
        GaugeMetricFamily buffers = null;
        if (nameFilter.test((Object)JVM_BUFFER_POOL_USED_BUFFERS)) {
            buffers = new GaugeMetricFamily(JVM_BUFFER_POOL_USED_BUFFERS, "Used buffers of a given JVM buffer pool.", Collections.singletonList("pool"));
            mfs.add((Collector.MetricFamilySamples)buffers);
        }
        for (Object pool : this.bufferPoolMXBeans) {
            if (used != null) {
                used.addMetric(Collections.singletonList(this.getName(pool)), (double)this.callLongMethod(this.getMemoryUsed, pool));
            }
            if (capacity != null) {
                capacity.addMetric(Collections.singletonList(this.getName(pool)), (double)this.callLongMethod(this.getTotalCapacity, pool));
            }
            if (buffers == null) continue;
            buffers.addMetric(Collections.singletonList(this.getName(pool)), (double)this.callLongMethod(this.getCount, pool));
        }
        return mfs;
    }

    private long callLongMethod(Method method, Object pool) {
        try {
            return (Long)method.invoke(pool, new Object[0]);
        }
        catch (IllegalAccessException e) {
            LOGGER.fine("Couldn't call " + method.getName() + ": " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            LOGGER.fine("Couldn't call " + method.getName() + ": " + e.getMessage());
        }
        return 0L;
    }

    private String getName(Object pool) {
        try {
            return (String)this.getName.invoke(pool, new Object[0]);
        }
        catch (IllegalAccessException e) {
            LOGGER.fine("Couldn't call getName " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            LOGGER.fine("Couldn't call getName " + e.getMessage());
        }
        return "<unknown>";
    }
}

