/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import com.google.common.xml.XmlEscapers;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;

public final class StringTools {
    private static final Pattern XML_COMMENT_PATTERN = Pattern.compile("<!--.*?-->", 32);
    private static final Pattern XML_PATTERN = Pattern.compile("(?<!<)<[^<>]+>", 32);
    public static final Set<String> UPPERCASE_GREEK_LETTERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("\u0391", "\u0392", "\u0393", "\u0394", "\u0395", "\u0396", "\u0397", "\u0398", "\u0399", "\u039a", "\u039b", "\u039c", "\u039d", "\u039e", "\u039f", "\u03a0", "\u03a1", "\u03a3", "\u03a4", "\u03a5", "\u03a6", "\u03a7", "\u03a8", "\u03a9")));
    public static final Set<String> LOWERCASE_GREEK_LETTERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("\u03b1", "\u03b2", "\u03b3", "\u03b4", "\u03b5", "\u03b6", "\u03b7", "\u03b8", "\u03b9", "\u03ba", "\u03bb", "\u03bc", "\u03bd", "\u03be", "\u03bf", "\u03c0", "\u03c1", "\u03c3", "\u03c4", "\u03c5", "\u03c6", "\u03c7", "\u03c8", "\u03c9")));
    private static final Pattern PUNCTUATION_PATTERN = Pattern.compile("[\\p{IsPunctuation}']", 32);
    private static final Pattern NOT_WORD_CHARACTER = Pattern.compile("[^\\p{L}]", 32);

    private StringTools() {
    }

    public static void assureSet(String s, String varName) {
        Objects.requireNonNull(varName);
        if (StringTools.isEmpty(s.trim())) {
            throw new IllegalArgumentException(varName + " cannot be empty or whitespace only");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStream(InputStream stream, String encoding) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader isr = null;){
            isr = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
            try (BufferedReader br = new BufferedReader(isr);){
                String line;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append('\n');
                }
            }
        }
        return sb.toString();
    }

    public static boolean isAllUppercase(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isLetter(c) || !Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isMixedCase(String str) {
        return !StringTools.isAllUppercase(str) && !StringTools.isCapitalizedWord(str) && StringTools.isNotAllLowercase(str);
    }

    public static boolean isNotAllLowercase(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isLetter(c) || Character.isLowerCase(c)) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isCapitalizedWord(@Nullable String str) {
        if (!StringTools.isEmpty(str) && Character.isUpperCase(str.charAt(0))) {
            for (int i = 1; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (!Character.isLetter(c) || Character.isLowerCase(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean startsWithUppercase(String str) {
        if (StringTools.isEmpty(str)) {
            return false;
        }
        return Character.isUpperCase(str.charAt(0));
    }

    public static boolean startsWithLowercase(String str) {
        if (StringTools.isEmpty(str)) {
            return false;
        }
        return Character.isLowerCase(str.charAt(0));
    }

    @Contract(value="!null -> !null")
    @Nullable
    public static String uppercaseFirstChar(@Nullable String str) {
        return StringTools.changeFirstCharCase(str, true);
    }

    @Contract(value="!null, _ -> !null")
    @Nullable
    public static String uppercaseFirstChar(@Nullable String str, Language language) {
        if (language != null && "nl".equals(language.getShortCode()) && str != null && str.toLowerCase().startsWith("ij")) {
            return "IJ" + str.substring(2);
        }
        return StringTools.changeFirstCharCase(str, true);
    }

    @Contract(value="!null -> !null")
    @Nullable
    public static String lowercaseFirstChar(@Nullable String str) {
        return StringTools.changeFirstCharCase(str, false);
    }

    @Contract(value="!null, -> !null")
    @Nullable
    public static String lowercaseFirstCharIfCapitalized(@Nullable String str) {
        if (!StringTools.isCapitalizedWord(str)) {
            return str;
        }
        return StringTools.changeFirstCharCase(str, false);
    }

    @Contract(value="!null, _ -> !null")
    @Nullable
    private static String changeFirstCharCase(@Nullable String str, boolean toUpperCase) {
        int pos;
        if (StringTools.isEmpty(str)) {
            return str;
        }
        if (str.length() == 1) {
            return toUpperCase ? str.toUpperCase(Locale.ENGLISH) : str.toLowerCase();
        }
        int len = str.length() - 1;
        for (pos = 0; !Character.isLetterOrDigit(str.charAt(pos)) && len > pos; ++pos) {
        }
        char firstChar = str.charAt(pos);
        return str.substring(0, pos) + (toUpperCase ? Character.toUpperCase(firstChar) : Character.toLowerCase(firstChar)) + str.substring(pos + 1);
    }

    public static String readerToString(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        int readBytes = 0;
        char[] chars = new char[4000];
        while (readBytes >= 0 && (readBytes = reader.read(chars, 0, 4000)) > 0) {
            sb.append(new String(chars, 0, readBytes));
        }
        return sb.toString();
    }

    public static String streamToString(InputStream is, String charsetName) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(is, charsetName);){
            String string = StringTools.readerToString(isr);
            return string;
        }
    }

    public static String escapeXML(String s) {
        return StringTools.escapeHTML(s);
    }

    public static String escapeForXmlAttribute(String s) {
        return XmlEscapers.xmlAttributeEscaper().escape(s);
    }

    public static String escapeForXmlContent(String s) {
        return XmlEscapers.xmlContentEscaper().escape(s);
    }

    public static String escapeHTML(String s) {
        StringBuilder sb = new StringBuilder();
        int n = s.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String trimWhitespace(String s) {
        StringBuilder filter = new StringBuilder();
        String str = s.trim();
        for (int i = 0; i < str.length(); ++i) {
            while (str.charAt(i) <= ' ' && i < str.length() && (str.charAt(i + 1) <= ' ' || i > 1 && str.charAt(i - 1) <= ' ')) {
                ++i;
            }
            char c = str.charAt(i);
            if (c == '\n' || c == '\t' || c == '\r') continue;
            filter.append(c);
        }
        return filter.length() == str.length() ? str : filter.toString();
    }

    public static String trimSpecialCharacters(String s) {
        return s.replaceAll("(?U)[^\\p{Space}\\p{Alnum}\\p{Punct}]", "");
    }

    public static String addSpace(String word, Language language) {
        String space = " ";
        if (word.length() == 1) {
            char c = word.charAt(0);
            if ("fr".equals(language.getShortCode())) {
                if (c == '.' || c == ',') {
                    space = "";
                }
            } else if (c == '.' || c == ',' || c == ';' || c == ':' || c == '?' || c == '!') {
                space = "";
            }
        }
        return space;
    }

    public static boolean isWhitespace(String str) {
        if ("\u0002".equals(str) || "\u0001".equals(str)) {
            return false;
        }
        if ("\ufeff".equals(str)) {
            return true;
        }
        String trimStr = str.trim();
        if (StringTools.isEmpty(trimStr)) {
            return true;
        }
        if (trimStr.length() == 1) {
            if ("\u200b".equals(str) || "\u00a0".equals(str) || "\u202f".equals(str)) {
                return true;
            }
            return Character.isWhitespace(trimStr.charAt(0));
        }
        return false;
    }

    public static boolean isNonBreakingWhitespace(String str) {
        return "\u00a0".equals(str);
    }

    public static boolean isPositiveNumber(char ch) {
        return ch >= '1' && ch <= '9';
    }

    public static boolean isEmpty(@Nullable String str) {
        return str == null || str.length() == 0;
    }

    public static String filterXML(String str) {
        String s = str;
        if (s.contains("<")) {
            s = XML_COMMENT_PATTERN.matcher(s).replaceAll(" ");
            s = XML_PATTERN.matcher(s).replaceAll("");
        }
        return s;
    }

    public static boolean hasDiacritics(String str) {
        return !str.equals(StringTools.removeDiacritics(str));
    }

    public static String removeDiacritics(String str) {
        String s = Normalizer.normalize(str, Normalizer.Form.NFD);
        return s.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
    }

    public static String normalizeNFKC(String str) {
        return Normalizer.normalize(str, Normalizer.Form.NFKC);
    }

    public static String normalizeNFC(String str) {
        return Normalizer.normalize(str, Normalizer.Form.NFC);
    }

    public static String preserveCase(String inputString, String modelString) {
        if (modelString.isEmpty()) {
            return inputString;
        }
        if (StringTools.isAllUppercase(modelString)) {
            return inputString.toUpperCase();
        }
        if (StringTools.isCapitalizedWord(modelString)) {
            return StringTools.uppercaseFirstChar(inputString.toLowerCase());
        }
        return inputString;
    }

    @Nullable
    public static String asString(CharSequence s) {
        if (s == null) {
            return null;
        }
        return s.toString();
    }

    public static boolean isParagraphEnd(String sentence, boolean singleLineBreaksMarksPara) {
        boolean isParaEnd = false;
        if (singleLineBreaksMarksPara) {
            if (sentence.endsWith("\n") || sentence.endsWith("\n\r")) {
                isParaEnd = true;
            }
        } else if (sentence.endsWith("\n\n") || sentence.endsWith("\n\r\n\r") || sentence.endsWith("\r\n\r\n")) {
            isParaEnd = true;
        }
        return isParaEnd;
    }

    public static List<String> loadLines(String path) {
        InputStream stream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(path);
        ArrayList<String> l = new ArrayList<String>();
        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                l.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load data from " + path, e);
        }
        return Collections.unmodifiableList(l);
    }

    public static String toId(String input) {
        return input.toUpperCase().replace(' ', '_').replace("'", "_Q_");
    }

    public static boolean isCamelCase(String token) {
        return token.matches("[a-z]+[A-Z][A-Za-z]+");
    }

    public static boolean isPunctuationMark(String input) {
        return PUNCTUATION_PATTERN.matcher(input).matches();
    }

    public static boolean isNotWordCharacter(String input) {
        return NOT_WORD_CHARACTER.matcher(input).matches();
    }

    public static String makeWrong(String s) {
        if (s.contains("a")) {
            return s.replace("a", "\u00e4");
        }
        if (s.contains("e")) {
            return s.replace("e", "\u00eb");
        }
        if (s.contains("i")) {
            return s.replace("i", "\u00ef");
        }
        if (s.contains("o")) {
            return s.replace("o", "\u00f6");
        }
        if (s.contains("u")) {
            return s.replace("u", "\u00f9");
        }
        if (s.contains("\u00e1")) {
            return s.replace("\u00e1", "\u00e4");
        }
        if (s.contains("\u00e9")) {
            return s.replace("\u00e9", "\u00eb");
        }
        if (s.contains("\u00ed")) {
            return s.replace("\u00ed", "\u00ef");
        }
        if (s.contains("\u00f3")) {
            return s.replace("\u00f3", "\u00f6");
        }
        if (s.contains("\u00fa")) {
            return s.replace("\u00fa", "\u00f9");
        }
        if (s.contains("\u00e0")) {
            return s.replace("\u00e0", "\u00e4");
        }
        if (s.contains("\u00e8")) {
            return s.replace("\u00e8", "\u00eb");
        }
        if (s.contains("\u00ec")) {
            return s.replace("\u00ec", "i");
        }
        if (s.contains("\u00f2")) {
            return s.replace("\u00f2", "\u00f6");
        }
        if (s.contains("\u00ef")) {
            return s.replace("\u00ef", "\u00ec");
        }
        if (s.contains("\u00fc")) {
            return s.replace("\u00fc", "\u00f9");
        }
        return s + "-";
    }

    public static enum ApiPrintMode {
        NORMAL_API,
        START_API,
        END_API,
        CONTINUE_API;

    }
}

