/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.hunspell;

import com.google.common.io.Resources;
import com.vdurmont.emoji.EmojiParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.language.identifier.LanguageIdentifier;
import org.languagetool.language.identifier.LanguageIdentifierService;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.spelling.RuleWithLanguage;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.hunspell.Hunspell;
import org.languagetool.rules.spelling.hunspell.HunspellDictionary;
import org.languagetool.tools.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HunspellRule
extends SpellingCheckRule {
    public static final String RULE_ID = "HUNSPELL_RULE";
    protected static final String FILE_EXTENSION = ".dic";
    private volatile boolean needsInit = true;
    protected volatile HunspellDictionary hunspell = null;
    private static final Logger logger = LoggerFactory.getLogger(HunspellRule.class);
    private static final ConcurrentLinkedQueue<String> activeChecks = new ConcurrentLinkedQueue();
    private static final String NON_ALPHABETIC = "[^\\p{L}]";
    private static final boolean monitorRules = System.getProperty("monitorActiveRules") != null;
    private final List<String> commonPortugueseWords = Arrays.asList("eu", "ja", "so", "de", "e", "a", "o", "da", "do", "em", "que", "uma", "um", "com", "no", "se", "na", "para", "por", "os", "foi", "como", "dos", "as", "ao", "mais", "sua", "das", "n\u00e3o", "ou", "km", "seu", "pela", "ser", "pelo", "s\u00e3o", "tamb\u00e9m", "anos", "cidade", "entre", "era", "tem", "mas", "habitantes", "nos", "seus", "\u00e1rea", "at\u00e9", "ele", "onde", "foram", "popula\u00e7\u00e3o", "regi\u00e3o", "sobre", "nas", "nome", "parte", "quando", "ano", "aos", "grande", "mesmo", "pode", "primeiro", "segundo", "sendo", "suas", "ainda", "dois", "estado", "est\u00e1", "fam\u00edlia", "j\u00e1", "muito", "outros", "americano", "depois", "durante", "maior", "primeira", "forma", "apenas", "banda", "densidade", "dia", "ent\u00e3o", "munic\u00edpio", "norte", "tempo", "ap\u00f3s", "duas", "num", "pelos", "qual", "s\u00e9culo", "ter", "todos", "tr\u00eas", "vez", "\u00e1gua", "acordo", "cobertos", "comuna", "contra", "ela", "grupo", "principal", "quais", "sem", "tendo", "\u00e0s", "\u00e1lbum", "alguns", "assim", "aster\u00f3ide", "bem", "brasileiro", "cerca", "desde", "este", "localizada", "mundo", "outras", "per\u00edodo", "seguinte", "sido", "vida", "atrav\u00e9s", "cada", "conhecido", "final", "hist\u00f3ria", "partir", "pa\u00eds", "pessoas", "sistema", "terra", "teve", "tinha", "\u00e9poca", "administrativa", "censo", "departamento", "dias", "esta", "filme", "francesa", "m\u00fasica", "prov\u00edncia", "s\u00e9rie", "vezes", "al\u00e9m", "antes", "eles", "eram", "esp\u00e9cie", "governo", "podem", "v\u00e1rios", "censos", "distrito", "est\u00e3o", "exemplo", "hoje", "in\u00edcio", "jogo", "lhe", "lugar", "muitos", "m\u00e9dia", "novo", "numa", "n\u00famero", "pois", "possui", "sob", "s\u00f3", "todo", "tornou", "trabalho", "algumas", "devido", "estava", "fez", "filho", "fim", "grandes", "h\u00e1", "isso", "lado", "local", "morte", "orbital", "outro", "passou", "pa\u00edses", "quatro", "representa", "seja", "sempre", "sul", "v\u00e1rias", "capital", "chamado", "come\u00e7ou", " enquanto", "fazer", "lan\u00e7ado", "meio", "nova", "n\u00edvel", "pelas", "poder", "presidente", "redor", "rio", "tarde", "todas", "carreira", "casa", "d\u00e9cada", "estimada", "guerra", "havia", "livro", "localidades", "maioria", "muitas", "obra", "origem", "pai", "pouco", "principais", "produ\u00e7\u00e3o", "programa", "qualquer", "raio", "seguintes", "sucesso", "t\u00edtulo", "aproximadamente", "caso", "centro", "conhecida", "constru\u00e7\u00e3o", "desta", "diagrama", "faz", "ilha", "importante", "mar", "melhor", "menos", "mesma", "metros", "mil", "nacional", "populacional", "quase", "rei", "sede", "segunda", "tipo", "toda", "uso", "velocidade", "vizinhan\u00e7a", "volta", "base", "brasileira", "clube", "desenvolvimento", "deste", "diferentes", "diversos", "empresa", "entanto", "futebol", "geral", "junto", "longo", "obras", "outra", "pertencente", "pol\u00edtica", "portugu\u00eas", "principalmente", "processo", "quem", "seria", "t\u00eam", "vers\u00e3o", "TV", "acima", "atual", "bairro", "chamada", "cinco", "conta", "corpo", "dentro", "deve");
    private final List<String> commonGermanWords = Arrays.asList("das", "sein", "mein", "meine", "meinen", "meines", "meiner", "haben", "kein", "keine", "keinen", "keinem", "keines", "keiner", "ein", "eines", "eins", "einen", "einem", "eine", "einer", "rund", "sehr", "mach", "noch", "nein", "ja", "hallo", "hi", "das", "die", "der", "den", "dem", "des", "nacht", "diesen", "dieser", "dies", "dieses", "diesem", "zum", "zur", "beim", "noch", "nichts", "aufs", "aufm", "aufn", "ausn", "ausm", "aus", "f\u00fcrs", "f\u00fcr", "osten", "rein", "raus", "namen", "shippen", "amt", "wir");
    private static final List<String> possibleWrongTokenizedWordParts = Arrays.asList("aren", "can", "hadn", "wasn", "shouldn", "isn", "hasn", "doesn", "don", "mustn", "weren", "wouldn", "didn", "wont", "shan", "re");
    private static final List<String> notMisspelledButCommonEnglishWords = Arrays.asList("i", "he", "a", "her", "one", "the", "of", "south", "north", "east", "trading", "desk", "chapter", "bush", "vote", "may", "june", "out", "tech", "german", "smith", "clean", "coal", "big", "brother", "best", "happy", "man");
    private static final List<String> notMisspelledButValidInEnglishAndGermanWords = Arrays.asList("just", "like", "off", "last", "lack", "support", "update", "reliable", "system", "an");
    private static final String[] WHITESPACE_ARRAY = new String[20];
    protected Pattern nonWordPattern;
    private final UserConfig userConfig;
    private final List<RuleWithLanguage> enSpellRules;

    public static Queue<String> getActiveChecks() {
        return activeChecks;
    }

    public HunspellRule(ResourceBundle messages, Language language, UserConfig userConfig) {
        this(messages, language, userConfig, Collections.emptyList());
    }

    public HunspellRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) {
        this(messages, language, userConfig, altLanguages, null);
    }

    public HunspellRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages, LanguageModel languageModel) {
        super(messages, language, userConfig, altLanguages, languageModel);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.userConfig = userConfig;
        this.enSpellRules = this.getEnglishSpellingRules();
    }

    private List<RuleWithLanguage> getEnglishSpellingRules() {
        ArrayList<Rule> rules;
        Language en;
        ArrayList<RuleWithLanguage> spellingRules = new ArrayList<RuleWithLanguage>();
        try {
            en = Languages.getLanguageForShortCode("en-US");
        }
        catch (IllegalArgumentException e) {
            logger.warn("Could not create en-US language for spell-check fallback, multi-lingual spell checking is not available");
            return spellingRules;
        }
        try {
            rules = new ArrayList<Rule>(en.getRelevantRules(this.messages, this.userConfig, null, Collections.emptyList()));
            rules.addAll(en.getRelevantLanguageModelCapableRules(this.messages, null, null, this.userConfig, null, Collections.emptyList()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Rule rule : rules) {
            if (!rule.isDictionaryBasedSpellingRule()) continue;
            spellingRules.add(new RuleWithLanguage(rule, en));
        }
        return spellingRules;
    }

    @Override
    public String getId() {
        return RULE_ID;
    }

    @Override
    public String getDescription() {
        return this.messages.getString("desc_spelling");
    }

    protected boolean isQuotedCompound(AnalyzedSentence analyzedSentence, int idx, String token) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        this.ensureInitialized();
        if (this.hunspell == null) {
            return this.toRuleMatchArray(ruleMatches);
        }
        long sentLength = Arrays.stream(sentence.getTokensWithoutWhitespace()).filter(k -> !k.isNonWord()).count() - 1L;
        String monitoringText = this.getClass().getName() + ":" + this.getId() + ":" + sentence.getText();
        try {
            if (monitorRules) {
                activeChecks.add(monitoringText);
            }
            String[] tokens = this.tokenizeText(this.getSentenceTextWithoutUrlsAndImmunizedTokens(sentence));
            int len = sentence.getTokens().length > 1 ? sentence.getTokens()[1].getStartPos() : sentence.getTokens()[0].getStartPos();
            boolean otherLangDetected = false;
            int prevStartPos = -1;
            int misspelledButEnglish = 0;
            int notMisspelledButCommonEnglishWordCounter = 0;
            int notMisspelledButValidInEnglishAndGermanWordCounter = 0;
            for (int i = 0; i < tokens.length; ++i) {
                String word = tokens[i];
                int dashCorr = 0;
                if ((this.ignoreWord(Arrays.asList(tokens), i) || this.ignoreWord(word)) && !this.isProhibited(HunspellRule.cutOffDot(word))) {
                    prevStartPos = len;
                    len += word.length() + 1;
                    continue;
                }
                if (notMisspelledButCommonEnglishWords.contains(word.toLowerCase())) {
                    ++notMisspelledButCommonEnglishWordCounter;
                } else if (this.language.getShortCode().equals("de") && notMisspelledButValidInEnglishAndGermanWords.contains(word.toLowerCase())) {
                    ++notMisspelledButValidInEnglishAndGermanWordCounter;
                }
                if (this.isMisspelled(word)) {
                    String cleanWord;
                    if (this.isEnglish(word) || this.isEnglish(word.toLowerCase()) || possibleWrongTokenizedWordParts.contains(word)) {
                        ++misspelledButEnglish;
                    }
                    String string = cleanWord = word.endsWith(".") ? word.substring(0, word.length() - 1) : word;
                    if (word.startsWith("-")) {
                        if (!this.isMisspelled(cleanWord.substring(1)) || cleanWord.matches("-+")) {
                            len += word.length() + 1;
                            continue;
                        }
                        ++dashCorr;
                    }
                    if (i > 0 && prevStartPos != -1) {
                        String prevWord = tokens[i - 1];
                        boolean ignoreSplitting = false;
                        if (this.language.getShortCode().equals("pt") && (this.commonPortugueseWords.contains(prevWord.toLowerCase()) || this.commonPortugueseWords.contains(word.toLowerCase()))) {
                            ignoreSplitting = true;
                        }
                        if (this.language.getShortCode().equals("de") && (this.commonGermanWords.contains(prevWord.toLowerCase()) || this.commonGermanWords.contains(word.toLowerCase()))) {
                            ignoreSplitting = true;
                        }
                        if (!ignoreSplitting && prevWord.length() > 0) {
                            RuleMatch rm;
                            RuleMatch rm2;
                            String sugg1a = prevWord.substring(0, prevWord.length() - 1);
                            String sugg1b = HunspellRule.cutOffDot(prevWord.substring(prevWord.length() - 1) + word);
                            if (!this.isMisspelled(sugg1a) && !this.isMisspelled(sugg1b) && this.acceptSuggestion(sugg1a + " " + sugg1b) && (rm2 = this.createWrongSplitMatch(sentence, ruleMatches, len, cleanWord, sugg1a, sugg1b, prevStartPos)) != null) {
                                ruleMatches.add(rm2);
                            }
                            String sugg2a = prevWord + word.charAt(0);
                            String sugg2b = HunspellRule.cutOffDot(word.substring(1));
                            if (!this.isMisspelled(sugg2a) && !this.isMisspelled(sugg2b) && this.acceptSuggestion(sugg2a + " " + sugg2b) && (rm = this.createWrongSplitMatch(sentence, ruleMatches, len, cleanWord, sugg2a, sugg2b, prevStartPos)) != null) {
                                ruleMatches.add(rm);
                            }
                        }
                    }
                    RuleMatch ruleMatch = new RuleMatch(this, sentence, len + dashCorr, len + cleanWord.length(), this.messages.getString("spelling"), this.messages.getString("desc_spelling_short"));
                    ruleMatch.setType(RuleMatch.Type.UnknownWord);
                    String cleanWord2 = cleanWord.substring(dashCorr);
                    if (this.userConfig == null || this.userConfig.getMaxSpellingSuggestions() == 0 || ruleMatches.size() <= this.userConfig.getMaxSpellingSuggestions()) {
                        ruleMatch.setLazySuggestedReplacements(() -> {
                            try {
                                List<SuggestedReplacement> sugg = this.calcSuggestions(word, cleanWord2);
                                if (this.isFirstItemHighConfidenceSuggestion(word, sugg)) {
                                    sugg.get(0).setConfidence(Float.valueOf(0.99f));
                                }
                                return sugg;
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        });
                    } else {
                        ruleMatch.setSuggestedReplacement(this.messages.getString("too_many_errors"));
                    }
                    ruleMatches.add(ruleMatch);
                    if (!otherLangDetected) {
                        Language language;
                        LanguageIdentifier langIdent;
                        float enRatio = (float)misspelledButEnglish / (float)(sentLength - (long)notMisspelledButCommonEnglishWordCounter);
                        float enRationGermanPlus = (float)misspelledButEnglish / (float)(sentLength - (long)(notMisspelledButCommonEnglishWordCounter + notMisspelledButValidInEnglishAndGermanWordCounter));
                        float otherRatio = (float)ruleMatches.size() / (float)sentLength;
                        if ((double)enRatio >= 1.0 || sentLength >= 3L && ((double)enRatio >= 0.66 || this.language.getShortCode().equals("de") && (double)enRatio >= 0.5 && (double)enRationGermanPlus >= 0.66)) {
                            ruleMatch.setErrorLimitLang("en");
                            otherLangDetected = true;
                        } else if (sentLength >= 3L && ((double)enRationGermanPlus >= 0.5 || (double)otherRatio >= 0.5) && (langIdent = LanguageIdentifierService.INSTANCE.getInitialized()) != null && (language = langIdent.detectLanguage(sentence.getText())) != null && !language.getShortCode().equals(this.language.getShortCode())) {
                            ruleMatch.setErrorLimitLang(language.getShortCode());
                            otherLangDetected = true;
                        }
                    }
                }
                prevStartPos = len + dashCorr;
                len += word.length() + 1;
            }
        }
        finally {
            if (monitorRules) {
                activeChecks.remove(monitoringText);
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    protected boolean acceptSuggestion(String suggestion) {
        return true;
    }

    boolean isFirstItemHighConfidenceSuggestion(String word, List<SuggestedReplacement> sugg) {
        if (sugg.size() > 0 && !word.equals("IPs") && word.equalsIgnoreCase(sugg.get(0).getReplacement()) && word.matches("[A-Z][A-Z]\\p{javaLowerCase}+") && this.language.getShortCode().equals("de")) {
            return !word.endsWith("s") || !StringUtils.isAllUpperCase((CharSequence)sugg.get(0).getReplacement());
        }
        return false;
    }

    private boolean isEnglish(String word) throws IOException {
        for (RuleWithLanguage altRule : this.enSpellRules) {
            AnalyzedToken token = new AnalyzedToken(word, null, null);
            AnalyzedToken sentenceStartToken = new AnalyzedToken("", "SENT_START", null);
            AnalyzedTokenReadings startTokenReadings = new AnalyzedTokenReadings(sentenceStartToken, 0);
            AnalyzedTokenReadings atr = new AnalyzedTokenReadings(token, 0);
            RuleMatch[] matches = altRule.getRule().match(new AnalyzedSentence(new AnalyzedTokenReadings[]{startTokenReadings, atr}));
            if (matches.length == 0) {
                return true;
            }
            if (!word.endsWith(".")) continue;
            return this.isEnglish(word.substring(0, word.length() - 1));
        }
        return false;
    }

    private List<SuggestedReplacement> calcSuggestions(String word, String cleanWord) throws IOException {
        List<SuggestedReplacement> additionalTopSuggestions;
        List<SuggestedReplacement> onlySuggestions = this.getOnlySuggestions(cleanWord);
        if (!onlySuggestions.isEmpty()) {
            return onlySuggestions;
        }
        List<SuggestedReplacement> suggestions = SuggestedReplacement.convert(this.getSuggestions(cleanWord));
        if (word.endsWith(".")) {
            int pos = 1;
            for (String suggestion : this.getSuggestions(word)) {
                if (!suggestions.stream().noneMatch(sr -> suggestion.equals(sr.getReplacement()))) continue;
                suggestions.add(Math.min(pos, suggestions.size()), new SuggestedReplacement(suggestion.substring(0, suggestion.length() - 1)));
                pos += 2;
            }
        }
        if ((additionalTopSuggestions = this.getAdditionalTopSuggestions(suggestions, cleanWord)).isEmpty() && word.endsWith(".")) {
            additionalTopSuggestions = this.getAdditionalTopSuggestions(suggestions, word).stream().map(sugg -> {
                if (sugg.getReplacement().endsWith(".")) {
                    return sugg;
                }
                SuggestedReplacement newSugg = new SuggestedReplacement((SuggestedReplacement)sugg);
                newSugg.setReplacement(sugg.getReplacement() + ".");
                return newSugg;
            }).collect(Collectors.toList());
        }
        Collections.reverse(additionalTopSuggestions);
        for (SuggestedReplacement additionalTopSuggestion : additionalTopSuggestions) {
            if (cleanWord.equals(additionalTopSuggestion.getReplacement())) continue;
            suggestions.add(0, additionalTopSuggestion);
        }
        List<SuggestedReplacement> additionalSuggestions = this.getAdditionalSuggestions(suggestions, cleanWord);
        for (SuggestedReplacement additionalSuggestion : additionalSuggestions) {
            if (cleanWord.equals(additionalSuggestion.getReplacement())) continue;
            suggestions.addAll(additionalSuggestions);
        }
        suggestions = suggestions.stream().filter(k -> this.acceptSuggestion(k.getReplacement())).collect(Collectors.toList());
        suggestions = HunspellRule.filterDupes(this.filterSuggestions(suggestions));
        return suggestions;
    }

    private static String cutOffDot(String s) {
        return s.endsWith(".") ? s.substring(0, s.length() - 1) : s;
    }

    @Override
    public boolean isMisspelled(String word) {
        try {
            if (!Tools.isExternSpeller()) {
                this.ensureInitialized();
            }
            boolean isAlphabetic = true;
            if (word.length() == 1) {
                isAlphabetic = Character.isAlphabetic(word.charAt(0));
            }
            return isAlphabetic && !"--".equals(word) && (this.hunspell != null && !this.hunspell.spell(word) || Tools.isExternSpeller() && Tools.getLinguisticServices().isCorrectSpell(word, this.language)) && !this.ignoreWord(word) || this.isProhibited(HunspellRule.cutOffDot(word));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getSuggestions(String word) throws IOException {
        this.ensureInitialized();
        return this.hunspell.suggest(word);
    }

    protected List<String> sortSuggestionByQuality(String misspelling, List<String> suggestions) {
        return suggestions;
    }

    protected String[] tokenizeText(String sentence) {
        return this.nonWordPattern.split(sentence);
    }

    protected String getSentenceTextWithoutUrlsAndImmunizedTokens(AnalyzedSentence sentence) {
        StringBuilder sb = new StringBuilder();
        AnalyzedTokenReadings[] sentenceTokens = this.getSentenceWithImmunization(sentence).getTokens();
        for (int i = 1; i < sentenceTokens.length; ++i) {
            String token = sentenceTokens[i].getToken();
            if (sentenceTokens[i].isImmunized() || sentenceTokens[i].isIgnoredBySpeller() || HunspellRule.isUrl(token) || HunspellRule.isEMail(token) || this.isQuotedCompound(sentence, i, token)) {
                if (this.isQuotedCompound(sentence, i, token)) {
                    sb.append(' ').append(token.substring(1));
                    continue;
                }
                if (token.length() < 20) {
                    sb.append(WHITESPACE_ARRAY[token.length()]);
                    continue;
                }
                for (int j = 0; j < token.length(); ++j) {
                    sb.append(' ');
                }
                continue;
            }
            if (token.length() > 1 && token.codePointCount(0, token.length()) != token.length()) {
                List emojis = EmojiParser.extractEmojis((String)token);
                for (String emoji : emojis) {
                    token = StringUtils.replace((String)token, (String)emoji, (String)WHITESPACE_ARRAY[emoji.length()]);
                }
                sb.append(token);
                continue;
            }
            sb.append(token);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void ensureInitialized() throws IOException {
        if (this.needsInit) {
            HunspellRule hunspellRule = this;
            synchronized (hunspellRule) {
                if (this.needsInit) {
                    try {
                        this.init();
                    }
                    finally {
                        this.needsInit = false;
                    }
                }
            }
        }
    }

    @Override
    protected synchronized void init() throws IOException {
        super.init();
        String langCountry = this.language.getShortCode();
        if (this.language.getCountries().length > 0) {
            langCountry = langCountry + "_" + this.language.getCountries()[0];
        }
        String shortDicPath = this.getDictFilenameInResources(langCountry);
        String wordChars = "";
        Path affPath = null;
        if (JLanguageTool.getDataBroker().resourceExists(shortDicPath)) {
            String path = HunspellRule.getDictionaryPath(langCountry, shortDicPath);
            if ("".equals(path)) {
                this.hunspell = null;
            } else {
                affPath = Paths.get(path + ".aff", new String[0]);
                this.hunspell = Hunspell.getDictionary(Paths.get(path + FILE_EXTENSION, new String[0]), affPath);
                this.addIgnoreWords();
            }
        } else if (new File(shortDicPath + FILE_EXTENSION).exists()) {
            affPath = Paths.get(shortDicPath + ".aff", new String[0]);
            this.hunspell = Hunspell.getDictionary(Paths.get(shortDicPath + FILE_EXTENSION, new String[0]), affPath);
        }
        if (affPath != null) {
            try (Scanner sc = new Scanner(affPath);){
                while (sc.hasNextLine()) {
                    String line = sc.nextLine();
                    if (!line.startsWith("WORDCHARS ")) continue;
                    String wordCharsFromAff = line.substring("WORDCHARS ".length());
                    wordChars = "(?![" + wordCharsFromAff.replace("-", "\\-") + "])";
                    break;
                }
            }
        }
        this.nonWordPattern = Pattern.compile(wordChars + NON_ALPHABETIC);
    }

    @NotNull
    protected String getDictFilenameInResources(String langCountry) {
        return "/" + this.language.getShortCode() + "/hunspell/" + langCountry + FILE_EXTENSION;
    }

    private void addIgnoreWords() throws IOException {
        URL ignoreUrl = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(this.getIgnoreFileName());
        List ignoreLines = Resources.readLines((URL)ignoreUrl, (Charset)StandardCharsets.UTF_8);
        for (String ignoreLine : ignoreLines) {
            if (ignoreLine.startsWith("#")) continue;
            this.wordsToBeIgnored.add(ignoreLine);
        }
    }

    @Override
    protected boolean isInIgnoredSet(String word) {
        return super.isInIgnoredSet(word) || "LanguageTool".equals(word) || "LanguageTooler".equals(word);
    }

    private static String getDictionaryPath(String dicName, String originalPath) throws IOException {
        String dictionaryPath;
        URL dictURL = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(originalPath);
        if (StringUtils.equalsAny((CharSequence)dictURL.getProtocol(), (CharSequence[])new CharSequence[]{"jar", "vfs", "bundle", "bundleresource"})) {
            File tempDir = new File(System.getProperty("java.io.tmpdir"));
            File tempDicFile = new File(tempDir, dicName + FILE_EXTENSION);
            JLanguageTool.addTemporaryFile(tempDicFile);
            try (InputStream dicStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(originalPath);){
                HunspellRule.fileCopy(dicStream, tempDicFile);
            }
            File tempAffFile = new File(tempDir, dicName + ".aff");
            JLanguageTool.addTemporaryFile(tempAffFile);
            if (originalPath.endsWith(FILE_EXTENSION)) {
                originalPath = originalPath.substring(0, originalPath.length() - FILE_EXTENSION.length()) + ".aff";
            }
            try (InputStream affStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(originalPath);){
                HunspellRule.fileCopy(affStream, tempAffFile);
            }
            dictionaryPath = tempDir.getAbsolutePath() + "/" + dicName;
        } else {
            int suffixLength = FILE_EXTENSION.length();
            try {
                dictionaryPath = new File(dictURL.toURI()).getAbsolutePath();
                dictionaryPath = dictionaryPath.substring(0, dictionaryPath.length() - suffixLength);
            }
            catch (URISyntaxException e) {
                return "";
            }
        }
        return dictionaryPath;
    }

    private static void fileCopy(InputStream in, File targetFile) throws IOException {
        try (FileOutputStream out = new FileOutputStream(targetFile);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
        }
    }

    static {
        for (int i = 0; i < 20; ++i) {
            HunspellRule.WHITESPACE_ARRAY[i] = StringUtils.repeat((char)' ', (int)i);
        }
    }
}

