/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.commandline;

import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.commandline.CommandLineOptions;
import org.languagetool.commandline.UnknownParameterException;
import org.languagetool.commandline.WrongParameterNumberException;

class CommandLineParser {
    CommandLineParser() {
    }

    CommandLineOptions parseOptions(String[] args) {
        if (args.length < 1 || args.length > 12) {
            throw new WrongParameterNumberException();
        }
        CommandLineOptions options = new CommandLineOptions();
        for (int i = 0; i < args.length; ++i) {
            String categories;
            String rules;
            if (args[i].equals("--version")) {
                options.setPrintVersion(true);
                continue;
            }
            if (args[i].equals("--list")) {
                options.setPrintLanguages(true);
                continue;
            }
            if (args[i].equals("-h") || args[i].equals("-help") || args[i].equals("--help") || args[i].equals("--?")) {
                options.setPrintUsage(true);
                continue;
            }
            if (args[i].equals("-adl") || args[i].equals("--autoDetect")) {
                options.setAutoDetect(true);
                continue;
            }
            if (args[i].equals("-v") || args[i].equals("--verbose")) {
                options.setVerbose(true);
                continue;
            }
            if (args[i].equals("--line-by-line")) {
                options.setLineByLine(true);
                continue;
            }
            if (args[i].equals("--enable-temp-off")) {
                options.setEnableTempOff(true);
                continue;
            }
            if (args[i].equals("--level")) {
                String level = args[++i];
                try {
                    options.setLevel(JLanguageTool.Level.valueOf(level));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Unknown level '" + level + "' - currently, only 'PICKY' is supported");
                }
            }
            if (args[i].equals("-t") || args[i].equals("--taggeronly")) {
                options.setTaggerOnly(true);
                if (options.isListUnknown()) {
                    throw new IllegalArgumentException("You cannot list unknown words when tagging only");
                }
                if (!options.isApplySuggestions()) continue;
                throw new IllegalArgumentException("You cannot apply suggestions when tagging only");
            }
            if (args[i].equals("-r") || args[i].equals("--recursive")) {
                options.setRecursive(true);
                continue;
            }
            if (args[i].equals("-b2") || args[i].equals("--bitext")) {
                options.setBitext(true);
                continue;
            }
            if (args[i].equals("-eo") || args[i].equals("--enabledonly")) {
                if (options.getDisabledRules().size() > 0) {
                    throw new IllegalArgumentException("You cannot specify both disabled rules and enabledonly");
                }
                options.setUseEnabledOnly();
                continue;
            }
            if (args[i].equals("-d") || args[i].equals("--disable")) {
                if (options.isUseEnabledOnly()) {
                    throw new IllegalArgumentException("You cannot specify both disabled rules and enabledonly");
                }
                this.checkArguments("-d/--disable", i, args);
                rules = args[++i];
                options.setDisabledRules(Arrays.asList(rules.split(",")));
                continue;
            }
            if (args[i].equals("-e") || args[i].equals("--enable")) {
                this.checkArguments("-e/--enable", i, args);
                rules = args[++i];
                options.setEnabledRules(Arrays.asList(rules.split(",")));
                continue;
            }
            if (args[i].equals("--enablecategories")) {
                this.checkArguments("--enablecategories", i, args);
                categories = args[++i];
                options.setEnabledCategories(Arrays.asList(categories.split(",")));
                continue;
            }
            if (args[i].equals("--disablecategories")) {
                this.checkArguments("--disablecategories", i, args);
                categories = args[++i];
                options.setDisabledCategories(Arrays.asList(categories.split(",")));
                continue;
            }
            if (args[i].equals("-l") || args[i].equals("--language")) {
                this.checkArguments("-l/--language", i, args);
                options.setLanguage(this.getLanguage(args[++i]));
                continue;
            }
            if (args[i].equals("-m") || args[i].equals("--mothertongue")) {
                this.checkArguments("-m/--mothertongue", i, args);
                options.setMotherTongue(this.getLanguage(args[++i]));
                continue;
            }
            if (args[i].equals("--languagemodel")) {
                this.checkArguments("--languagemodel", i, args);
                options.setLanguageModel(new File(args[++i]));
                continue;
            }
            if (args[i].equals("--word2vecmodel")) {
                this.checkArguments("--word2vecmodel", i, args);
                options.setWord2VecModel(new File(args[++i]));
                continue;
            }
            if (args[i].equals("--neuralnetworkmodel")) {
                this.checkArguments("--neuralnetworkmodel", i, args);
                options.setNeuralNetworkModel(new File(args[++i]));
                continue;
            }
            if (args[i].equals("--fasttextmodel")) {
                this.checkArguments("--fasttextmodel", i, args);
                options.setFasttextModel(new File(args[++i]));
                continue;
            }
            if (args[i].equals("--fasttextbinary")) {
                this.checkArguments("--fasttextbinary", i, args);
                options.setFasttextBinary(new File(args[++i]));
                continue;
            }
            if (args[i].equals("--rulefile")) {
                this.checkArguments("--rulefile", i, args);
                options.setRuleFile(args[++i]);
                continue;
            }
            if (args[i].equals("--remoterules")) {
                this.checkArguments("--remoterules", i, args);
                options.setRemoteRulesFile(args[++i]);
                continue;
            }
            if (args[i].equals("--falsefriends")) {
                this.checkArguments("--falsefriends", i, args);
                options.setFalseFriendFile(args[++i]);
                continue;
            }
            if (args[i].equals("--bitextrules")) {
                this.checkArguments("--bitextrules", i, args);
                options.setBitextRuleFile(args[++i]);
                continue;
            }
            if (args[i].equals("-c") || args[i].equals("--encoding")) {
                this.checkArguments("-c/--encoding", i, args);
                options.setEncoding(args[++i]);
                continue;
            }
            if (args[i].equals("-u") || args[i].equals("--list-unknown")) {
                options.setListUnknown(true);
                if (!options.isTaggerOnly()) continue;
                throw new IllegalArgumentException("You cannot list unknown words when tagging only");
            }
            if (args[i].equals("-b")) {
                options.setSingleLineBreakMarksParagraph(true);
                continue;
            }
            if (args[i].equals("--json")) {
                options.setJsonFormat();
                if (options.isApplySuggestions()) {
                    throw new IllegalArgumentException("JSON output format makes no sense for automatic application of suggestions");
                }
                if (options.isLineByLine()) {
                    throw new IllegalArgumentException("JSON output format is not implemented for \"line by line\" analysis");
                }
                if (options.isBitext()) {
                    throw new IllegalArgumentException("JSON output format is not implemented for Bitext");
                }
                if (!options.isListUnknown()) continue;
                throw new IllegalArgumentException("You cannot list unknown words in JSON output format");
            }
            if (args[i].equals("--api")) {
                options.setXmlFormat();
                if (!options.isApplySuggestions()) continue;
                throw new IllegalArgumentException("XML API format makes no sense for automatic application of suggestions");
            }
            if (args[i].equals("-a") || args[i].equals("--apply")) {
                options.setApplySuggestions(true);
                if (options.isTaggerOnly()) {
                    throw new IllegalArgumentException("You cannot apply suggestions when tagging only");
                }
                if (options.isXmlFormat()) {
                    throw new IllegalArgumentException("XML API format makes no sense for automatic application of suggestions");
                }
                if (!options.isJsonFormat()) continue;
                throw new IllegalArgumentException("JSON output format makes no sense for automatic application of suggestions");
            }
            if (args[i].equals("-p") || args[i].equals("--profile")) {
                options.setProfile(true);
                if (options.isXmlFormat()) {
                    throw new IllegalArgumentException("XML API format makes no sense for profiling");
                }
                if (options.isJsonFormat()) {
                    throw new IllegalArgumentException("JSON output format makes no sense for profiling");
                }
                if (options.isApplySuggestions()) {
                    throw new IllegalArgumentException("Applying suggestions makes no sense for profiling");
                }
                if (!options.isTaggerOnly()) continue;
                throw new IllegalArgumentException("Tagging makes no sense for profiling");
            }
            if (args[i].equals("--xmlfilter")) {
                options.setXmlFiltering(true);
                continue;
            }
            if (i == args.length - 1) {
                options.setFilename(args[i]);
                continue;
            }
            throw new UnknownParameterException("Unknown parameter: " + args[i]);
        }
        return options;
    }

    void printUsage() {
        this.printUsage(System.out);
    }

    void printUsage(PrintStream stream) {
        stream.println("Usage: java -jar languagetool-commandline.jar [OPTION]... FILE\n FILE                      plain text file to be checked\n Available options:\n  -r, --recursive          work recursively on directory, not on a single file\n  -c, --encoding ENC       character set of the input text, e.g. utf-8 or latin1\n  -b                       assume that a single line break marks the end of a paragraph\n  -l, --language LANG      the language code of the text, e.g. en for English, en-GB for British English\n  --list                   print all available languages and exit\n  -adl, --autoDetect       auto-detect the language of the input text - note this will not detect\n                           variants like 'English (US)', so you will not get spell checking for\n                           languages with variants\n  -m, --mothertongue LANG  the language code of your first language, used to activate false-friend checking\n  -d, --disable RULES      a comma-separated list of rule ids to be disabled (use no spaces between ids)\n  -e, --enable RULES       a comma-separated list of rule ids to be enabled (use no spaces between ids)\n  -eo, --enabledonly       disable all rules except those enabled explicitly in -e\n  --enablecategories CAT   a comma-separated list of category ids to be enabled (use no spaces between ids)\n  --disablecategories CAT  a comma-separated list of category ids to be disabled (use no spaces between ids)\n  -t, --taggeronly         don't check, but only print text analysis (sentences, part-of-speech tags)\n  -u, --list-unknown       also print a summary of words from the input that LanguageTool doesn't know\n  -b2, --bitext            check bilingual texts with a tab-separated input file,\n                           see http://languagetool.wikidot.com/checking-translations-bilingual-texts\n  --api                    [deprecated] print results as XML - please use --json or the JSON API in server mode instead\n  --json                   print results as JSON (see https://languagetool.org/http-api/#!/default/post_check)\n  -p, --profile            print performance measurements\n  -v, --verbose            print text analysis (sentences, part-of-speech tags) to STDERR\n  --version                print LanguageTool version number and exit\n  -a, --apply              automatically apply suggestions if available, printing result to STDOUT\n                           NOTE: only use with very robust rules, as this will otherwise introduce new errors\n  --rulefile FILE          use an additional grammar file; if the filename contains a known language code,\n                           it is used in addition of standard rules\n  --remoterules FILE       configure rules depending on external services via a JSON file (optional)\n  --falsefriends FILE      use external false friend file to be used along with the built-in rules\n  --bitextrules  FILE      use external bitext XML rule file (useful only in bitext mode)\n  --languagemodel DIR      a directory with e.g. 'en' sub directory (i.e. a language code) that contains\n                           '1grams'...'3grams' sub directories with Lucene indexes with\n                           ngram occurrence counts; activates the confusion rule if supported;\n                           see https://dev.languagetool.org/finding-errors-using-n-gram-data\n  --word2vecmodel DIR      [deprecated] a directory with e.g. 'en' sub directory (i.e. a language code) that contains\n                           final_embeddings.txt and dictionary.txt; activates neural network based rules\n  --neuralnetworkmodel DIR [deprecated] a base directory for various saved neural network models\n  --fasttextmodel FILE     fasttext language detection model (optional), see https://fasttext.cc/docs/en/language-identification.html\n  --fasttextbinary FILE    fasttext executable (optional), see https://fasttext.cc/docs/en/support.html\n  --xmlfilter              [deprecated] remove XML/HTML elements from input before checking\n  --line-by-line           work on file line by line (for development, e.g. inside an IDE)\n  --enable-temp-off        enable all temp_off rules (for testing and development)\n  --level level            enable the given level (currently only 'PICKY')");
    }

    private void checkArguments(String option, int argParsingPos, String[] args) {
        if (argParsingPos + 1 >= args.length) {
            throw new IllegalArgumentException("Missing argument to " + option + " command line option.");
        }
    }

    private Language getLanguage(String userSuppliedLangCode) {
        return Languages.getLanguageForShortCode(userSuppliedLangCode);
    }
}

