/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import io.prometheus.client.Histogram;

public final class RemoteRuleMetrics {
    private static final double[] WAIT_BUCKETS = new double[]{0.05, 0.1, 0.2, 0.3, 0.4, 0.5, 0.75, 1.0, 2.0, 5.0, 7.5, 10.0, 15.0};
    private static final double[] LATENCY_BUCKETS = new double[]{0.025, 0.05, 0.1, 0.25, 0.5, 0.75, 1.0, 2.0, 4.0, 6.0, 8.0, 10.0, 15.0};
    private static final double[] SIZE_BUCKETS = new double[]{25.0, 100.0, 500.0, 1000.0, 2500.0, 5000.0, 10000.0, 20000.0, 40000.0};
    private static final Histogram wait = (Histogram)((Histogram.Builder)Histogram.build((String)"languagetool_remote_rule_wait_seconds", (String)"Time spent waiting on remote rule results/timeouts").labelNames(new String[]{"language"})).buckets(WAIT_BUCKETS).register();
    private static final Histogram requestLatency = (Histogram)((Histogram.Builder)Histogram.build((String)"languagetool_remote_rule_request_latency_seconds", (String)"Request duration summary").labelNames(new String[]{"rule_id", "result"})).buckets(LATENCY_BUCKETS).register();
    private static final Histogram requestThroughput = (Histogram)((Histogram.Builder)Histogram.build((String)"languagetool_remote_rule_request_throughput_characters", (String)"Request size summary").labelNames(new String[]{"rule_id", "result"})).buckets(SIZE_BUCKETS).register();

    private RemoteRuleMetrics() {
        throw new IllegalStateException("RemoteRuleMetrics should only be used via static methods.");
    }

    public static void request(String rule, long startMillis, long characters, RequestResult result) {
        long delta = System.currentTimeMillis() - startMillis;
        ((Histogram.Child)requestLatency.labels(new String[]{rule, result.name().toLowerCase()})).observe((double)delta / 1000.0);
        ((Histogram.Child)requestThroughput.labels(new String[]{rule, result.name().toLowerCase()})).observe((double)characters);
    }

    public static void wait(String langCode, long milliseconds) {
        ((Histogram.Child)wait.labels(new String[]{langCode})).observe((double)milliseconds / 1000.0);
    }

    public static enum RequestResult {
        SUCCESS,
        SKIPPED,
        TIMEOUT,
        INTERRUPTED,
        DOWN,
        ERROR;

    }
}

