/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Language;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternToken;

public abstract class AbstractTokenBasedRule
extends AbstractPatternRule {
    @Nullable
    final String[] inflectedRuleTokens;
    @Nullable
    final String[][] formHints;

    protected AbstractTokenBasedRule(String id, String description, Language language, List<PatternToken> patternTokens, boolean getUnified) {
        super(id, description, language, patternTokens, getUnified);
        HashSet<String> inflectedRuleTokens = new HashSet<String>();
        HashSet formHints = new HashSet();
        for (PatternToken pToken : patternTokens) {
            Set<String> hints;
            if (pToken.isInflected() && !pToken.getNegation() && pToken.hasStringThatMustMatch() && !pToken.isRegularExpression()) {
                inflectedRuleTokens.add(Objects.requireNonNull(pToken.getString()).toLowerCase());
            }
            if ((hints = pToken.calcFormHints()) == null) continue;
            formHints.add(hints.stream().map(String::toLowerCase).collect(Collectors.toSet()));
        }
        this.inflectedRuleTokens = inflectedRuleTokens.isEmpty() ? null : inflectedRuleTokens.toArray(new String[0]);
        this.formHints = formHints.isEmpty() ? (String[][])null : (String[][])formHints.stream().map(set -> set.toArray(new String[0])).sorted(Comparator.comparing(a -> ((String[])a).length).thenComparing(a -> -Arrays.stream(a).mapToInt(String::length).min().orElse(0))).toArray(x$0 -> new String[x$0][]);
    }

    protected boolean canBeIgnoredFor(AnalyzedSentence sentence) {
        if (this.inflectedRuleTokens != null) {
            for (String token : this.inflectedRuleTokens) {
                if (sentence.getLemmaSet().contains(token)) continue;
                return true;
            }
        }
        if (this.formHints != null) {
            Set<String> tokenSet = sentence.getTokenSet();
            for (String[] hints : this.formHints) {
                if (AbstractTokenBasedRule.containsAny(tokenSet, hints)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean containsAny(Set<String> set, String[] elements) {
        for (String hint : elements) {
            if (!set.contains(hint)) continue;
            return true;
        }
        return false;
    }
}

