/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.google.common.cache.Cache;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.exporter.HTTPServer;
import io.prometheus.client.guava.cache.CacheMetricsCollector;
import io.prometheus.client.hotspot.DefaultExports;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;

public class ServerMetricsCollector {
    private static final ServerMetricsCollector collector = new ServerMetricsCollector();
    private static HTTPServer server;
    private final Counter checkCounter = (Counter)((Counter.Builder)Counter.build("languagetool_checks_total", "Total text checks").labelNames("language", "client", "mode")).register();
    private final Counter charactersCounter = (Counter)((Counter.Builder)Counter.build("languagetool_characters_total", "Total processed characters").labelNames("language", "client", "mode")).register();
    private final Counter matchCounter = (Counter)((Counter.Builder)Counter.build("languagetool_check_matches_total", "Total amount of rule matches").labelNames("language", "client", "mode")).register();
    private final Counter computationTimeCounter = (Counter)((Counter.Builder)Counter.build("languagetool_computation_time_seconds_total", "Total computation time, in seconds").labelNames("language", "client", "mode")).register();
    private final Counter ruleMatchCounter = (Counter)((Counter.Builder)Counter.build("languagetool_rule_matches_total", "Total amount of matches of a given rule").labelNames("language", "rule_id")).register();
    private final Counter requestErrorCounter = (Counter)((Counter.Builder)Counter.build("languagetool_request_errors_total", "Various request errors").labelNames("reason")).register();
    private final Counter httpRequestCounter = (Counter)Counter.build("languagetool_http_requests_total", "Received HTTP requests").register();
    private final Counter httpResponseCounter = (Counter)((Counter.Builder)Counter.build("languagetool_http_responses_total", "HTTP responses by code").labelNames("code")).register();
    private final Counter failedHealthcheckCounter = (Counter)Counter.build("languagetool_failed_healthchecks_total", "Failed healthchecks").register();
    private final Gauge hiddenMatchesServerEnabled = (Gauge)Gauge.build("languagetool_hidden_matches_server_enabled", "Configuration of hidden matches server").register();
    private final Gauge hiddenMatchesServerStatus = (Gauge)Gauge.build("languagetool_hidden_matches_server_up", "Status of hidden matches server").register();
    private final CacheMetricsCollector cacheMetrics = (CacheMetricsCollector)new CacheMetricsCollector().register();

    public static void init(int port) throws IOException {
        DefaultExports.initialize();
        server = new HTTPServer(port, true);
    }

    public static void stop() {
        server.stop();
    }

    public static ServerMetricsCollector getInstance() {
        return collector;
    }

    public void monitorCache(String name, Cache cache) {
        this.cacheMetrics.addCache(name, cache);
    }

    public void logHiddenServerConfiguration(boolean enabled) {
        this.hiddenMatchesServerEnabled.set(enabled ? 1.0 : 0.0);
    }

    public void logHiddenServerStatus(boolean up) {
        this.hiddenMatchesServerStatus.set(up ? 1.0 : 0.0);
    }

    public void logCheck(Language language, long milliseconds, int textSize, int matchCount, JLanguageTool.Mode mode, @Nullable String client, Map<String, Integer> ruleMatches) {
        String clientLabel = client != null ? client : "unknown";
        String langLabel = language != null ? language.getShortCode() : "unknown";
        String modeLabel = mode != null ? mode.name() : "unknown";
        ((Counter.Child)this.checkCounter.labels(langLabel, clientLabel, modeLabel)).inc();
        ((Counter.Child)this.matchCounter.labels(langLabel, clientLabel, modeLabel)).inc(matchCount);
        ((Counter.Child)this.charactersCounter.labels(langLabel, clientLabel, modeLabel)).inc(textSize);
        ((Counter.Child)this.computationTimeCounter.labels(langLabel, clientLabel, modeLabel)).inc((double)milliseconds / 1000.0);
        ruleMatches.forEach((ruleId, ruleMatchCount) -> ((Counter.Child)this.ruleMatchCounter.labels(langLabel, (String)ruleId)).inc(ruleMatchCount.intValue()));
    }

    public void logRequestError(RequestErrorType type) {
        ((Counter.Child)this.requestErrorCounter.labels(type.name().toLowerCase())).inc();
    }

    public void logRequest() {
        this.httpRequestCounter.inc();
    }

    public void logResponse(int httpCode) {
        ((Counter.Child)this.httpResponseCounter.labels(String.valueOf(httpCode))).inc();
    }

    public void logFailedHealthcheck() {
        this.failedHealthcheckCounter.inc();
    }

    public static enum RequestErrorType {
        QUEUE_FULL,
        TOO_MANY_ERRORS,
        MAX_CHECK_TIME,
        MAX_TEXT_SIZE,
        INVALID_REQUEST;

    }
}

