/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.Calendar;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TestHackHelper;
import org.languagetool.rules.patterns.RuleFilter;

public abstract class AbstractNewYearDateFilter
extends RuleFilter {
    private static final Pattern DAY_OF_MONTH_PATTERN = Pattern.compile("(\\d+).*");

    protected boolean isJanuary() {
        if (TestHackHelper.isJUnitTest()) {
            return true;
        }
        return this.getCalendar().get(2) == 0;
    }

    protected int getCurrentYear() {
        if (TestHackHelper.isJUnitTest()) {
            return 2014;
        }
        return this.getCalendar().get(1);
    }

    protected abstract int getMonth(String var1);

    protected abstract Calendar getCalendar();

    protected int getDayOfMonth(String localizedDayOfMonth) {
        return 0;
    }

    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> args, AnalyzedTokenReadings[] patternTokens) {
        int yearFromText;
        int monthFromText;
        Calendar dateFromText = this.getDate(args);
        try {
            monthFromText = dateFromText.get(2);
            yearFromText = dateFromText.get(1);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        int currentYear = this.getCurrentYear();
        if (this.isJanuary() && monthFromText != 11 && yearFromText + 1 == currentYear) {
            String message = match.getMessage().replace("{year}", Integer.toString(yearFromText)).replace("{realYear}", Integer.toString(currentYear));
            RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), message, match.getShortMessage());
            ruleMatch.setType(match.getType());
            return ruleMatch;
        }
        return null;
    }

    protected String getRequired(String key, Map<String, String> map) {
        String result = map.get(key);
        if (result == null) {
            throw new IllegalArgumentException("Missing key '" + key + "'");
        }
        return result;
    }

    private Calendar getDate(Map<String, String> args) {
        int year = Integer.parseInt(this.getRequired("year", args));
        int month = this.getMonthFromArguments(args);
        int dayOfMonth = this.getDayOfMonthFromArguments(args);
        Calendar calendar = this.getCalendar();
        calendar.setLenient(false);
        calendar.set(year, month, dayOfMonth, 0, 0, 0);
        return calendar;
    }

    private int getDayOfMonthFromArguments(Map<String, String> args) {
        String dayOfMonthString = this.getRequired("day", args);
        Matcher matcherDayOfMonth = DAY_OF_MONTH_PATTERN.matcher(dayOfMonthString);
        int dayOfMonth = matcherDayOfMonth.matches() ? Integer.parseInt(matcherDayOfMonth.group(1)) : this.getDayOfMonth(dayOfMonthString);
        return dayOfMonth;
    }

    private int getMonthFromArguments(Map<String, String> args) {
        String monthStr = this.getRequired("month", args);
        int month = StringUtils.isNumeric((CharSequence)monthStr) ? Integer.parseInt(monthStr) : this.getMonth(monthStr);
        return month - 1;
    }
}

