/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.databroker.ResourceDataBroker;
import org.languagetool.rules.ConfusionSet;
import org.languagetool.rules.ConfusionSetLoader;
import org.languagetool.rules.ConfusionString;

public class ShortDescriptionProvider {
    private final Map<String, String> wordToDesc;
    private static final LoadingCache<String, Map<String, String>> cache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Map<String, String>>(){

        public Map<String, String> load(@NotNull String langCode) {
            HashMap<String, String> map = new HashMap<String, String>();
            String path = "/" + langCode + "/confusion_sets.txt";
            ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
            if (dataBroker.resourceExists(path)) {
                ShortDescriptionProvider.loadConfusionSet(map, path, dataBroker);
            }
            return map;
        }
    });

    private static void loadConfusionSet(Map<String, String> map, String path, ResourceDataBroker dataBroker) {
        ConfusionSetLoader loader = new ConfusionSetLoader();
        try (InputStream confusionSetStream = dataBroker.getFromResourceDirAsStream(path);){
            Map<String, List<ConfusionSet>> confusionSet = loader.loadConfusionSet(confusionSetStream);
            for (List<ConfusionSet> confSets : confusionSet.values()) {
                for (ConfusionSet confSet : confSets) {
                    Set<ConfusionString> set = confSet.getSet();
                    for (ConfusionString confString : set) {
                        if (confString.getDescription() == null) continue;
                        map.put(confString.getString(), confString.getDescription());
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ShortDescriptionProvider(Language lang) {
        this.wordToDesc = (Map)cache.getUnchecked((Object)lang.getShortCode());
    }

    @Nullable
    public String getShortDescription(String word) {
        return this.wordToDesc.get(word);
    }
}

