/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.languagetool.DetectedLanguage;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.AnnotatedTextBuilder;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.RuleInformation;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.tools.ContextTools;

public class RuleMatchesAsJsonSerializer {
    private static final int API_VERSION = 1;
    private static final String STATUS = "";
    private static final String PREMIUM_HINT = "You might be missing errors only the Premium version can find. Contact us at support<at>languagetoolplus.com.";
    private static final String START_MARKER = "__languagetool_start_marker";
    private final JsonFactory factory = new JsonFactory();

    public String ruleMatchesToJson(List<RuleMatch> matches, String text, int contextSize, DetectedLanguage detectedLang) {
        return this.ruleMatchesToJson(matches, new ArrayList<RuleMatch>(), text, contextSize, detectedLang, null);
    }

    public String ruleMatchesToJson(List<RuleMatch> matches, List<RuleMatch> hiddenMatches, String text, int contextSize, DetectedLanguage detectedLang, String incompleteResultsReason) {
        return this.ruleMatchesToJson(matches, hiddenMatches, new AnnotatedTextBuilder().addText(text).build(), contextSize, detectedLang, incompleteResultsReason);
    }

    public String ruleMatchesToJson(List<RuleMatch> matches, List<RuleMatch> hiddenMatches, AnnotatedText text, int contextSize, DetectedLanguage detectedLang, String incompleteResultsReason) {
        ContextTools contextTools = new ContextTools();
        contextTools.setEscapeHtml(false);
        contextTools.setContextSize(contextSize);
        contextTools.setErrorMarkerStart(START_MARKER);
        contextTools.setErrorMarkerEnd(STATUS);
        StringWriter sw = new StringWriter();
        try (JsonGenerator g = this.factory.createGenerator((Writer)sw);){
            g.writeStartObject();
            this.writeSoftwareSection(g);
            this.writeWarningsSection(g, incompleteResultsReason);
            this.writeLanguageSection(g, detectedLang);
            this.writeMatchesSection("matches", g, matches, text, contextTools, detectedLang.getGivenLanguage());
            if (hiddenMatches != null && hiddenMatches.size() > 0) {
                this.writeMatchesSection("hiddenMatches", g, hiddenMatches, text, contextTools, detectedLang.getGivenLanguage());
            }
            g.writeEndObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    private void writeSoftwareSection(JsonGenerator g) throws IOException {
        g.writeObjectFieldStart("software");
        g.writeStringField("name", "LanguageTool");
        g.writeStringField("version", "4.4");
        g.writeStringField("buildDate", JLanguageTool.BUILD_DATE);
        g.writeNumberField("apiVersion", 1);
        g.writeBooleanField("premium", JLanguageTool.isPremiumVersion());
        if (!JLanguageTool.isPremiumVersion()) {
            g.writeStringField("premiumHint", PREMIUM_HINT);
        }
        g.writeStringField("status", STATUS);
        g.writeEndObject();
    }

    private void writeWarningsSection(JsonGenerator g, String incompleteResultsReason) throws IOException {
        g.writeObjectFieldStart("warnings");
        if (incompleteResultsReason != null) {
            g.writeBooleanField("incompleteResults", true);
            g.writeStringField("incompleteResultsReason", incompleteResultsReason);
        } else {
            g.writeBooleanField("incompleteResults", false);
        }
        g.writeEndObject();
    }

    private void writeLanguageSection(JsonGenerator g, DetectedLanguage detectedLang) throws IOException {
        g.writeObjectFieldStart("language");
        g.writeStringField("name", detectedLang.getGivenLanguage().getName());
        g.writeStringField("code", detectedLang.getGivenLanguage().getShortCodeWithCountryAndVariant());
        g.writeObjectFieldStart("detectedLanguage");
        g.writeStringField("name", detectedLang.getDetectedLanguage().getName());
        g.writeStringField("code", detectedLang.getDetectedLanguage().getShortCodeWithCountryAndVariant());
        g.writeNumberField("confidence", detectedLang.getDetectionConfidence());
        g.writeEndObject();
        g.writeEndObject();
    }

    private void writeMatchesSection(String sectionName, JsonGenerator g, List<RuleMatch> matches, AnnotatedText text, ContextTools contextTools, Language lang) throws IOException {
        g.writeArrayFieldStart(sectionName);
        for (RuleMatch match : matches) {
            g.writeStartObject();
            g.writeStringField("message", this.cleanSuggestion(match.getMessage()));
            if (match.getShortMessage() != null) {
                g.writeStringField("shortMessage", this.cleanSuggestion(match.getShortMessage()));
            }
            this.writeReplacements(g, match);
            g.writeNumberField("offset", match.getFromPos());
            g.writeNumberField("length", match.getToPos() - match.getFromPos());
            this.writeContext(g, match, text, contextTools);
            g.writeObjectFieldStart("type");
            g.writeStringField("typeName", match.getType().toString());
            g.writeEndObject();
            this.writeRule(g, match);
            g.writeBooleanField("ignoreForIncompleteSentence", RuleInformation.ignoreForIncompleteSentences(match.getRule().getId(), lang));
            g.writeEndObject();
        }
        g.writeEndArray();
    }

    private String cleanSuggestion(String s) {
        return s.replace("<suggestion>", "\"").replace("</suggestion>", "\"");
    }

    private void writeReplacements(JsonGenerator g, RuleMatch match) throws IOException {
        g.writeArrayFieldStart("replacements");
        for (String replacement : match.getSuggestedReplacements()) {
            g.writeStartObject();
            g.writeStringField("value", replacement);
            g.writeEndObject();
        }
        g.writeEndArray();
    }

    private void writeContext(JsonGenerator g, RuleMatch match, AnnotatedText text, ContextTools contextTools) throws IOException {
        String context = contextTools.getContext(match.getFromPos(), match.getToPos(), text.getTextWithMarkup());
        int contextOffset = context.indexOf(START_MARKER);
        context = context.replaceFirst(START_MARKER, STATUS);
        g.writeObjectFieldStart("context");
        g.writeStringField("text", context);
        g.writeNumberField("offset", contextOffset);
        g.writeNumberField("length", match.getToPos() - match.getFromPos());
        g.writeEndObject();
        if (match.getSentence() != null) {
            g.writeStringField("sentence", match.getSentence().getText().trim());
        }
    }

    private void writeRule(JsonGenerator g, RuleMatch match) throws IOException {
        AbstractPatternRule pRule;
        g.writeObjectFieldStart("rule");
        g.writeStringField("id", match.getRule().getId());
        if (match.getRule() instanceof AbstractPatternRule && (pRule = (AbstractPatternRule)match.getRule()).getSubId() != null) {
            g.writeStringField("subId", pRule.getSubId());
        }
        g.writeStringField("description", match.getRule().getDescription());
        g.writeStringField("issueType", match.getRule().getLocQualityIssueType().toString());
        if (match.getUrl() != null || match.getRule().getUrl() != null) {
            g.writeArrayFieldStart("urls");
            g.writeStartObject();
            if (match.getUrl() != null) {
                g.writeStringField("value", match.getUrl().toString());
            } else {
                g.writeStringField("value", match.getRule().getUrl().toString());
            }
            g.writeEndObject();
            g.writeEndArray();
        }
        this.writeCategory(g, match.getRule().getCategory());
        g.writeEndObject();
    }

    private void writeCategory(JsonGenerator g, Category category) throws IOException {
        g.writeObjectFieldStart("category");
        CategoryId catId = category.getId();
        if (catId != null) {
            g.writeStringField("id", catId.toString());
            g.writeStringField("name", category.getName());
        }
        g.writeEndObject();
    }
}

