/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class TrainingParameters {
    public static final String ALGORITHM_PARAM = "Algorithm";
    public static final String TRAINER_TYPE_PARAM = "TrainerType";
    public static final String ITERATIONS_PARAM = "Iterations";
    public static final String CUTOFF_PARAM = "Cutoff";
    public static final String THREADS_PARAM = "Threads";
    private Map<String, String> parameters = new HashMap<String, String>();

    public TrainingParameters() {
    }

    public TrainingParameters(TrainingParameters trainingParameters) {
        this.parameters.putAll(trainingParameters.parameters);
    }

    public TrainingParameters(Map<String, String> map) {
        this.parameters.putAll(map);
    }

    public TrainingParameters(InputStream in) throws IOException {
        Properties properties = new Properties();
        properties.load(in);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.parameters.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public String algorithm(String namespace) {
        return this.parameters.get(namespace + "." + ALGORITHM_PARAM);
    }

    public String algorithm() {
        return this.parameters.get(ALGORITHM_PARAM);
    }

    public Map<String, String> getSettings(String namespace) {
        HashMap<String, String> trainingParams = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            String key = entry.getKey();
            if (namespace != null) {
                String prefix = namespace + ".";
                if (!key.startsWith(prefix)) continue;
                trainingParams.put(key.substring(prefix.length()), entry.getValue());
                continue;
            }
            if (key.contains(".")) continue;
            trainingParams.put(key, entry.getValue());
        }
        return Collections.unmodifiableMap(trainingParams);
    }

    public Map<String, String> getSettings() {
        return this.getSettings(null);
    }

    public TrainingParameters getParameters(String namespace) {
        TrainingParameters params = new TrainingParameters();
        for (Map.Entry<String, String> entry : this.getSettings(namespace).entrySet()) {
            params.put(entry.getKey(), entry.getValue());
        }
        return params;
    }

    public void put(String namespace, String key, String value) {
        if (namespace == null) {
            this.parameters.put(key, value);
        } else {
            this.parameters.put(namespace + "." + key, value);
        }
    }

    public void put(String key, String value) {
        this.put(null, key, value);
    }

    public void serialize(OutputStream out) throws IOException {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        properties.store(out, null);
    }

    public String getStringParameter(String key, String defaultValue) {
        return this.parameters.getOrDefault(key, defaultValue);
    }

    public String getStringParameter(String namespace, String key, String defaultValue) {
        if (namespace == null) {
            return this.getStringParameter(key, defaultValue);
        }
        return this.parameters.getOrDefault(namespace + "." + key, defaultValue);
    }

    public int getIntParameter(String key, int defaultValue) {
        String value = this.parameters.getOrDefault(key, Integer.toString(defaultValue));
        return Integer.parseInt(value);
    }

    public int getIntParameter(String namespace, String key, int defaultValue) {
        if (namespace == null) {
            return this.getIntParameter(key, defaultValue);
        }
        String value = this.parameters.getOrDefault(namespace + "." + key, Integer.toString(defaultValue));
        return Integer.parseInt(value);
    }

    public double getDoubleParameter(String key, double defaultValue) {
        String value = this.parameters.getOrDefault(key, Double.toString(defaultValue));
        return Double.parseDouble(value);
    }

    public double getDoubleParameter(String namespace, String key, double defaultValue) {
        if (namespace == null) {
            return this.getDoubleParameter(key, defaultValue);
        }
        String value = this.parameters.getOrDefault(namespace + "." + key, Double.toString(defaultValue));
        return Double.parseDouble(value);
    }

    public boolean getBooleanParameter(String key, boolean defaultValue) {
        String value = this.parameters.getOrDefault(key, Boolean.toString(defaultValue));
        return Boolean.parseBoolean(value);
    }

    public boolean getBooleanParameter(String namespace, String key, boolean defaultValue) {
        if (namespace == null) {
            return this.getBooleanParameter(key, defaultValue);
        }
        String value = this.parameters.getOrDefault(namespace + "." + key, Boolean.toString(defaultValue));
        return Boolean.parseBoolean(value);
    }

    public static TrainingParameters defaultParams() {
        TrainingParameters mlParams = new TrainingParameters();
        mlParams.put(ALGORITHM_PARAM, "MAXENT");
        mlParams.put(TRAINER_TYPE_PARAM, "Event");
        mlParams.put(ITERATIONS_PARAM, Integer.toString(100));
        mlParams.put(CUTOFF_PARAM, Integer.toString(5));
        return mlParams;
    }
}

