/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class LongSentenceRule
extends Rule {
    public static final String RULE_ID = "TOO_LONG_SENTENCE";
    private static final int DEFAULT_MAX_WORDS = 50;
    private static final Pattern NON_WORD_REGEX = Pattern.compile("[.?!\u2026:;,~\u2019'\"\u201e\u201c\u201d\u00bb\u00ab\u201a\u2018\u203a\u2039()\\[\\]\\-\u2013\u2014*\u00d7\u2217\u00b7+\u00f7/=]");
    private static final boolean DEFAULT_ACTIVATION = false;
    protected static int maxWords = 50;

    public LongSentenceRule(ResourceBundle messages, boolean defaultActive) {
        super(messages);
        super.setCategory(Categories.STYLE.getCategory(messages));
        if (!defaultActive) {
            this.setDefaultOff();
        }
        this.setLocQualityIssueType(ITSIssueType.Style);
    }

    public LongSentenceRule(ResourceBundle messages) {
        this(messages, false);
    }

    @Override
    public String getDescription() {
        return MessageFormat.format(this.messages.getString("long_sentence_rule_desc"), maxWords);
    }

    @Override
    public String getId() {
        return RULE_ID;
    }

    @Override
    public void setDefaultValue(int numWords) {
        maxWords = numWords;
    }

    @Override
    public int getDefaultValue() {
        return maxWords;
    }

    public String getMessage() {
        return MessageFormat.format(this.messages.getString("long_sentence_rule_msg2"), maxWords);
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        String msg = this.getMessage();
        if (tokens.length < maxWords + 1) {
            return this.toRuleMatchArray(ruleMatches);
        }
        int numWords = 0;
        int startPos = 0;
        for (AnalyzedTokenReadings aToken : tokens) {
            String token = aToken.getToken();
            if (aToken.isSentenceStart() || aToken.isSentenceEnd() || NON_WORD_REGEX.matcher(token).matches()) continue;
            int prevStartPos = startPos;
            startPos = aToken.getStartPos();
            if (++numWords <= maxWords) continue;
            RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, prevStartPos, aToken.getEndPos(), msg);
            ruleMatches.add(ruleMatch);
            break;
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

