//
//  NevoGame.m
//  Gridlock
//
//  Created by Brian on 10/16/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import "NevoGame.h"


@implementation NevoGame

-(void)reset {
  [super reset];
  [self createGridFromConfiguration];
  [self fillFirstRows:1];
}

-(BOOL)showScores {
  return YES;
}

-(NSArray *)allValidMoveSequences {
  NSMutableArray *moves = [NSMutableArray array];
  NSEnumerator *pe = [[self grid] enumeratorForPositionsWithValue:[self currentPlayerNumber]];
  id pos;
  while(pos=[pe nextObject]) {
    int dr,dc;
    for(dr=-1; dr<=+1; dr++) {
      for(dc=-1; dc<=+1; dc++) {
        if (dr!=0 || dc!=0) {
          id nextpos = [DCHypergridPosition positionWithRow:[pos row]+dr column:[pos column]+dc];
          if ([self isPositionValid:nextpos] && [self valueAtPosition:nextpos]==0) {
            // TODO: make sure it doesn't split into two connected groups of equal size
            [moves addObject:[NSArray arrayWithObjects:pos,nextpos,nil]];
          }
        }
      }
    }
  }
  if ([moves count]==0) [moves addObject:[NSArray array]];
  return moves;
}

-(BOOL)prepareMoveSequence:(NSArray *)positions {
  [self resetFutureGrid];
  if ([positions count]==0) return YES;
  // first position is empty, second position is filled
  int pnum = [self currentPlayerNumber];
  [[self futureGrid] setValue:0 atPosition:[positions objectAtIndex:0]];
  [[self futureGrid] setValue:pnum atPosition:[positions objectAtIndex:1]];
  
  // remove all but largest connected group
  NSArray *groups = [[self futureGrid] connectedGroupsWithValue:pnum onlyOrthoganal:NO];
  int i;
  for(i=0; i<[groups count]-1; i++) {
    NSEnumerator *pe = [[groups objectAtIndex:i] objectEnumerator];
    id pos;
    while (pos=[pe nextObject]) {
      [[self futureGrid] setValue:0 atPosition:pos];
    }
  }
  
  return YES;
}

-(int)scoreForPlayer:(int)pnum {
  static int rowScores[] = {8,5,2};
  static int numRowScores = 3;
  
  int numcols = [self numberOfColumns];
  int dr = (pnum==1) ? -1 : +1;
  int baseRow = (pnum==1) ? [self numberOfRows]-1 : 0;
  
  int score=0;
  int i;
  for(i=0; i<numRowScores; i++) {
    int r=baseRow + i*dr;
    int c;
    for(c=0; c<numcols; c++) {
      if ([self valueAtRow:r column:c]==pnum) {
        score += rowScores[i];
      }
    }
  }
  return score;
}

-(BOOL)isGameOver {
  return [self scoreForPlayer:1]>=16 || [self scoreForPlayer:2]>=16;
}

@end
