//
//  OvalWindow.m
//  Cosmic Debris
//
//  Created by John Schilling on 11/30/04.
//  Copyright 2004 John Schilling. All rights reserved.
//

#import "SSWindow.h"

#define RESIZE_INCREMENT       0.10

@protocol SSWindowProtocol
- (void)setBottomCornerRounded:(BOOL)flag;
@end

@implementation SSWindow

#pragma mark
#pragma mark PRIVATE INSTANCE METHODS
#pragma mark

- (id)initWithContentRect:(NSRect)contentRect 
        styleMask:(unsigned int)aStyle 
        backing:(NSBackingStoreType)bufferingType 
        defer:(BOOL)flag 
{
    if (![super initWithContentRect: contentRect 
                            styleMask: aStyle
                              backing: bufferingType 
                                defer: flag])
    {
        return nil;
    }
    
    [self setHidesOnDeactivate: NO];
    [self setLevel: NSNormalWindowLevel];
    [self setMovableByWindowBackground: YES];
    
    if ([self respondsToSelector: @selector(setBottomCornerRounded:)]) [(id <SSWindowProtocol>)self setBottomCornerRounded:NO];
   
   
    NSRect wFrame   = [self frame];
    NSRect cFrame   = [[self contentView] frame];
    _dwidth         = cFrame.size.width;
    _dheight        = cFrame.size.height;
    _titleBarHeight = wFrame.size.height - cFrame.size.height;
    
    [self setAspectRatio: NSMakeSize(_dwidth, _dheight + _titleBarHeight)];
    
    return self;
}

- (void)awakeFromNib
{
    if (![self setFrameUsingName: [self frameAutosaveName]]) {
        [self center];
    }
}

- (void)dealloc
{

    [super dealloc];
}

- (IBAction)open:(id)sender
{
    [NSApp activateIgnoringOtherApps:YES];
    [self makeKeyAndOrderFront:self];
}

- (void)clearImage
{
    [_imageView setImage:nil];
    [self setLastUpdatedField:@"Unknown"];
    return;
}

- (void)setImage:(NSImage *)image updated:(NSString *)updated
{
    if (image) {
        [_imageView setImage:image];
        [self setLastUpdatedField:updated];
        [self updateDockIcon:image];
        [self update];
    } else {
        [self clearImage];
        [self update];
    }
    return;
}

- (void)setLastUpdatedField:(NSString *)updated
{
    [_imageUpdatedField setStringValue:[NSString stringWithFormat:@"Last Updated: %@", updated]];
    return;
}

- (void)updateDockIcon:(NSImage *)image
{
    [self setMiniwindowImage: image];
}








- (void)viewAtDefaultSize:(id)sender
{
    NSSize defaultSize = NSMakeSize(_dwidth, _dheight);
    [self zoomToNewSize:defaultSize animates:YES];
}

- (void)zoomToNewSize:(NSSize)newSize animates:(BOOL)animates
{
    NSRect cRect = NSMakeRect(0, 0, newSize.width, newSize.height + _titleBarHeight);
    NSRect nRect = NSMakeRect([self frame].origin.x, 
                    [self frame].origin.y - (cRect.size.height - [self frame].size.height), 
                    cRect.size.width, cRect.size.height);
    [self setFrame:nRect display:YES animate:animates];
}

@end
