#!/usr/bin/python

#*******************************************************************************
# The information contained in this file is confidential and proprietary to
# QLogic Corporation.  No part of this file may be reproduced or
# distributed, in any form or by any means for any purpose, without the
# express written permission of QLogic Corporation.
#
# (c) COPYRIGHT 2016 QLogic Corporation, ALL RIGHTS RESERVED.
#*******************************************************************************
#*******************************************************************************
# Copyright 2016 VMware, Inc.  All rights reserved. -- VMware Confidential
#*******************************************************************************
#*******************************************************************************
# See LICENSE.qfle3f for copyright and licensing details.
#*******************************************************************************

# The following file is used to extract the individual firmware
# dumps for the qlnativefc_dump file.
#

import sys, re, types
from time import strftime, localtime
import traceback
from tempfile import mkstemp
from shutil import move
from os import remove, close, getcwd
import os

def usage():
	print "\n File Name missing or Invalid number of arguments given."
	print "\n Eg : python convertToNonGPL.py qla_os.c\n"

def searchAndReplace(line):
	lookingFor = re.search("strlen", line)
	if (isinstance(lookingFor, types.NoneType)):
		return line
	endOfstrlen = re.search("\);", line)
	#print "start : " + str(lookingFor.start()) + " end :  " + str(lookingFor.end()) + " --- :"  + line;
	# print "End of strlen : " + str(endOfstrlen.start()) + " : " +  str(endOfstrlen.end())

	newLine = line[0:lookingFor.start()]
	newLine += "vmk_Strnlen"
	newLine += line[lookingFor.end():endOfstrlen.start()]
	newLine += ", VMK_HARMAN_MAX_STRING_LENGTH";
	newLine += ");\n"
	#print "NewLine : " + newLine;
	return newLine

# Simple search and replace.
# search the "searchPattern" in input "line" and replace it with "replacePattern"
#
def simpleSearchAndReplace(line, searchPattern, replacePattern):
	searchIter = re.finditer(searchPattern, line)

	start = 0
	newLine = ""
	for oneIter in searchIter:
		newLine += line[start:oneIter.start()]
		newLine += replacePattern

		start = oneIter.end()

	#print "start : " + str(lookingFor.start()) + " end :  " + str(lookingFor.end()) + " --- :"  + line;
	# print "End of strlen : " + str(endOfstrlen.start()) + " : " +  str(endOfstrlen.end())

	newLine += line[start:]
	#print "NewLine : " + newLine;
	return newLine

# Return 'True' is line contains exclusion else return 'False'
def checkForexclusions(line):
	exclusionPatterns = [
		"__inline__",
		"VMK_",
		"vmk_",
		"__func__",
		"__constant_htonl",
		"__qla83xx",
		"__FUNCTION__",
		"__be16",
		"__be32",
		"__QL",
		"__attribute",
		"__qlnativefc",
		"__iomem",
		"__builtin",
		"__qlafxxx",
		"__VMKLNX",
		"ifndef",
		"QLA_",
		"__packed",
		"__LINE__",
		"__data",
		"__STDC__",
		"__cplusplus",
		"__BIG_ENDIAN",
		"__",
		"qla_8044.h",
		"qla_dbg.h",
		"qla_def.h",
		"qla_devtbl.h",
		"qla_fw.h",
		"qla_gbl.h",
		"qla_helper.h",
		"qla_inline.h",
		"qla_isa_api.h",
		"qla_isa_fw.h",
		"qla_isa_gbl.h",
		"qla_isa_ioctl.h",
		"qla_nx.h",
		"qla_settings.h",
		"qla_tmpl.h",
		"qla_version.h",
		"qla_vmkmgmt_api.h",
		"ql_basetypes.h",
		"ql_isa_vmkmgmt.h",
		"ql_vmkmgmt.h",
		"ql_vmkmgmt_struct.h",
		"ql2400_fw.c",
		"ql2500_fw.c",
	]

	for singleExclusion in exclusionPatterns:
		lookingFor  = re.search(singleExclusion, line);

		if not (isinstance(lookingFor, types.NoneType)):
			return True


	return False

#
def convertHungarian(text):
	newText = ""
	counter = 0

	#while(text[counter] == " " or text[counter] == "\t"):
	#	newText += text[counter]
	#	counter += 1

	#print "Old Text [-]" + text + "[-]"
	#words = text.split()
	seperator = r' ';
	words = re.split(seperator, text)

	if(len(words) == 1):
		for oneWord in words:
			del oneWord
		seperator = r'\t'
		words = re.split(seperator, text)

	for oneWord in words:
		if(checkForexclusions(oneWord) == True):
			newText += oneWord
			newText += " "
			continue

		#print "Word Prev : " + oneWord
		miniWords = re.split(r'_', oneWord)
		counter = 0

		oneNewWord = ""
		for oneMiniWord in miniWords:
			if(counter != 0):
				if(oneMiniWord[0].isupper() is True or oneMiniWord[0].isdigit()):
					oneNewWord += "_"
					oneNewWord += oneMiniWord
				else:
					oneNewWord += oneMiniWord[0].swapcase() + oneMiniWord[1:]
			else:
				oneNewWord += oneMiniWord

			counter = counter + 1

		newText += oneNewWord
		if(seperator == r'\t'):
			newText += "\t"
		if(seperator == r' '):
			newText += " "

	newText = newText[0:len(newText)-1];
	#print "New Text [-]" + newText + "[-]"
	return newText


def getParameters(line, startFunctionNameIndex, endFunctionNameIndex):
	print "Line : " + line
	if(line[endFunctionNameIndex] == '('):
		postLine = line[endFunctionNameIndex+1:len(line)]
		print "Post : " + postLine
		parameters = re.findall(',', postLine)
		i = 0
		if len(parameters) is 0:
			endFunc = re.search("\);", postLine);
			parameters.append(postLine[0:endFunc.start()])

		for param in parameters:
			print "Param " + str(i) + ": " + param
			i = i + 1

def searchAndReplaceAdvance(line, pattern):

	for key in pattern:
		oldFunctionName = key;
		newV = pattern[key];
		for keysNewV in newV:
			newFunctionName = keysNewV
			parameters = newV[keysNewV]

			#print "Old Func : " + oldFunctionName + " -- NewFunc : " + newFunctionName
			#print "Line : " + line
			lookingFor = re.search(oldFunctionName, line)
			if (isinstance(lookingFor, types.NoneType)):
				continue

			oldParameters = getParameters(line, lookingFor.start(), lookingFor.end())

			endOfstrlen = re.search("\);", line)
			#print "start : " + str(lookingFor.start()) + " end :  " + str(lookingFor.end()) + " --- :"  + line;
			# print "End of strlen : " + str(endOfstrlen.start()) + " : " +  str(endOfstrlen.end())

			newLine = line[0:lookingFor.start()]
			newLine += "vmk_Strnlen"
			newLine += line[lookingFor.end():endOfstrlen.start()]
			newLine += ", VMK_HARMAN_MAX_STRING_LENGTH";
			newLine += ");\n"
			#print "NewLine : " + newLine;
			return newLine

def main(argv):
	"""Convert the source code from GPL to NON-GPL"""
	pattern = { 'wwn_to_u64' : {'char_array_to_vmk_u64' : [['OldParam', '1', '', ''], ['newValue', '8', '', ''], ['OldReturnValue', '', '&', '']] } };
	# 'key'		: search pattern
	# 'value'	: replace pattern
	simplePattern = {
		"bnx2fc" : "qfle3f",
		"BNX2FC" : "QFLE3F",
        "QEDFC"  : "QFLE3F",
        "qedfc"  : "qfle3f",
        "qfce3"  : "qfle3f",
        "QFCE3"  : "QFLE3F",
        "QFLE3I" : "QFLE3F",
        "qfle3i" : "qfle3f",
        "QLNATIVEFC" : "QFLE3F",
        "qlnativefc" : "qfle3f",
		"__u8"       : "vmk_uint8",
		"__le16"     : "vmk_uint16",
		"__le32"     : "vmk_uint32",
		"__le64"     : "vmk_uint64",
		"__be16"     : "vmk_uint16",
		"__be32"     :  "vmk_uint32",
		"__be64"     :  "vmk_uint64",
#		"u8"		 :	"vmk_uint8",
#		"u16"		 :	"vmk_uint16",
#		"u32"		 :	"vmk_uint32",
#		"u64"		 :	"vmk_uint64",

		"unsigned int"	:	"vmk_uint32",
		"fc_frame_alloc\("	:	"ql_fcoe_frame_alloc(hba->qlfcoe_hba",


		"struct sk_buff"	:	"vmk_PktHandle",

		"FIP_DT_MAC"	:	"FCOE_FIP_DESC_MAC_ADDRESS",
		"FIP_DT_NAME"	:	"FCOE_FIP_DESC_NAME_IDENTIFIER",
		"FIP_DT_VN_ID"	:	"FCOE_FIP_DESC_VXPORT_IDENTIFIER",

		"atomic_t"   :  "vmk_atomic64",
		"struct timer_list" :   "vmk_Timer",
		"struct completion" :   "vmk_WorldEventID",
		"struct kref"       :   "vmk_atomic64",
		" PAGE_SIZE" :   " VMK_PAGE_SIZE",
		" PAGE_MASK" :   " VMK_PAGE_MASK",
		" PAGE_SHIFT" :   " VMK_PAGE_SHIFT",
		"HZ"         :   "vmk_TimerCyclesPerSecond()",

		"cpu_to_le16"	:	"QL_CPU_TO_LE16",
		"cpu_to_le32"	:	"QL_CPU_TO_LE32",
		"cpu_to_le64"	:	"QL_CPU_TO_LE64",

		"kref_init"		:	"ql_vmk_ref_init",

        #"adapter"    : "hba",
        "qfle3f_hba"  : "qfle3fHBA",
        "qfle3f_fclun"  :   "qfle3fFCLun",
        "qfle3f_cmd"    :   "qfle3fCommand",
        "qfle3fCommand_mgr" :   "qfle3fCommandManager",
        "qfle3fCommand_pool"    :   "qfle3fCommandPool",
        "io_req"    :   "ioRequest",
        "cmd_mgr"   :   "commandManager",
        "cmgr_lock" :   "commandManagerLock",
        "next_idx"  :   "nextIndex",
#        "free_list" :   "freeList",
        "qfle3fRportState"      :   "qfle3f_rportState",
        "aborted_ioRequest"     :   "abortedIORequest",

        "qfle3fUploadTimer"             :   "qfle3f_uploadTimer",
        "qfle3fOffloadTimer"             :   "qfle3f_offloadTimer",
        "qfle3fOffloadSession"          :   "qfle3f_offloadSession",
        "qfle3fFlushActiveIOs"          :   "qfle3f_flushActiveIOs",
        "qfle3fUploadSession"           :   "qfle3f_uploadSession",
        "qfle3fInitializeTarget"        :   "qfle3f_initializeTarget",
        "qfle3fRemotePortAdd"           :   "qfle3f_remotePortAdd",
        "qfle3fFreeTarget"              :   "qfle3f_freeTarget",
        "qfle3fRemotePortDelete"        :   "qfle3f_remotePortDelete",
        "qfle3fRportEventHandler"       :   "qfle3f_rportEventHandler",
        "qfle3fTargetLookup"            :   "qfle3f_targetLookup",
        "qfle3fAllocConnectionID"       :   "qfle3f_allocConnectionID",
        "qfle3fFreeConnectionID"        :   "qfle3f_freeConnectionID",
        "qfle3fAllocSessionResources"   :   "qfle3f_allocSessionResources",
        "qfle3fFreeSessionResources"    :   "qfle3f_freeSessionResources",

        "qfle3f_send_stat_req"              :   "qfle3f_sendStatRequest",
        "qfle3f_send_fw_fcoe_init_msg"      :   "qfle3f_sendFirmwareFCoEInitiMessage",
        "qfle3f_send_fw_fcoe_destroy_msg"   :   "qfle3f_sendFirmwareFCoEDestroyMessage",
        "qfle3f_send_session_ofld_req"      :   "qfle3f_sendSessionOffloadRequest",
        "qfle3f_send_session_enable_req"    :   "qfle3f_sendSessionEnableRequest",
        "qfle3f_send_session_disable_req"   :   "qfle3f_sendSessionDisableRequest",
        "qfle3f_send_session_destroy_req"   :   "qfle3f_sendSessionDestroyRequest",
        "qfle3f_process_l2_frame_compl"     :   "qfle3f_processL2FrameCompletion",
        "qfle3f_process_unsol_compl"        :   "qfle3f_processUnsolicilatedCompletion",
        "qfle3f_process_cq_compl"           :   "qfle3f_processCQCompletion",
        "qfle3f_arm_cq"                     :   "qfle3f_armCQ",
        "qfle3f_process_new_cqes"           :   "qfle3f_processNewMultipleCQ",
        "qfle3f_fastpath_notification"      :   "qfle3f_fastpathNotification",
        "qfle3f_process_ofld_cmpl"          :   "qfle3f_processOffloadCompletion",
        "qfle3f_process_enable_conn_cmpl"   :   "qfle3f_processConnectionEnableCompletion",
        "qfle3f_process_conn_disable_cmpl"  :   "qfle3f_processConnectionDisableCompletion",
        "qfle3f_process_conn_destroy_cmpl"  :   "qfle3f_processConnectionDestroyCompletion",
        "qfle3f_init_failure"               :   "qfle3f_initializationFailure",
        "qfle3f_indicate_kcqe"              :   "qfle3f_indicateKCQE",
        "qfle3f_add_2_sq"                   :   "qfle3f_addToSQ",
        "qfle3f_ring_doorbell"              :   "qfle3f_ringDoorbell",
        "qfle3f_map_doorbell"               :   "qfle3f_mapDoorbell",
        "qfle3f_get_next_rqe"               :   "qfle3f_getNextRequestQueueEntry",
        "qfle3f_return_rqe"                 :   "qfle3f_returnRequestQueueEntry",
        "qfle3f_init_cleanup_task"          :   "qfle3f_initializeCleanupTask",
        "qfle3f_init_mp_task"               :   "qfle3f_initializeMPTask",
        "qfle3f_init_task"                  :   "qfle3f_initializeTask",
        "qfle3f_setup_task_ctx"             :   "qfle3f_setupTaskContext",
        "qfle3f_free_task_ctx"              :   "qfle3f_freeTaskContext",
        "qfle3f_free_hash_table"            :   "qfle3f_freeHashTable",
        "qfle3f_allocate_hash_table"        :   "qfle3f_allocateHashTable",
        "qfle3f_setup_fw_resc"              :   "qfle3f_setupFWResources",
        "qfle3f_free_fw_resc"                :   "qfle3f_freeFWResources",

        "qfle3f_indicate_netevent"          :   "qfle3f_indicateNetworkEvent",
        "qfle3f_ulp_get_stats"              :   "qfle3f_ulpGetStats",
        "ofld_timer"                        :   "ofldTimer",
        "upld_timer"                        :   "upldTimer",

        "hba_type"              :   "hbaType",
        "next_conn_id"          :   "nextConnectionID",
        "task_ctx_dma"          :   "taskContextDMA",
        "task_ctx_bd_tbl"       :   "taskContextBDTable",
        "task_ctx_bd_dma"       :   "taskContextBDDMA",
        "hash_tbl_segment_count"    :   "hashTableSegmentCount",
        "hash_tbl_segments"         :   "hashTableSegments",
        "hash_tbl_segments_dma"     :   "hashTableSegmentsDMA",
#        "hash_tbl_pbl"              :   "hashTablePBL",
#        "hash_tbl_pbl_dma"          :   "hashTablePBLDMA",
#        "t2_hash_tbl"               :   "t2HashTable",
#        "t2_hash_tbl_dma"           :   "t2HashTableDMA",
#        "t2_hash_tbl_ptr"           :   "t2HashTablePointer",
#        "t2_hash_tbl_ptr_dma"       :   "t2HashTablePointerDMA",
        "vmhba_name"                :   "vmhbaName",
#        "dummy_buffer"              :   "dummyBuffer",
#        "dummy_buf_dma"             :   "dummyBufferDMA",
        "stats_buffer"              :   "statsBuffer",
        "stats_buf_dma"             :   "statsBufferDMA",
        "fcoe_disc_work"            :   "fcoeDiscoveryWork",
        "scsi_scan_list"            :   "scsiScanList",
        "scsi_scan_list_lck"        :   "scsiScanListLock",
        "scsi_scan_world_id"        :   "scsiScanWorldID",

        "destroy_func_event"        :   "destroyFunctionEvent",
        "stat_req_done"             :   "statRequestDone",
#        "fcoe_cap"                  :   "fcoeCapabilities",
        "vlan_grp_unset_drop_stat"  :   "vlanGroupUnsetDropStat",
        "vlan_invalid_drop_stat"    :   "vlanInvalidDropStat",
        "num_max_frags"             :   "numberMaxFrags",
        "cna_init_queue"            :   "cnaInitializeQueue",
        "cna_clean_queue"           :   "cnaCleanupQueue",
        "fcoe_if_restart_wq"        :   "fcoeInterfaceRestartWorkQueue",
        "hashTablePBL_dma"          :   "hashTablePBLDMA",
        "qfle3f_find_target_by_targetID"    :   "qfle3f_findTargetByTargetID",
        "qfle3f_get_fclun"                  :   "qfle3f_getFCLun",
        "qfle3f_allocate_fclun"             :   "qfle3f_allocateFCLun",
        "qfle3fCommand_timer_set"           :   "qfle3f_commandTimerSet",
        "qfle3fCommand_timeout"             :   "qfle3f_commandTimeout",
        "qfle3f_scsi_done"                  :   "qfle3f_scsiDone",
        "qfle3fCommandManager_alloc"        :   "qfle3f_commandManagerAlloc",
        "qfle3fCommandManager_free"         :   "qfle3f_commandManagerFree",
        "qfle3f_elstm_alloc"                :   "qfle3f_elstmAlloc",
        "qfle3fCommand_alloc"               :   "qfle3f_commandAlloc",
        "qfle3fCommand_release"             :   "qfle3f_commandRelease",
        "qfle3f_free_mp_resc"               :   "qfle3f_freeMPResources",
        "qfle3f_init_mp_req"                :   "qfle3f_initMPRequest",
        "qfle3f_execute_tmf"                :   "qfle3f_executeTMF",
        "qfle3f_initiate_tmf"               :   "qfle3f_initiateTMF",
        "qfle3f_initiate_abts"              :   "qfle3f_initiateABTS",
        "qfle3f_initiate_cleanup"           :   "qfle3f_initiateCleanup",
        "qfle3f_device_reset"               :   "qfle3f_deviceReset",
        "qfle3f_lun_reset"                  :   "qfle3f_lunReset",
        "qfle3f_eh_virtual_reset"           :   "qfle3f_virtualReset",
        "qfle3f_expl_logo"                  :   "qfle3f_explicitLogout",
        "qfle3f_bus_reset"                  :   "qfle3f_busReset",
        "qfle3f_eh_abort"                   :   "qfle3f_ehAbort",
        "qfle3f_process_cleanup_compl"      :   "qfle3f_processCleanupCompletion",
        "qfle3f_process_abts_compl"         :   "qfle3f_processABTSCompletion",
        "qfle3f_lun_reset_cmpl"             :   "qfle3f_lunResetCompletion",
        "qfle3f_tgt_reset_cmpl"             :   "qfle3f_targetResetCompletion",
        "qfle3f_process_tm_compl"           :   "qfle3f_processTMCompletion",
        "qfle3f_split_bd"                   :   "qfle3f_splitBD",
        "qfle3f_map_sg"                     :   "qfle3f_mapSG",
        "qfle3f_build_bd_list_from_sg"      :   "qfle3f_buildBDListFromSG",
        "qfle3f_unmap_sg_list"              :   "qfle3f_unmapSGList",
        "qfle3f_build_fcp_cmnd"             :   "qfle3f_buildFCPCommand",
        "qfle3f_parse_fcp_rsp"              :   "qfle3f_parseFCPResponse",
        "qfle3f_process_scsi_cmd_compl"     :   "qfle3f_processScsiCommandCompletion",
        "qfle3f_post_ioRequest"             :   "qfle3f_postIORequest",


# New replacement - Start
        "target_id"                         :   "targetID",
        "tgt_ofld_list"                     :   "targetOffloadList",
        "tgt_lock"                          :   "targetLock",
        "tgt"                               :   "target",
        "timer_work_queue"          :   "timerWorkQueue",
        "initiator_port_id"         :   "initatorPortID",
        "qlfcoe_adapter"            :   "qlfcoeAdapter",
        "io_dma_engine"             :   "ioDMAEngine",
#        "task_ctx"                  :   "taskContext",
        "hba_lock"                  :   "hbaLock",
        "hba_mutex"                 :   "hbaMutex",
        "hba_state"                 :   "hbaState",
        "init_done"                 :   "initDone",
        "data_src_addr"             :   "dataSourceMacAddress",
        "granted_mac"               :   "grantedMacAddress",
        "ffa_fcoe_mac"               :   "ffaFCoEMacAddress",
        "fdmi_cur_state"             :   "FDMICurrentState",
        "bk_thread"                  :   "backgroundThread",
        "bk_mutex"                   :   "backgroundMutex",
        "ioctl_mem_phys"             :   "ioctlMemPhysical",
        "ioctl_mem"                  :   "ioctlMem",
        "ioctl_mutex"                :   "ioctlMutex",

        "vlan_disc_timeout_wq"       :   "vlanDiscoveryTimeoutWorkQueue",

#        "context_id"                 :   "contextID",
        "fcluns_list_lck"            :   "fclunsListLock",
        "port_id"                    :   "targetPortID",
#        "sid"                        :   "initiatorPortID",
        "port_type"              :   "portType",
        "local_flags"            :   "localFlags",
        "cur_sq"                 :   "currentSendQueue",
        "sq_prod_idx"            :   "sendQueueProducerIndex",
        "sq_curr_toggle_bit"     :   "sendQueueCurrentToggleBit",
        "cq_cons_idx"            :   "completionQueueConstIndex",
        "cq_curr_toggle_bit"     :   "completionQueueCurrentToggleBit",
        "cq_lock"                :   "completionQueueLock",
        "active_cmds"            :   "activeCommands",
        "flush_in_prog"          :   "flushInProgress",
        "els_queue"              :   "elsQueue",
        "io_retire_queue"        :   "ioRetireQueue",
        "active_tm_queue"        :   "activeTaskManagementQueue",
        "cmd_list_lck"           :   "commandListLock",
        "maxframe_size"          :   "maxFrameSize",
        "supported_classes"     :   "supportedClasses",
        "dev_loss_tmo"          :   "devLossTimeout",
        "node_name"             :   "nodeName",
        "port_name"             :   "portName",
        "port_state"            :   "portState",
        "fast_io_fail_tmo"      :   "fastIOFailTimeout",

# New replacement - End

        "struct list_head" : "vmk_ListLinks",
        "struct kref"  :  "vmk_atomic64",
        "struct mutex" :  "vmk_Lock",
        "spinlock_t"   :  "vmk_Lock",
        "dma_addr_t *" :  "void *",
        "dma_addr_t"   :  "vmk_IOA",
        "struct task_struct *" : "vmk_WorldID ",
        "atomic_t"     :  "vmk_atomic64",
        "size_t"       :  "vmk_uint64",
        "struct fc_frame" : "FC_FRAME_HEADER",
        "off_t"        :  "vmk_uint64",
        "vmk_scsi_hba" :  "scsiAdapter",
        "kzalloc\("      :  "qfle3f_alloc(",
        "kmalloc\("      :  "qfle3f_alloc(",
        "kfree\("        :  "qfle3f_free(",
        ", GFP_KERNEL" :  "",
        ",GFP_KERNEL"  :  "",
        ", GFP_ATOMIC" :  "",
        ",GFP_ATOMIC"  :  "",
        "unlikely"     :  "VMK_UNLIKELY",
        "KERN_ERR"     :  "",
        "KERN_ALERT"     :  "",
        "KERN_INFO"    :  "",

		"spin_lock_bh"	:	"vmk_SpinlockLock",
		"spin_unlock_bh"	:	"vmk_SpinlockUnlock",

		"kref_init"		:	"ql_vmk_ref_init",
		"kref_put"		:	"ql_vmk_ref_put",
		"kref_get"		:	"ql_vmk_ref_get",

        "QFLE3F_ERR\("   :  "qfle3f_err(hba, ",
        "strncpy"        :  "vmk_StringCopy",
        "mutex_lock"     :  "vmk_SemaLock",
        "mutex_unlock"  :   "vmk_SemaUnlock",

        "find_first_zero_bit"   :   "vmk_BitVectorNextBit",
        "test_and_clear_bit"    :   "vmk_BitVectorAtomicTestAndClear",
        "test_and_set_bit"    :   "vmk_BitVectorAtomicTestAndSet",
        "set_bit"        :  "vmk_BitVectorSet",
        "test_bit"       :  "vmk_BitVectorTest",
        "clear_bit"      :  "vmk_BitVectorClear",

		"qfle3f_dbg\("	 :  "qfle3f_log(hba, ",
		"qfle3f_alloc_dma"	:  "qfle3f_dma_alloc",

		"memset"			:  "vmk_Memset",
		"memcpy"			:  "vmk_Memcpy",

		"__constant_htonl\("	:	 "vmk_CPUToBE32(",
		"htonl\("				:    "vmk_CPUToBE32(",
		"htons\("				:	 "vmk_CPUToBE16(",
		"ntohl\("				:    "vmk_BE32ToCPU(",
		"ntohs\("				:	 "vmk_BE16ToCPU(",

		"qfle3f_error"			:	"qfle3f_err",
		"cpu_to_be16"			:	"vmk_CPUToBE16",
		"cpu_to_be32"			:	"vmk_CPUToBE32",
		"cpu_to_be64"			:	"vmk_CPUToBE64",
		"be16_to_cpu"			:	"vmk_CPUToBE16",
		"be32_to_cpu"           :	"vmk_CPUToBE32",
		"be64_to_cpu"           :	"vmk_CPUToBE64",

		"wmb"					:	"vmk_CPUMemFenceWrite",
		"mmiowb"				:	"vmk_CPUMemFenceWrite",
		"FC_XID_UNKNOWN"		:	"INVALID_EXCHANGE_IDENTIFIER",

		"struct scsi_cmnd"		:	"vmk_ScsiCommand",

		"atomic_set"			:	"vmk_AtomicWrite64",
		"atomic_get"			:	"vmk_AtomicRead64",

		"printk"				:	"vmk_LogMessage",

		"INIT_LIST_HEAD"		:	"vmk_ListInit",
#		r"\(" : r"( ",
#		r"\)" : r" )",
		r"\( " : r"(",
		r" \)" : r")",
	}
	try:
		currDir = getcwd()
		allFileNames = []
		print "currDir : " + currDir
		for dirname, dirnames, filenames in os.walk('.'):
			for oneFile in filenames:
				sourceFile = re.match("qfle3f", oneFile)
				if (isinstance(sourceFile, types.NoneType)):
					continue

				if (oneFile[len(oneFile)-1] == 'h') or (oneFile[len(oneFile)-1] == 'c'):
					if dirname == ".":
						allFileNames.append(oneFile);

		for fileName in allFileNames:
			print "Processing File : " + fileName
			print "============================="

			fh, abs_path = mkstemp()
			with open(abs_path,'w') as new_file:
				with open(fileName, "r+") as old_file:
					for line in old_file:
						newLine = line
						#newLine = searchAndReplace(newLine)
						for key, value in simplePattern.iteritems():
							newLine = simpleSearchAndReplace(newLine, key, value)
						#newLine = convertHungarian(newLine)
						new_file.write(newLine)
			close(fh)
			#Remove original file
			remove(fileName)
			#Move new file
			move(abs_path, fileName)

	except Exception, e:
                print type(e)     # the exception instance
                print e.args      # arguments stored in .args
                print e           # __str__ allows args to printed directly
		traceback.print_exc()
	pass

if __name__ == '__main__':
	main(sys.argv[1:])
