/******************************************************************************
* The information contained in this file is confidential and proprietary to
* QLogic Corporation. No part of this file may be reproduced or
* distributed, in any form or by any means for any purpose, without the
* express written permission of QLogic Corporation.
*
*              Copyright (c) 2015 QLogic Corporation
*                        All rights reserved
*******************************************************************************/

#include "qfle3_mgmt_api.h"

vmk_MgmtCallbackInfo qfle3_mgmt_callbacks[QFLE3_NUM_CALLBACKS] = {
   {
    .location = VMK_MGMT_CALLBACK_KERNEL,
    .callback = qfle3_callback,
    .synchronous = 1,
    .numParms = 1,
    .parmSizes = {sizeof(qfle3_mgmt_data_t)}
    ,
    .parmTypes = {VMK_MGMT_PARMTYPE_INOUT}
    ,
    .callbackId = QFLE3_DO_CALLBACK,
    }
   ,
   {
    .location = VMK_MGMT_CALLBACK_KERNEL,
    .callback = qfle3_npar_callback,
    .synchronous = 1,
    .numParms = 2,
    .parmSizes = {sizeof(qfle3_npar_sriov_cmd_t), sizeof(qfle3_pf_data_t)}
    ,
    .parmTypes = {VMK_MGMT_PARMTYPE_IN, VMK_MGMT_PARMTYPE_INOUT}
    ,
    .callbackId = QFLE3_NPAR_CALLBACK,
    }
   ,
   {
    .location = VMK_MGMT_CALLBACK_KERNEL,
    .callback = qfle3_sriov_callback,
    .synchronous = 1,
    .numParms = 2,
    .parmSizes =
    {sizeof(qfle3_npar_sriov_cmd_t), sizeof(qfle3_sriov_vf_data_t)}
    ,
    .parmTypes = {VMK_MGMT_PARMTYPE_IN, VMK_MGMT_PARMTYPE_INOUT}
    ,
    .callbackId = QFLE3_SRIOV_CALLBACK,
    }
   ,
   {
    .location = VMK_MGMT_CALLBACK_KERNEL,
    .callback = qfle3_module_data,
    .synchronous = 1,
    .numParms = 1,
    .parmSizes = {sizeof(qfle3_module_data_t)}
    ,
    .parmTypes = {VMK_MGMT_PARMTYPE_OUT}
    ,
    .callbackId = QFLE3_MODULE_DATA,
    }
   ,
   {
    .location = VMK_MGMT_CALLBACK_KERNEL,
    .callback = qfle3_instance_info,
    .synchronous = 1,
    .numParms = 1,
    .parmSizes = {sizeof(qfle3_instance_info_t)}
    ,
    .parmTypes = {VMK_MGMT_PARMTYPE_OUT}
    ,
    .callbackId = QFLE3_INSTANCE_INFO,
    }
   ,
   {
    .location = VMK_MGMT_CALLBACK_KERNEL,
    .callback = qfle3_statistics,
    .synchronous = 1,
    .numParms = 1,
    .parmSizes = {sizeof(qfle3_statistics_t)}
    ,
    .parmTypes = {VMK_MGMT_PARMTYPE_OUT}
    ,
    .callbackId = QFLE3_STATISTICS,
    }
   ,
   {
    .location = VMK_MGMT_CALLBACK_KERNEL,
    .callback = qfle3_diag_callback,
    .synchronous = 1,
    .numParms = 1,
    .parmSizes = {sizeof(qfle3_diag_data_t)}
    ,
    .parmTypes = {VMK_MGMT_PARMTYPE_INOUT}
    ,
    .callbackId = QEDENTV_DIAG_CALLBACK,
    }
   ,
   {
    .location = VMK_MGMT_CALLBACK_KERNEL,
    .callback = qfle3_nvm_callback,
    .synchronous = 1,
    .numParms = 1,
    .parmSizes = {sizeof(qfle3_nvm_data_t)}
    ,
    .parmTypes = {VMK_MGMT_PARMTYPE_INOUT}
    ,
    .callbackId = QEDENTV_NVM_CALLBACK,
    }
   ,
   {
    .location = VMK_MGMT_CALLBACK_KERNEL,
    .callback = qfle3_phy_reg_callback,
    .synchronous = 1,
    .numParms = 2,
    .parmSizes = {sizeof(qfle3_phy_cmd_t), sizeof(qfle3_phy_data_t)}
    ,
    .parmTypes = {VMK_MGMT_PARMTYPE_IN, VMK_MGMT_PARMTYPE_INOUT}
    ,
    .callbackId = QFLE3_PHY_CALLBACK,
    }
   ,
};

vmk_MgmtApiSignature qfle3_api_sig = {
   .version = QFLE3_INTERFACE_VERSION,
   .name.string = QFLE3_INTERFACE_NAME,
   .vendor.string = QFLE3_INTERFACE_VENDOR,
   .numCallbacks = QFLE3_NUM_CALLBACKS,
   .callbacks = qfle3_mgmt_callbacks,
};
