/* netAlign.c was originally generated by the autoSql program, which also 
 * generated netAlign.h and netAlign.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "netAlign.h"


void netAlignStaticLoad(char **row, struct netAlign *ret)
/* Load a row from netAlign table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->level = sqlUnsigned(row[0]);
ret->tName = row[1];
ret->tStart = sqlUnsigned(row[2]);
ret->tEnd = sqlUnsigned(row[3]);
strcpy(ret->strand, row[4]);
ret->qName = row[5];
ret->qStart = sqlUnsigned(row[6]);
ret->qEnd = sqlUnsigned(row[7]);
ret->chainId = sqlUnsigned(row[8]);
ret->ali = sqlUnsigned(row[9]);
ret->score = atof(row[10]);
ret->qOver = sqlSigned(row[11]);
ret->qFar = sqlSigned(row[12]);
ret->qDup = sqlSigned(row[13]);
ret->type = row[14];
ret->tN = sqlSigned(row[15]);
ret->qN = sqlSigned(row[16]);
ret->tR = sqlSigned(row[17]);
ret->qR = sqlSigned(row[18]);
ret->tNewR = sqlSigned(row[19]);
ret->qNewR = sqlSigned(row[20]);
ret->tOldR = sqlSigned(row[21]);
ret->qOldR = sqlSigned(row[22]);
ret->tTrf = sqlSigned(row[23]);
ret->qTrf = sqlSigned(row[24]);
}

struct netAlign *netAlignLoad(char **row)
/* Load a netAlign from row fetched with select * from netAlign
 * from database.  Dispose of this with netAlignFree(). */
{
struct netAlign *ret;

AllocVar(ret);
ret->level = sqlUnsigned(row[0]);
ret->tName = cloneString(row[1]);
ret->tStart = sqlUnsigned(row[2]);
ret->tEnd = sqlUnsigned(row[3]);
strcpy(ret->strand, row[4]);
ret->qName = cloneString(row[5]);
ret->qStart = sqlUnsigned(row[6]);
ret->qEnd = sqlUnsigned(row[7]);
ret->chainId = sqlUnsigned(row[8]);
ret->ali = sqlUnsigned(row[9]);
ret->score = atof(row[10]);
ret->qOver = sqlSigned(row[11]);
ret->qFar = sqlSigned(row[12]);
ret->qDup = sqlSigned(row[13]);
ret->type = cloneString(row[14]);
ret->tN = sqlSigned(row[15]);
ret->qN = sqlSigned(row[16]);
ret->tR = sqlSigned(row[17]);
ret->qR = sqlSigned(row[18]);
ret->tNewR = sqlSigned(row[19]);
ret->qNewR = sqlSigned(row[20]);
ret->tOldR = sqlSigned(row[21]);
ret->qOldR = sqlSigned(row[22]);
ret->tTrf = sqlSigned(row[23]);
ret->qTrf = sqlSigned(row[24]);
return ret;
}

struct netAlign *netAlignLoadAll(char *fileName) 
/* Load all netAlign from a tab-separated file.
 * Dispose of this with netAlignFreeList(). */
{
struct netAlign *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[25];

while (lineFileRow(lf, row))
    {
    el = netAlignLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct netAlign *netAlignCommaIn(char **pS, struct netAlign *ret)
/* Create a netAlign out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new netAlign */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->level = sqlUnsignedComma(&s);
ret->tName = sqlStringComma(&s);
ret->tStart = sqlUnsignedComma(&s);
ret->tEnd = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->qName = sqlStringComma(&s);
ret->qStart = sqlUnsignedComma(&s);
ret->qEnd = sqlUnsignedComma(&s);
ret->chainId = sqlUnsignedComma(&s);
ret->ali = sqlUnsignedComma(&s);
ret->score = sqlDoubleComma(&s);
ret->qOver = sqlSignedComma(&s);
ret->qFar = sqlSignedComma(&s);
ret->qDup = sqlSignedComma(&s);
ret->type = sqlStringComma(&s);
ret->tN = sqlSignedComma(&s);
ret->qN = sqlSignedComma(&s);
ret->tR = sqlSignedComma(&s);
ret->qR = sqlSignedComma(&s);
ret->tNewR = sqlSignedComma(&s);
ret->qNewR = sqlSignedComma(&s);
ret->tOldR = sqlSignedComma(&s);
ret->qOldR = sqlSignedComma(&s);
ret->tTrf = sqlSignedComma(&s);
ret->qTrf = sqlSignedComma(&s);
*pS = s;
return ret;
}

void netAlignFree(struct netAlign **pEl)
/* Free a single dynamically allocated netAlign such as created
 * with netAlignLoad(). */
{
struct netAlign *el;

if ((el = *pEl) == NULL) return;
freeMem(el->tName);
freeMem(el->qName);
freeMem(el->type);
freez(pEl);
}

void netAlignFreeList(struct netAlign **pList)
/* Free a list of dynamically allocated netAlign's */
{
struct netAlign *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    netAlignFree(&el);
    }
*pList = NULL;
}

void netAlignOutput(struct netAlign *el, FILE *f, char sep, char lastSep) 
/* Print out netAlign.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->level);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->tStart);
fputc(sep,f);
fprintf(f, "%u", el->tEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->qName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->qStart);
fputc(sep,f);
fprintf(f, "%u", el->qEnd);
fputc(sep,f);
fprintf(f, "%u", el->chainId);
fputc(sep,f);
fprintf(f, "%u", el->ali);
fputc(sep,f);
fprintf(f, "%f", el->score);
fputc(sep,f);
fprintf(f, "%d", el->qOver);
fputc(sep,f);
fprintf(f, "%d", el->qFar);
fputc(sep,f);
fprintf(f, "%d", el->qDup);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->type);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->tN);
fputc(sep,f);
fprintf(f, "%d", el->qN);
fputc(sep,f);
fprintf(f, "%d", el->tR);
fputc(sep,f);
fprintf(f, "%d", el->qR);
fputc(sep,f);
fprintf(f, "%d", el->tNewR);
fputc(sep,f);
fprintf(f, "%d", el->qNewR);
fputc(sep,f);
fprintf(f, "%d", el->tOldR);
fputc(sep,f);
fprintf(f, "%d", el->qOldR);
fputc(sep,f);
fprintf(f, "%d", el->tTrf);
fputc(sep,f);
fprintf(f, "%d", el->qTrf);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

