/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.browser;

import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.SlaveBrowser;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserReaper
extends TimerTask {
    private static final Logger logger = LoggerFactory.getLogger(BrowserReaper.class);
    private final CapturedBrowsers capturedBrowsers;

    public BrowserReaper(CapturedBrowsers capturedBrowsers) {
        this.capturedBrowsers = capturedBrowsers;
    }

    public void run() {
        for (SlaveBrowser browser : this.capturedBrowsers.getSlaveBrowsers()) {
            if (browser.isAlive() || browser.isCommandRunning()) continue;
            logger.debug("Reaping dead {}.", browser);
            this.capturedBrowsers.removeSlave(browser.getId());
        }
    }
}

