proc CreateVec1 { vecType size } {
    set v [$vecType]
    if { $size == 2 } {
        $v set 1 2
    } elseif { $size == 3 } {
        $v set 1 2 3
    } else {
        $v set 1 2 3 4
    }
    return $v
}

proc CreateVec2 { vecType size } {
    if { $size == 2 } {
        set v [$vecType -args 1 2]
    } elseif { $size == 3 } {
        set v [$vecType -args 1 2 3]
    } else {
        set v [$vecType -args 1 2 3 4]
    }
    return $v
}

proc CreateUnitVec { vecType size axis } {
    set v [$vecType]
    $v setElem $axis 1
    return $v
}

proc CreateDefaultQuat { quatType } {
    return [$quatType]
}

proc CreateQuat1 { quatType } {
    set q [$quatType]
    $q set 1 2 3 4
    return $q
}

proc CreateQuat2 { quatType } {
    set q [$quatType -args 1 2 3 4]
    return $q
}

proc CreatePlane1 { planeType } {
    set p [$planeType]
    $p set 1 2 3 4
    return $p
}

proc CreatePlane2 { quatType } {
    set p [$planeType -args 1 2 3 4]
    return $p
}

proc CreateBBox1 {} {
    set bv [osg::BoundingBox]
    $bv set 1 2 3  4 5 6
    return $bv
}

proc CreateBBox2 {} {
    set bv [osg::BoundingBox -args 1 2 3  4 5 6]
    return $bv
}

proc CreateBSphere1 {} {
    set bv [osg::BoundingSphere]
    $bv set [osg::Vec3 -args 1 2 3] 4.0
    return $bv
}

proc CreateBSphere2 {} {
    set bv [osg::BoundingSphere -args [osg::Vec3 -args 1 2 3] 4]
    return $bv
}

proc PN { msg } {
    puts -nonewline [format "%-25s" $msg]
    puts -nonewline " : "
    flush stdout
}

proc P { msg } {
    if { [string is integer $msg] } {
        puts $msg
    } elseif { [string is double $msg] } {
        puts [format "%.4f" $msg]
    } else {
        puts $msg
    }
    flush stdout
}

proc PV { vec } {
    tcl3dOsgVecPrint $vec "%.3f"
}

proc PQ { quat } {
    tcl3dOsgVecPrint $quat "%.4f"
}

proc PP { plane } {
    tcl3dOsgVecPrint $plane "%.4f"
}

proc PM { mat { leadingNewLine true } } {
    if { $leadingNewLine } {
        P ""
    }
    tcl3dOsgMatPrint $mat "%.3f"
}

proc PBB { bbox { precisionString "%.3f" } } {
    tcl3dOsgBBoxPrint $bbox $precisionString
}

proc PBS { bsph { precisionString "%.3f" } } {
    tcl3dOsgBSpherePrint $bsph $precisionString
}

# A SWIG pointer looks like follows: _205b0b09_p_double.
# Extract everything after the pointer address, ex. p_double.
proc GetPointerType { p } {
    set trimmed [string trimleft $p "_"]
    set ind [string first "_" $trimmed]
    return [string range $trimmed [expr $ind +1] end]
}
